/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.ui.videos;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.Adapter.PlayerUiController;
import app.firezone.synk.network.Adapter.VideoAdapter;
import app.firezone.synk.network.databinding.FragmentVideoBinding;
import app.firezone.synk.network.model.VideoModel;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.YouTubePlayer;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.listeners.AbstractYouTubePlayerListener;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.listeners.YouTubePlayerListener;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.options.IFramePlayerOptions;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.utils.YouTubePlayerUtils;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.views.YouTubePlayerView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class VideoFragment
extends Fragment {
    FragmentVideoBinding binding;
    ArrayList<VideoModel> mlist = new ArrayList();
    VideoAdapter adapter;
    Dialog dialog;

    @SuppressLint(value={"MissingInflatedId"})
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.binding = FragmentVideoBinding.inflate(inflater, container, false);
        ConstraintLayout root = this.binding.getRoot();
        this.dialog = new Dialog(this.getContext());
        this.dialog.setContentView(2131558570);
        if (this.dialog.getWindow() != null) {
            this.dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.dialog.setCancelable(true);
        }
        this.dialog.show();
        this.fetchVideosFromApi();
        GridLayoutManager layoutManager = new GridLayoutManager(this.getContext(), 2);
        this.binding.videoRecy.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.adapter = new VideoAdapter(this.getContext(), this.mlist, this.getViewLifecycleOwner());
        this.binding.videoRecy.setAdapter((RecyclerView.Adapter)this.adapter);
        this.binding.videoRecy.setHasFixedSize(true);
        return root;
    }

    private void fetchVideosFromApi() {
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        Call<ArrayList<VideoModel>> call = myApi.fetchVideos();
        call.enqueue((Callback)new Callback<ArrayList<VideoModel>>(){

            public void onResponse(Call<ArrayList<VideoModel>> call, Response<ArrayList<VideoModel>> response) {
                if (response.isSuccessful() && response.body() != null) {
                    VideoFragment.this.mlist.clear();
                    VideoFragment.this.mlist.addAll((Collection)response.body());
                    Collections.reverse(VideoFragment.this.mlist);
                    VideoFragment.this.dialog.dismiss();
                    VideoFragment.this.adapter.notifyDataSetChanged();
                    if (!VideoFragment.this.mlist.isEmpty()) {
                        VideoFragment.this.setupYouTubePlayer(VideoFragment.this.mlist.get(0));
                    }
                } else {
                    VideoFragment.this.dialog.dismiss();
                    Toast.makeText((Context)VideoFragment.this.getContext(), (CharSequence)"Failed to fetch videos", (int)0).show();
                }
            }

            public void onFailure(Call<ArrayList<VideoModel>> call, Throwable t) {
                VideoFragment.this.dialog.dismiss();
                Toast.makeText((Context)VideoFragment.this.getContext(), (CharSequence)("Error: " + t.getMessage()), (int)0).show();
            }
        });
    }

    private void setupYouTubePlayer(VideoModel model) {
        final YouTubePlayerView youTubePlayerView = this.binding.youtubePlayerView;
        this.getLifecycle().addObserver((LifecycleObserver)youTubePlayerView);
        youTubePlayerView.setEnableAutomaticInitialization(false);
        final String videoId = this.extractYouTubeVideoId(model.getVideourl());
        if (videoId == null || videoId.isEmpty()) {
            Toast.makeText((Context)this.getContext(), (CharSequence)"Invalid video URL", (int)0).show();
            return;
        }
        final View controlUi = youTubePlayerView.inflateCustomPlayerUi(2131558491);
        AbstractYouTubePlayerListener youTubePlayerListener = new AbstractYouTubePlayerListener(){

            public void onReady(@NonNull YouTubePlayer youTubePlayer) {
                PlayerUiController controller = new PlayerUiController(controlUi, youTubePlayer, youTubePlayerView);
                youTubePlayer.addListener((YouTubePlayerListener)controller);
                YouTubePlayerUtils.loadOrCueVideo((YouTubePlayer)youTubePlayer, (Lifecycle)VideoFragment.this.getLifecycle(), (String)videoId, (float)0.0f);
            }
        };
        IFramePlayerOptions options = new IFramePlayerOptions.Builder().controls(0).build();
        youTubePlayerView.initialize((YouTubePlayerListener)youTubePlayerListener, options);
    }

    private String extractYouTubeVideoId(String videoUrl) {
        if (videoUrl == null || videoUrl.trim().isEmpty()) {
            return null;
        }
        String videoId = null;
        try {
            Pattern pattern = Pattern.compile("(?:https?://)?(?:www\\.)?(?:youtube\\.com|youtu\\.be)/(?:watch\\?v=|embed/|v/|e/|shorts/|live/|.*[?&]v=)?([a-zA-Z0-9_-]{11})", 2);
            Matcher matcher = pattern.matcher(videoUrl);
            if (matcher.find()) {
                videoId = matcher.group(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return videoId;
    }
}

