/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import app.firezone.synk.network.MainActivity;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class MyFirebaseMessagingService
extends FirebaseMessagingService {
    private static final String CHANNEL_ID = "paper";

    public void onCreate() {
        super.onCreate();
        this.createNotificationChannel();
    }

    public void onMessageReceived(@NonNull RemoteMessage message) {
        super.onMessageReceived(message);
        String title = this.getString(2131951651);
        String msg = "";
        String image = "";
        if (message.getNotification() != null) {
            title = message.getNotification().getTitle();
            msg = message.getNotification().getBody();
        }
        if (message.getData().size() > 0) {
            if (message.getData().containsKey("title")) {
                title = (String)message.getData().get("title");
            }
            if (message.getData().containsKey("message")) {
                msg = (String)message.getData().get("message");
            }
            if (message.getData().containsKey("image")) {
                image = (String)message.getData().get("image");
            }
        }
        this.showNotification(title, msg, image);
    }

    private void showNotification(String title, String msg, String imageUrl) {
        Intent intent = new Intent((Context)this, MainActivity.class);
        intent.addFlags(0x14000000);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)intent, (int)0x44000000);
        NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)this, CHANNEL_ID).setSmallIcon(2131755008).setContentTitle((CharSequence)(title != null ? title : this.getString(2131951651))).setContentText((CharSequence)(msg != null ? msg : "")).setAutoCancel(true).setContentIntent(pendingIntent).setPriority(1);
        if (imageUrl != null && !imageUrl.isEmpty()) {
            try {
                URL url = new URL(imageUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setDoInput(true);
                connection.connect();
                InputStream input = connection.getInputStream();
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)input);
                builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture(bitmap).bigLargeIcon((Bitmap)null));
            }
            catch (Exception e) {
                Log.e((String)"FirebaseMsgService", (String)("Image load failed: " + e.getMessage()));
            }
        }
        NotificationManagerCompat managerCompat = NotificationManagerCompat.from((Context)this);
        if (ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.POST_NOTIFICATIONS") != 0) {
            Log.w((String)"FirebaseMsgService", (String)"Notification permission not granted.");
            return;
        }
        managerCompat.notify(101, builder.build());
    }

    private void createNotificationChannel() {
        if (Build.VERSION.SDK_INT >= 26) {
            String name = "Champion Dangal Notifications";
            String description = "Channel for general notifications";
            int importance = 4;
            NotificationChannel channel = new NotificationChannel(CHANNEL_ID, (CharSequence)name, importance);
            channel.setDescription(description);
            channel.enableLights(true);
            channel.setLightColor(-65536);
            channel.enableVibration(true);
            NotificationManager notificationManager = (NotificationManager)this.getSystemService(NotificationManager.class);
            if (notificationManager != null) {
                notificationManager.createNotificationChannel(channel);
            }
        }
    }
}

