/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Adapter.SlotAdapter;
import app.firezone.synk.network.MatchJoiningActivity;
import app.firezone.synk.network.databinding.ActivityMatchSlotsBinding;
import app.firezone.synk.network.model.Joined_Match_Model;
import app.firezone.synk.network.model.SlotItem;
import java.util.ArrayList;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class MatchSlotsActivity
extends AppCompatActivity {
    ActivityMatchSlotsBinding binding;
    String gamename;
    String teamType;
    long totalPlayer;
    long matchId;
    long entryFee;
    long userId;
    ArrayList<SlotItem> slotList;
    SlotAdapter adapter;
    private MyApi myApi;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityMatchSlotsBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.gamename = this.getIntent().getStringExtra("gamename");
        this.teamType = this.getIntent().getStringExtra("teamType");
        this.totalPlayer = this.getIntent().getLongExtra("totalPlayer", 0L);
        this.entryFee = this.getIntent().getLongExtra("entryFee", 0L);
        this.matchId = this.getIntent().getLongExtra("matchId", 0L);
        this.userId = SharedPrefManager.getInstance((Context)this).getUserId();
        this.myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        if (this.teamType.equalsIgnoreCase("Duo")) {
            this.binding.textB.setVisibility(0);
        } else if (this.teamType.equalsIgnoreCase("Squad")) {
            this.binding.textB.setVisibility(0);
            this.binding.textC.setVisibility(0);
            this.binding.textD.setVisibility(0);
        }
        this.binding.backArrow.setOnClickListener(v -> this.finish());
        this.loadSlotList();
        this.adapter = new SlotAdapter((Context)this, this.slotList, this.teamType);
        this.binding.slotsRecycler.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.binding.slotsRecycler.setAdapter((RecyclerView.Adapter)this.adapter);
        this.binding.nextBtn.setOnClickListener(v -> {
            ArrayList<String> selectedSlotNumbers = new ArrayList<String>();
            ArrayList<String> selectedPositions = new ArrayList<String>();
            int totalSelected = 0;
            for (SlotItem item : this.slotList) {
                if (item.isCheckedA && !item.isJoinedA) {
                    selectedSlotNumbers.add(String.valueOf(item.slotNumber));
                    selectedPositions.add("A");
                    ++totalSelected;
                }
                if (item.isCheckedB && !item.isJoinedB) {
                    selectedSlotNumbers.add(String.valueOf(item.slotNumber));
                    selectedPositions.add("B");
                    ++totalSelected;
                }
                if (item.isCheckedC && !item.isJoinedC) {
                    selectedSlotNumbers.add(String.valueOf(item.slotNumber));
                    selectedPositions.add("C");
                    ++totalSelected;
                }
                if (!item.isCheckedD || item.isJoinedD) continue;
                selectedSlotNumbers.add(String.valueOf(item.slotNumber));
                selectedPositions.add("D");
                ++totalSelected;
            }
            if (totalSelected == 0) {
                Toast.makeText((Context)this, (CharSequence)"Please select your slot!", (int)0).show();
            } else {
                Intent intent = new Intent((Context)this, MatchJoiningActivity.class);
                intent.putStringArrayListExtra("selectedSlotNumbers", selectedSlotNumbers);
                intent.putStringArrayListExtra("selectedPositions", selectedPositions);
                intent.putExtra("totalSelection", totalSelected);
                intent.putExtra("matchId", this.matchId);
                intent.putExtra("gamename", this.gamename);
                intent.putExtra("entryFee", this.entryFee);
                this.startActivity(intent);
            }
        });
        this.checkJoinedPositionBox();
    }

    private void loadSlotList() {
        int divideBy = this.teamType.equalsIgnoreCase("Solo") ? 1 : (this.teamType.equalsIgnoreCase("Duo") ? 2 : 4);
        int rows = (int)(this.totalPlayer / (long)divideBy);
        this.slotList = new ArrayList();
        for (int i = 1; i <= rows; ++i) {
            this.slotList.add(new SlotItem(i));
        }
    }

    public void checkJoinedPositionBox() {
        Call<ArrayList<Joined_Match_Model>> call = this.myApi.fetchMatchJoinedUsers(this.matchId);
        call.enqueue((Callback)new Callback<ArrayList<Joined_Match_Model>>(){

            public void onResponse(Call<ArrayList<Joined_Match_Model>> call, Response<ArrayList<Joined_Match_Model>> response) {
                if (response.isSuccessful() && response.body() != null) {
                    for (Joined_Match_Model joined : (ArrayList)response.body()) {
                        int slotNo = joined.getSlot_no();
                        String position = joined.getPosition();
                        for (SlotItem item : MatchSlotsActivity.this.slotList) {
                            if (item.getSlotNumber() != slotNo) continue;
                            switch (position) {
                                case "A": {
                                    item.isCheckedA = true;
                                    item.isJoinedA = true;
                                    break;
                                }
                                case "B": {
                                    item.isCheckedB = true;
                                    item.isJoinedB = true;
                                    break;
                                }
                                case "C": {
                                    item.isCheckedC = true;
                                    item.isJoinedC = true;
                                    break;
                                }
                                case "D": {
                                    item.isCheckedD = true;
                                    item.isJoinedD = true;
                                }
                            }
                        }
                    }
                    MatchSlotsActivity.this.adapter.notifyDataSetChanged();
                }
            }

            public void onFailure(Call<ArrayList<Joined_Match_Model>> call, Throwable t) {
                Toast.makeText((Context)MatchSlotsActivity.this, (CharSequence)("Failed: " + t.getMessage()), (int)0).show();
            }
        });
    }
}

