/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.constraintlayout.widget.ConstraintLayout;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Activities.Add_Money_Activity;
import app.firezone.synk.network.MainActivity;
import app.firezone.synk.network.databinding.ActivityMatchJoiningBinding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.JoinedMatchResponse;
import app.firezone.synk.network.model.TransactionModel;
import app.firezone.synk.network.model.User;
import app.firezone.synk.network.model.UserResponse;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class MatchJoiningActivity
extends AppCompatActivity {
    ActivityMatchJoiningBinding binding;
    ArrayList<String> slotsNoList;
    ArrayList<String> checkboxNoList;
    int totalChecked;
    long userId;
    String gamename;
    String email;
    String name;
    String m;
    long matchId;
    long entryFee;
    long winBalance;
    long depoBalance;
    long bonusBalance;
    long totalCoin;
    long totalFee;
    long matchPlayed;
    private MyApi myApi;
    ProgressDialog progressDialog;
    long requiredFee;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityMatchJoiningBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.slotsNoList = this.getIntent().getStringArrayListExtra("selectedSlotNumbers");
        this.checkboxNoList = this.getIntent().getStringArrayListExtra("selectedPositions");
        this.totalChecked = this.getIntent().getIntExtra("totalSelection", 0);
        this.gamename = this.getIntent().getStringExtra("gamename");
        this.entryFee = this.getIntent().getLongExtra("entryFee", 0L);
        this.matchId = this.getIntent().getLongExtra("matchId", 0L);
        this.binding.pleaseWaitTxt.setVisibility(0);
        this.binding.balanceInfoTxt.setVisibility(8);
        this.binding.joinBtn.setVisibility(8);
        this.progressDialog = new ProgressDialog((Context)this);
        this.progressDialog.setTitle((CharSequence)"Joining Match");
        this.progressDialog.setMessage((CharSequence)"Please Wait.....");
        this.progressDialog.setCancelable(true);
        this.myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        this.userId = SharedPrefManager.getInstance((Context)this).getUserId();
        this.loadUserData();
        ConstraintLayout[] teamLayouts = new ConstraintLayout[]{this.binding.team1Layout, this.binding.team2Layout, this.binding.team3Layout, this.binding.team4Layout};
        TextView[] teamTexts = new TextView[]{this.binding.teamNo1, this.binding.teamNo2, this.binding.teamNo3, this.binding.teamNo4};
        TextView[] posTexts = new TextView[]{this.binding.positionNo1, this.binding.positionNo2, this.binding.positionNo3, this.binding.positionNo4};
        for (int i = 0; i < this.totalChecked; ++i) {
            int slotNum = Integer.parseInt(this.slotsNoList.get(i));
            String pos = this.checkboxNoList.get(i);
            teamLayouts[i].setVisibility(0);
            teamTexts[i].setText((CharSequence)("Team " + slotNum));
            posTexts[i].setText((CharSequence)("" + pos));
        }
        this.binding.joinBtn.setOnClickListener(v -> {
            String usernameEdt = this.binding.username1.getText().toString();
            long matchPlayeds = 1L;
            long finalPlayed = this.matchPlayed + matchPlayeds;
            long requiredFee = this.entryFee * (long)this.totalChecked;
            if (TextUtils.isEmpty((CharSequence)usernameEdt)) {
                this.binding.username1.setError((CharSequence)"Enter Username");
                Toast.makeText((Context)this, (CharSequence)"Enter Username", (int)0).show();
            } else if (usernameEdt.equals("Player 1")) {
                this.binding.username1.setError((CharSequence)"Enter Valid Username");
                Toast.makeText((Context)this, (CharSequence)"Enter Valid Username", (int)0).show();
            } else if (requiredFee <= this.totalCoin) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("username", usernameEdt);
                map.put("matchPlayed", finalPlayed);
                this.progressDialog.show();
                Call<UserResponse> call = this.myApi.updateUser(this.userId, map);
                call.enqueue((Callback)new Callback<UserResponse>(){

                    public void onResponse(Call<UserResponse> call, Response<UserResponse> response) {
                        MatchJoiningActivity.this.progressDialog.dismiss();
                        if (response.isSuccessful() && response.body() != null) {
                            Toast.makeText((Context)MatchJoiningActivity.this, (CharSequence)"Match Joined!", (int)0).show();
                            MatchJoiningActivity.this.deductCoin();
                        } else {
                            try {
                                String errorBody = response.errorBody().string();
                                Log.e((String)"API_ERROR", (String)("Error response: " + errorBody));
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            Toast.makeText((Context)MatchJoiningActivity.this, (CharSequence)"Failed to update user data.", (int)0).show();
                        }
                    }

                    public void onFailure(Call<UserResponse> call, Throwable throwable) {
                        MatchJoiningActivity.this.progressDialog.dismiss();
                        throwable.printStackTrace();
                        Log.e((String)"RETROFIT_FAILURE", (String)"Error cause: ", (Throwable)throwable);
                        Toast.makeText((Context)MatchJoiningActivity.this, (CharSequence)("Error: " + throwable.getMessage()), (int)1).show();
                    }
                });
            } else {
                Toast.makeText((Context)this, (CharSequence)"Not enough balance. Redirecting...", (int)0).show();
                this.startActivity(new Intent((Context)this, Add_Money_Activity.class));
            }
        });
        this.binding.team1Layout.setOnClickListener(v -> this.addUsernameDialog(this.binding.username1));
        this.binding.team2Layout.setOnClickListener(v -> this.addUsernameDialog(this.binding.username2));
        this.binding.team3Layout.setOnClickListener(v -> this.addUsernameDialog(this.binding.username3));
        this.binding.team4Layout.setOnClickListener(v -> this.addUsernameDialog(this.binding.username4));
    }

    private void deductCoin() {
        if (this.totalFee == 0L) {
            this.saveSoloMatchData(null);
        } else {
            long depoEntry;
            boolean canDeduct = false;
            HashMap<String, Object> coinMap = new HashMap<String, Object>();
            final HashMap<String, Long> originalBalance = new HashMap<String, Long>();
            originalBalance.put("depoBalance", this.depoBalance);
            originalBalance.put("bonusBalance", this.bonusBalance);
            originalBalance.put("winBalance", this.winBalance);
            if (this.totalFee <= this.depoBalance && this.bonusBalance >= 1L) {
                depoEntry = this.totalFee - 1L;
                long bonusBal = 1L;
                long depoBal = this.depoBalance - depoEntry;
                long bonBal = this.bonusBalance - bonusBal;
                coinMap.put("depoBalance", depoBal);
                coinMap.put("bonusBalance", bonBal);
                canDeduct = true;
            } else if (this.totalFee <= this.depoBalance) {
                long depoBal = this.depoBalance - this.totalFee;
                coinMap.put("depoBalance", depoBal);
                canDeduct = true;
            } else if (this.totalFee <= this.totalCoin && this.bonusBalance >= 1L) {
                depoEntry = this.totalFee - 1L;
                long bonusBal = 1L;
                long requiredCoin = depoEntry - this.depoBalance;
                long winCoin = this.winBalance - requiredCoin;
                coinMap.put("depoBalance", 0L);
                coinMap.put("bonusBalance", bonusBal);
                coinMap.put("winBalance", winCoin);
                canDeduct = true;
            } else if (this.totalFee <= this.totalCoin) {
                long requiredCoin = this.totalFee - this.depoBalance;
                long winCoin = this.winBalance - requiredCoin;
                coinMap.put("depoBalance", 0L);
                coinMap.put("winBalance", winCoin);
                canDeduct = true;
            }
            if (canDeduct) {
                MyApi myApi1 = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
                Call<UserResponse> updateCall = myApi1.updateUser(this.userId, coinMap);
                updateCall.enqueue((Callback)new Callback<UserResponse>(){

                    public void onResponse(Call<UserResponse> call, Response<UserResponse> response) {
                        if (response.isSuccessful() && response.body() != null) {
                            String transactionType = "Match Fee";
                            MatchJoiningActivity.this.saveUsersTransactionDetails(transactionType);
                            MatchJoiningActivity.this.saveSoloMatchData(originalBalance);
                        } else {
                            Log.e((String)"DeductCoinError", (String)("Failed to deduct coins. Response: " + response.message()));
                            Toast.makeText((Context)MatchJoiningActivity.this, (CharSequence)"Failed to deduct coins. Please try again.", (int)0).show();
                        }
                    }

                    public void onFailure(Call<UserResponse> call, Throwable t) {
                        Log.e((String)"DeductCoinError", (String)("API call failed: " + t.getMessage()));
                        Toast.makeText((Context)MatchJoiningActivity.this, (CharSequence)("Error: " + t.getMessage()), (int)0).show();
                    }
                });
            } else {
                Toast.makeText((Context)this, (CharSequence)"Not Enough Money", (int)0).show();
            }
        }
    }

    private void rollbackCoinDeduction(Map<String, Object> originalCoins) {
        if (originalCoins == null || originalCoins.isEmpty()) {
            return;
        }
        HashMap<String, Object> rollbackMap = new HashMap<String, Object>();
        if (originalCoins.containsKey("depoBalance")) {
            rollbackMap.put("depoBalance", originalCoins.get("depoBalance"));
        }
        if (originalCoins.containsKey("bonusBalance")) {
            rollbackMap.put("bonusBalance", originalCoins.get("bonusBalance"));
        }
        if (originalCoins.containsKey("winBalance")) {
            rollbackMap.put("winBalance", originalCoins.get("winBalance"));
        }
        Call<UserResponse> rollbackCall = this.myApi.updateUser(this.userId, rollbackMap);
        rollbackCall.enqueue((Callback)new Callback<UserResponse>(){

            public void onResponse(Call<UserResponse> call, Response<UserResponse> response) {
                if (response.isSuccessful()) {
                    String transactionType = "Refund";
                    MatchJoiningActivity.this.saveUsersTransactionDetails(transactionType);
                } else {
                    Toast.makeText((Context)MatchJoiningActivity.this, (CharSequence)"Failed to revert balance.", (int)0).show();
                }
                MatchJoiningActivity.this.progressDialog.dismiss();
            }

            public void onFailure(Call<UserResponse> call, Throwable t) {
                Toast.makeText((Context)MatchJoiningActivity.this, (CharSequence)("Error: " + t.getMessage()), (int)0).show();
                MatchJoiningActivity.this.progressDialog.dismiss();
            }
        });
    }

    private void saveSoloMatchData(final Map<String, Object> originalCoins) {
        if (this.gamename == null || this.matchId <= 0L || this.userId <= 0L) {
            Toast.makeText((Context)this, (CharSequence)"Invalid match details. Please try again.", (int)0).show();
            if (originalCoins != null) {
                this.rollbackCoinDeduction(originalCoins);
            }
            return;
        }
        String username1Edt = this.binding.username1.getText().toString();
        String slotText = this.binding.teamNo1.getText().toString();
        String numberOnly = slotText.replaceAll("[^0-9]", "");
        int slot_no = Integer.parseInt(numberOnly);
        String position = this.binding.positionNo1.getText().toString();
        Call<JoinedMatchResponse> call = this.myApi.storeMatchJoinedUser(this.matchId, this.email, username1Edt, this.name, this.gamename, "Expert", "0", "0", String.valueOf(this.entryFee), this.userId, username1Edt, slot_no, position);
        call.enqueue((Callback)new Callback<JoinedMatchResponse>(){

            public void onResponse(Call<JoinedMatchResponse> call, Response<JoinedMatchResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    if (((JoinedMatchResponse)response.body()).success) {
                        MatchJoiningActivity.this.binding.joinText.setText((CharSequence)"Already Joined");
                        MatchJoiningActivity.this.binding.joinBtn.setBackgroundResource(2131230896);
                        MatchJoiningActivity.this.binding.joinBtn.setClickable(false);
                        Toast.makeText((Context)MatchJoiningActivity.this, (CharSequence)"Joined Successfully...", (int)0).show();
                        MatchJoiningActivity.this.handleMatchRegistration();
                    } else {
                        Toast.makeText((Context)MatchJoiningActivity.this, (CharSequence)((JoinedMatchResponse)response.body()).message, (int)1).show();
                    }
                } else {
                    if (originalCoins != null) {
                        MatchJoiningActivity.this.rollbackCoinDeduction(originalCoins);
                    }
                    try {
                        String errorBody = response.errorBody().string();
                        Log.e((String)"JoinMatchError", (String)("Error Response: " + errorBody));
                        Toast.makeText((Context)MatchJoiningActivity.this, (CharSequence)("Failed: " + errorBody), (int)1).show();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }

            public void onFailure(Call<JoinedMatchResponse> call, Throwable t) {
                Log.e((String)"JoinMatchError", (String)("API call failed: " + t.getMessage()));
                if (originalCoins != null) {
                    MatchJoiningActivity.this.rollbackCoinDeduction(originalCoins);
                }
                Toast.makeText((Context)MatchJoiningActivity.this, (CharSequence)("Failed to join: " + t.getMessage()), (int)1).show();
            }
        });
    }

    private void handleMatchRegistration() {
        int playerCount = this.totalChecked;
        if (playerCount > 0) {
            if (playerCount == 2) {
                this.joinUsers2();
                Toast.makeText((Context)this, (CharSequence)"Register Duo Match", (int)0).show();
            } else if (playerCount == 3) {
                this.joinUsers2();
                this.joinUsers3();
                Toast.makeText((Context)this, (CharSequence)"Register Trio Match", (int)0).show();
            } else if (playerCount == 4) {
                this.joinUsers2();
                this.joinUsers3();
                this.joinUsers4();
                Toast.makeText((Context)this, (CharSequence)"Register Squad Match", (int)0).show();
            } else {
                Toast.makeText((Context)this, (CharSequence)"Match Joining Successfully...", (int)0).show();
                this.successDialog();
            }
        } else {
            Toast.makeText((Context)this, (CharSequence)"Please fill in at least one username.", (int)0).show();
        }
        this.progressDialog.dismiss();
    }

    private void joinUsers2() {
        String usernameEdt = this.binding.username2.getText().toString();
        String username1Edt = this.binding.username1.getText().toString();
        String slotText = this.binding.teamNo2.getText().toString();
        String numberOnly = slotText.replaceAll("[^0-9]", "");
        int slot_no = Integer.parseInt(numberOnly);
        String position = this.binding.positionNo2.getText().toString();
        Call<JoinedMatchResponse> call = this.myApi.storeMatchJoinedUser(this.matchId, this.email, usernameEdt, this.name, this.gamename, "Expert", "0", "0", String.valueOf(this.entryFee), this.userId, username1Edt, slot_no, position);
        call.enqueue((Callback)new Callback<JoinedMatchResponse>(){

            public void onResponse(Call<JoinedMatchResponse> call, Response<JoinedMatchResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    MatchJoiningActivity.this.progressDialog.dismiss();
                    MatchJoiningActivity.this.successDialog();
                    Toast.makeText((Context)MatchJoiningActivity.this, (CharSequence)"Player 3rd Joined Successfully.", (int)1).show();
                } else {
                    Toast.makeText((Context)MatchJoiningActivity.this, (CharSequence)"Failed to join the match. Please try again.", (int)0).show();
                }
            }

            public void onFailure(Call<JoinedMatchResponse> call, Throwable t) {
                Toast.makeText((Context)MatchJoiningActivity.this, (CharSequence)("Error: " + t.getMessage()), (int)0).show();
            }
        });
    }

    private void joinUsers3() {
        String usernameEdt = this.binding.username3.getText().toString();
        String username1Edt = this.binding.username1.getText().toString();
        String slotText = this.binding.teamNo3.getText().toString();
        String numberOnly = slotText.replaceAll("[^0-9]", "");
        int slot_no = Integer.parseInt(numberOnly);
        String position = this.binding.positionNo3.getText().toString();
        Call<JoinedMatchResponse> call = this.myApi.storeMatchJoinedUser(this.matchId, this.email, usernameEdt, this.name, this.gamename, "Expert", "0", "0", String.valueOf(this.entryFee), this.userId, username1Edt, slot_no, position);
        call.enqueue((Callback)new Callback<JoinedMatchResponse>(){

            public void onResponse(Call<JoinedMatchResponse> call, Response<JoinedMatchResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    MatchJoiningActivity.this.progressDialog.dismiss();
                    MatchJoiningActivity.this.successDialog();
                    Toast.makeText((Context)MatchJoiningActivity.this, (CharSequence)"Player 3rd Joined Successfully.", (int)1).show();
                } else {
                    Toast.makeText((Context)MatchJoiningActivity.this, (CharSequence)"Failed to join the match. Please try again.", (int)0).show();
                }
            }

            public void onFailure(Call<JoinedMatchResponse> call, Throwable t) {
                Toast.makeText((Context)MatchJoiningActivity.this, (CharSequence)("Error: " + t.getMessage()), (int)0).show();
            }
        });
    }

    private void joinUsers4() {
        String usernameEdt = this.binding.username4.getText().toString();
        String username1Edt = this.binding.username1.getText().toString();
        String slotText = this.binding.teamNo4.getText().toString();
        String numberOnly = slotText.replaceAll("[^0-9]", "");
        int slot_no = Integer.parseInt(numberOnly);
        String position = this.binding.positionNo4.getText().toString();
        Call<JoinedMatchResponse> call = this.myApi.storeMatchJoinedUser(this.matchId, this.email, usernameEdt, this.name, this.gamename, "Expert", "0", "0", String.valueOf(this.entryFee), this.userId, username1Edt, slot_no, position);
        call.enqueue((Callback)new Callback<JoinedMatchResponse>(){

            public void onResponse(Call<JoinedMatchResponse> call, Response<JoinedMatchResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    MatchJoiningActivity.this.progressDialog.dismiss();
                    MatchJoiningActivity.this.successDialog();
                    Toast.makeText((Context)MatchJoiningActivity.this, (CharSequence)"Player 3rd Joined Successfully.", (int)1).show();
                } else {
                    Toast.makeText((Context)MatchJoiningActivity.this, (CharSequence)"Failed to join the match. Please try again.", (int)0).show();
                }
            }

            public void onFailure(Call<JoinedMatchResponse> call, Throwable t) {
                Toast.makeText((Context)MatchJoiningActivity.this, (CharSequence)("Error: " + t.getMessage()), (int)0).show();
            }
        });
    }

    private void addUsernameDialog(TextView targetTextView) {
        ConstraintLayout constraintLayout = (ConstraintLayout)this.findViewById(2131362596);
        View view = LayoutInflater.from((Context)this).inflate(2131558558, (ViewGroup)constraintLayout, false);
        Button confirmBtn = (Button)view.findViewById(2131362062);
        Button cancelBtn = (Button)view.findViewById(2131361969);
        EditText username = (EditText)view.findViewById(2131363054);
        this.setupUsernameField(username);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setView(view);
        AlertDialog alertDialog = builder.create();
        confirmBtn.setOnClickListener(v -> {
            String gameusername = username.getText().toString().trim();
            if (TextUtils.isEmpty((CharSequence)gameusername)) {
                Toast.makeText((Context)this, (CharSequence)"Please Enter Username", (int)0).show();
                username.setError((CharSequence)"Username Required");
            } else {
                targetTextView.setText((CharSequence)gameusername);
                alertDialog.dismiss();
            }
        });
        cancelBtn.setOnClickListener(v -> alertDialog.dismiss());
        if (alertDialog.getWindow() != null) {
            alertDialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable());
        }
        alertDialog.show();
    }

    private void successDialog() {
        ConstraintLayout constraintLayout = (ConstraintLayout)this.findViewById(2131362831);
        View view = LayoutInflater.from((Context)this).inflate(2131558568, (ViewGroup)constraintLayout, false);
        Button confirmBtn = (Button)view.findViewById(2131361952);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setView(view);
        AlertDialog alertDialog = builder.create();
        confirmBtn.setOnClickListener(v -> {
            Intent intent = new Intent((Context)this, MainActivity.class);
            this.startActivity(intent);
            this.finish();
        });
        if (alertDialog.getWindow() != null) {
            alertDialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable());
        }
        alertDialog.show();
    }

    private void setupUsernameField(final EditText editText) {
        editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                String input = s.toString().replace(" ", "");
                if (!input.equals(s.toString())) {
                    editText.setText((CharSequence)input);
                    editText.setSelection(input.length());
                }
            }

            public void afterTextChanged(Editable s) {
            }
        });
        editText.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                return event.getAction() == 0 && keyCode == 66;
            }
        });
    }

    private void saveUsersTransactionDetails(String type) {
        long userIdLong = SharedPrefManager.getInstance((Context)this).getUserId();
        String userId = String.valueOf(userIdLong);
        String date = new SimpleDateFormat("dd-MM-yy", Locale.getDefault()).format(Calendar.getInstance().getTime());
        String time = new SimpleDateFormat("HH:mm:ss", Locale.getDefault()).format(Calendar.getInstance().getTime());
        String transactionId = "TRAN" + System.currentTimeMillis();
        String inputCoin = String.valueOf(this.totalFee);
        Call<TransactionModel> call = this.myApi.storeUserTransaction(userId, type, this.email, inputCoin, date, time, transactionId, "Wallet", "Success");
        call.enqueue((Callback)new Callback<TransactionModel>(){

            public void onResponse(Call<TransactionModel> call, Response<TransactionModel> response) {
                if (response.isSuccessful() && response.body() != null) {
                    Toast.makeText((Context)MatchJoiningActivity.this, (CharSequence)"Transaction Successfully", (int)0).show();
                } else {
                    Toast.makeText((Context)MatchJoiningActivity.this, (CharSequence)("Failed to Record Transaction: " + response.message()), (int)0).show();
                }
            }

            public void onFailure(Call<TransactionModel> call, Throwable throwable) {
                Toast.makeText((Context)MatchJoiningActivity.this, (CharSequence)("Error: " + throwable.getMessage()), (int)0).show();
            }
        });
    }

    private void loadUserData() {
        if (this.userId <= 0L) {
            Toast.makeText((Context)this, (CharSequence)"Invalid user ID", (int)0).show();
            return;
        }
        Call<ApiResponse> call = this.myApi.fetchProfileData(this.userId);
        call.enqueue((Callback)new Callback<ApiResponse>(){

            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    User model = ((ApiResponse)response.body()).getUser();
                    MatchJoiningActivity.this.binding.pleaseWaitTxt.setVisibility(8);
                    MatchJoiningActivity.this.binding.balanceInfoTxt.setVisibility(0);
                    MatchJoiningActivity.this.binding.joinBtn.setVisibility(0);
                    MatchJoiningActivity.this.binding.depoBalance.setText((CharSequence)String.valueOf("\u20b9" + model.getDepoBalance()));
                    MatchJoiningActivity.this.binding.winBalance.setText((CharSequence)String.valueOf("\u20b9" + model.getWinBalance()));
                    MatchJoiningActivity.this.binding.bonusBalance.setText((CharSequence)String.valueOf("\u20b9" + model.getBonusBalance()));
                    long totalBal = model.getDepoBalance() + model.getWinBalance() + model.getBonusBalance();
                    MatchJoiningActivity.this.binding.totalBalance.setText((CharSequence)String.valueOf("\u20b9" + totalBal));
                    MatchJoiningActivity.this.winBalance = model.getWinBalance();
                    MatchJoiningActivity.this.depoBalance = model.getDepoBalance();
                    MatchJoiningActivity.this.bonusBalance = model.getBonusBalance();
                    MatchJoiningActivity.this.email = model.getEmail();
                    MatchJoiningActivity.this.name = model.getName();
                    MatchJoiningActivity.this.matchPlayed = model.getMatchPlayed();
                    MatchJoiningActivity.this.totalCoin = model.getDepoBalance() + model.getWinBalance();
                    MatchJoiningActivity.this.requiredFee = MatchJoiningActivity.this.entryFee * (long)MatchJoiningActivity.this.totalChecked;
                    MatchJoiningActivity.this.totalFee = MatchJoiningActivity.this.entryFee * (long)MatchJoiningActivity.this.totalChecked;
                    MatchJoiningActivity.this.binding.entryFee.setText((CharSequence)String.valueOf("\u20b9" + MatchJoiningActivity.this.entryFee));
                    MatchJoiningActivity.this.binding.totalFee.setText((CharSequence)String.valueOf("\u20b9" + MatchJoiningActivity.this.totalFee));
                    if (MatchJoiningActivity.this.requiredFee <= MatchJoiningActivity.this.totalCoin) {
                        MatchJoiningActivity.this.binding.joinText.setText((CharSequence)"Join Now");
                        MatchJoiningActivity.this.binding.joinBtn.setCardBackgroundColor(MatchJoiningActivity.this.getColor(2131100429));
                    } else {
                        MatchJoiningActivity.this.binding.joinText.setText((CharSequence)"Add Money");
                        MatchJoiningActivity.this.binding.balanceInfoTxt.setText((CharSequence)"You Don't have sufficient PlayCoin");
                        MatchJoiningActivity.this.binding.balanceInfoTxt.setTextColor(MatchJoiningActivity.this.getColor(2131100441));
                        MatchJoiningActivity.this.binding.joinBtn.setCardBackgroundColor(MatchJoiningActivity.this.getColor(2131099724));
                    }
                } else {
                    Toast.makeText((Context)MatchJoiningActivity.this, (CharSequence)"Failed to fetch user data", (int)0).show();
                }
            }

            public void onFailure(Call<ApiResponse> call, Throwable throwable) {
            }
        });
    }
}

