/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Activities.AboutActivity;
import app.firezone.synk.network.Activities.Add_Money_Activity;
import app.firezone.synk.network.Activities.AppUpdateActivity;
import app.firezone.synk.network.Activities.BlockedUsersActivity;
import app.firezone.synk.network.Activities.GamesRulesActivity;
import app.firezone.synk.network.Activities.HelpActivity;
import app.firezone.synk.network.Activities.LoginActivity;
import app.firezone.synk.network.Activities.NoInternetActivity;
import app.firezone.synk.network.Activities.NotificationActivity;
import app.firezone.synk.network.Activities.ReferActivity;
import app.firezone.synk.network.Activities.ScoreActivity;
import app.firezone.synk.network.Activities.TransactionHistoryActivity;
import app.firezone.synk.network.Activities.WalletActivity;
import app.firezone.synk.network.Fragments.HistoryFragment;
import app.firezone.synk.network.Fragments.HomeFragment;
import app.firezone.synk.network.Fragments.ProfileFragment;
import app.firezone.synk.network.databinding.ActivityMainBinding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.AppModel;
import app.firezone.synk.network.model.NotificationModel;
import app.firezone.synk.network.model.User;
import app.firezone.synk.network.ui.Earn.EarnFragment;
import app.firezone.synk.network.ui.videos.VideoFragment;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.material.bottomnavigation.BottomNavigationView;
import com.google.android.material.navigation.NavigationView;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.remoteconfig.FirebaseRemoteConfig;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import java.net.UnknownHostException;
import java.util.ArrayList;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class MainActivity
extends AppCompatActivity {
    private ActivityMainBinding binding;
    TextView balanceCoin;
    ImageView notification;
    DrawerLayout drawerLayout;
    NavigationView navigationView;
    String privacyUrl;
    String termUrl;
    String website;
    String updateLink;
    private MyApi myApi;
    ImageView menu;
    ArrayList<NotificationModel> mlist = new ArrayList();
    FirebaseRemoteConfig remoteConfig;
    private BottomNavigationView bottomNavigationView;
    private Fragment fragment = null;
    private final Handler handler = new Handler();
    private final int REFRESH_INTERVAL = 5000;
    private final Runnable refreshRunnable = new Runnable(){

        @Override
        public void run() {
            MainActivity.this.loadUserData();
            MainActivity.this.handler.postDelayed((Runnable)this, 5000L);
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.loadData();
        this.binding = ActivityMainBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.handler.post(this.refreshRunnable);
        this.menu = (ImageView)this.findViewById(2131362471);
        this.navigationView = (NavigationView)this.findViewById(2131362523);
        this.drawerLayout = (DrawerLayout)this.findViewById(2131362164);
        MobileAds.initialize((Context)this, (OnInitializationCompleteListener)new OnInitializationCompleteListener(){

            public void onInitializationComplete(InitializationStatus initializationStatus) {
            }
        });
        this.binding.menu.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent browserIntent = new Intent("android.intent.action.VIEW");
                browserIntent.setData(Uri.parse((String)MainActivity.this.website));
                MainActivity.this.startActivity(browserIntent);
            }
        });
        this.binding.notificationIcon.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MainActivity.this.startActivity(new Intent((Context)MainActivity.this, NotificationActivity.class));
            }
        });
        this.binding.cardView32.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MainActivity.this.startActivity(new Intent((Context)MainActivity.this, WalletActivity.class));
            }
        });
        this.binding.addMoney.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MainActivity.this.startActivity(new Intent((Context)MainActivity.this, Add_Money_Activity.class));
            }
        });
        this.navigationView.setNavigationItemSelectedListener(new NavigationView.OnNavigationItemSelectedListener(){

            public boolean onNavigationItemSelected(@NonNull MenuItem item) {
                switch (item.getItemId()) {
                    case 2131362519: {
                        MainActivity.this.drawerLayout.closeDrawer(0x800003);
                        MainActivity.this.startActivity(new Intent((Context)MainActivity.this, ScoreActivity.class));
                        break;
                    }
                    case 2131361810: {
                        MainActivity.this.drawerLayout.closeDrawer(0x800003);
                        MainActivity.this.startActivity(new Intent((Context)MainActivity.this, AboutActivity.class));
                        break;
                    }
                    case 2131362521: {
                        MainActivity.this.drawerLayout.closeDrawer(0x800003);
                        MainActivity.this.startActivity(new Intent((Context)MainActivity.this, GamesRulesActivity.class));
                        break;
                    }
                    case 2131362518: {
                        MainActivity.this.drawerLayout.closeDrawer(0x800003);
                        MainActivity.this.startActivity(new Intent((Context)MainActivity.this, ReferActivity.class));
                        break;
                    }
                    case 2131362520: {
                        String appPackageName = "app.firezone.synk.network";
                        try {
                            MainActivity.this.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)"market://details?id=app.firezone.synk.network")));
                        }
                        catch (ActivityNotFoundException e) {
                            MainActivity.this.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)"https://play.google.com/store/apps/details?id=app.firezone.synk.network")));
                        }
                        break;
                    }
                    case 2131362522: {
                        MainActivity.this.drawerLayout.closeDrawer(0x800003);
                        MainActivity.this.startActivity(new Intent((Context)MainActivity.this, TransactionHistoryActivity.class));
                        break;
                    }
                    case 2131362515: {
                        MainActivity.this.drawerLayout.closeDrawer(0x800003);
                        Intent intent = new Intent((Context)MainActivity.this, HelpActivity.class);
                        MainActivity.this.startActivity(intent);
                        break;
                    }
                    case 2131362514: {
                        MainActivity.this.drawerLayout.closeDrawer(0x800003);
                        Intent browserIntent = new Intent("android.intent.action.VIEW");
                        browserIntent.setData(Uri.parse((String)MainActivity.this.website));
                        MainActivity.this.startActivity(browserIntent);
                        break;
                    }
                    case 2131362872: {
                        MainActivity.this.drawerLayout.closeDrawer(0x800003);
                        Intent browserIntent2 = new Intent("android.intent.action.VIEW");
                        browserIntent2.setData(Uri.parse((String)MainActivity.this.termUrl));
                        MainActivity.this.startActivity(browserIntent2);
                        break;
                    }
                    case 2131362635: {
                        MainActivity.this.drawerLayout.closeDrawer(0x800003);
                        Intent browserIntent3 = new Intent("android.intent.action.VIEW");
                        browserIntent3.setData(Uri.parse((String)MainActivity.this.privacyUrl));
                        MainActivity.this.startActivity(browserIntent3);
                    }
                }
                return true;
            }
        });
        this.bottomNavigationView = (BottomNavigationView)this.findViewById(2131362044);
        if (savedInstanceState == null) {
            this.getSupportFragmentManager().beginTransaction().replace(2131362089, (Fragment)new HomeFragment()).commit();
            this.navigationView.setCheckedItem(2131362533);
        }
        this.replaceFragment(new HomeFragment());
        this.bottomNavigationView.setBackground(null);
        this.bottomNavigationView.setOnItemSelectedListener(item -> {
            switch (item.getItemId()) {
                case 2131362533: {
                    this.replaceFragment(new HomeFragment());
                    break;
                }
                case 2131362530: {
                    this.replaceFragment(new EarnFragment());
                    break;
                }
                case 2131362532: {
                    this.replaceFragment(new HistoryFragment());
                    break;
                }
                case 2131362534: {
                    this.replaceFragment(new ProfileFragment());
                    break;
                }
                case 2131362535: {
                    this.replaceFragment(new VideoFragment());
                }
            }
            return true;
        });
        FirebaseMessaging.getInstance().subscribeToTopic("all").addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                Log.d((String)"FCM", (String)"Subscribed to topic: all");
            }
        });
        this.balanceCoin = (TextView)this.findViewById(2131361916);
        this.notification = (ImageView)this.findViewById(2131362553);
        this.remoteConfig = FirebaseRemoteConfig.getInstance();
        FirebaseRemoteConfigSettings configSettings = new FirebaseRemoteConfigSettings.Builder().setMinimumFetchIntervalInSeconds(5L).build();
        this.remoteConfig.setConfigSettingsAsync(configSettings);
        this.remoteConfig.fetchAndActivate().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Boolean>(){

            public void onComplete(@NonNull Task<Boolean> task) {
                String new_version_code;
                if (task.isSuccessful() && Integer.parseInt(new_version_code = MainActivity.this.remoteConfig.getString("new_version_code")) > MainActivity.this.getCurrentVersionCode()) {
                    Intent intent = new Intent((Context)MainActivity.this, AppUpdateActivity.class);
                    intent.putExtra("updateLink", MainActivity.this.updateLink);
                    MainActivity.this.startActivity(intent);
                    MainActivity.this.finish();
                }
            }
        });
        if (Build.VERSION.SDK_INT >= 33) {
            this.checkNotificationPermission();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.handler.removeCallbacks(this.refreshRunnable);
    }

    private void loadUserData() {
        long userId = SharedPrefManager.getInstance((Context)this).getUserId();
        if (userId == -1L) {
            Toast.makeText((Context)this, (CharSequence)"User not found. Please log in again.", (int)0).show();
            this.startActivity(new Intent((Context)this, LoginActivity.class));
            this.finish();
            return;
        }
        this.myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        Call<ApiResponse> call = this.myApi.fetchProfileData(userId);
        call.enqueue((Callback)new Callback<ApiResponse>(){

            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    ApiResponse apiResponse = (ApiResponse)response.body();
                    if (apiResponse.getStatus() == 200 && apiResponse.getUser() != null) {
                        User model = apiResponse.getUser();
                        double totalBalance = model.getWinBalance() + model.getDepoBalance() + model.getBonusBalance();
                        MainActivity.this.balanceCoin.setText((CharSequence)String.valueOf("\u20b9" + totalBalance));
                        if (!"Active".equalsIgnoreCase(model.getStatus())) {
                            MainActivity.this.startActivity(new Intent((Context)MainActivity.this, BlockedUsersActivity.class));
                            MainActivity.this.finish();
                        }
                    } else {
                        Toast.makeText((Context)MainActivity.this, (CharSequence)apiResponse.getMessage(), (int)0).show();
                    }
                } else {
                    Toast.makeText((Context)MainActivity.this, (CharSequence)"Failed to load user data", (int)0).show();
                }
            }

            public void onFailure(Call<ApiResponse> call, Throwable t) {
                if (!(t instanceof UnknownHostException)) {
                    Toast.makeText((Context)MainActivity.this, (CharSequence)"Something went wrong. Try again later.", (int)0).show();
                    Log.e((String)"API_ERROR", (String)"Failure", (Throwable)t);
                }
            }
        });
    }

    private void noConnectionAndProceed() {
        this.startActivity(new Intent((Context)this, NoInternetActivity.class));
        this.finish();
    }

    private void checkNotificationPermission() {
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.POST_NOTIFICATIONS") != 0) {
            if (this.shouldShowRequestPermissionRationale("android.permission.POST_NOTIFICATIONS")) {
                Toast.makeText((Context)this, (CharSequence)"Notification permission is needed to send you updates", (int)0).show();
                this.requestNotificationPermission();
            } else {
                this.requestNotificationPermission();
            }
        }
    }

    private void requestNotificationPermission() {
        ActivityResultLauncher requestPermissionLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestPermission(), isGranted -> {
            if (!isGranted.booleanValue()) {
                Toast.makeText((Context)this, (CharSequence)"Notification Permission Denied", (int)0).show();
            }
        });
        requestPermissionLauncher.launch((Object)"android.permission.POST_NOTIFICATIONS");
    }

    private int getCurrentVersionCode() {
        PackageInfo packageInfo = null;
        try {
            packageInfo = this.getPackageManager().getPackageInfo(this.getPackageName(), 0);
        }
        catch (Exception e) {
            Log.d((String)"myApp", (String)e.getMessage());
        }
        return packageInfo.versionCode;
    }

    private void replaceFragment(Fragment fragment) {
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        fragmentTransaction.replace(2131362089, fragment);
        fragmentTransaction.commit();
    }

    private void loadData() {
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        Call<ArrayList<AppModel>> call = myApi.fetchAppSetting();
        call.enqueue((Callback)new Callback<ArrayList<AppModel>>(){

            public void onResponse(Call<ArrayList<AppModel>> call, Response<ArrayList<AppModel>> response) {
                if (response.isSuccessful() && response.body() != null && !((ArrayList)response.body()).isEmpty()) {
                    AppModel model = (AppModel)((ArrayList)response.body()).get(0);
                    MainActivity.this.website = model.getWebsiteUrl();
                    MainActivity.this.termUrl = model.getTermsUrl();
                    MainActivity.this.privacyUrl = model.getPrivacyUrl();
                    MainActivity.this.updateLink = model.getUpdateLink();
                } else {
                    Toast.makeText((Context)MainActivity.this, (CharSequence)"No data found", (int)0).show();
                }
            }

            public void onFailure(Call<ArrayList<AppModel>> call, Throwable throwable) {
                if (throwable instanceof UnknownHostException) {
                    Log.w((String)"Network", (String)"No internet or DNS error", (Throwable)throwable);
                } else {
                    Log.e((String)"Network", (String)"Other network error", (Throwable)throwable);
                }
            }
        });
    }
}

