/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Fragments;

import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.core.widget.NestedScrollView;
import androidx.fragment.app.Fragment;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Activities.AboutActivity;
import app.firezone.synk.network.Activities.GamesRulesActivity;
import app.firezone.synk.network.Activities.HelpActivity;
import app.firezone.synk.network.Activities.LoginActivity;
import app.firezone.synk.network.Activities.ProfileActivity;
import app.firezone.synk.network.Activities.ScoreActivity;
import app.firezone.synk.network.Activities.TransactionHistoryActivity;
import app.firezone.synk.network.Activities.WalletActivity;
import app.firezone.synk.network.databinding.FragmentProfileBinding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.AppModel;
import app.firezone.synk.network.model.User;
import com.google.android.gms.auth.api.signin.GoogleSignIn;
import com.google.android.gms.auth.api.signin.GoogleSignInClient;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.firebase.auth.FirebaseAuth;
import com.squareup.picasso.Picasso;
import java.util.ArrayList;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class ProfileFragment
extends Fragment {
    private FragmentProfileBinding binding;
    private MyApi myApi;
    long userId;
    String website;
    String terms;
    String privacy;
    String refund;
    String youtube;
    String discord;
    String referCode;

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.binding = FragmentProfileBinding.inflate(inflater, container, false);
        NestedScrollView root = this.binding.getRoot();
        this.loadData();
        this.binding.profileBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ProfileFragment.this.startActivity(new Intent(ProfileFragment.this.getContext(), ProfileActivity.class));
                Toast.makeText((Context)ProfileFragment.this.getContext(), (CharSequence)"Profile Activity", (int)0).show();
            }
        });
        this.binding.helpBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ProfileFragment.this.startActivity(new Intent(ProfileFragment.this.getContext(), HelpActivity.class));
            }
        });
        this.binding.walletBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ProfileFragment.this.startActivity(new Intent(ProfileFragment.this.getContext(), WalletActivity.class));
            }
        });
        this.binding.transBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ProfileFragment.this.startActivity(new Intent(ProfileFragment.this.getContext(), TransactionHistoryActivity.class));
            }
        });
        this.binding.gamesRuleBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ProfileFragment.this.startActivity(new Intent(ProfileFragment.this.getContext(), GamesRulesActivity.class));
            }
        });
        this.binding.ToplayerBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ProfileFragment.this.startActivity(new Intent(ProfileFragment.this.getContext(), ScoreActivity.class));
                Toast.makeText((Context)ProfileFragment.this.getContext(), (CharSequence)"Just Minute....", (int)0).show();
            }
        });
        this.binding.aboutus.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ProfileFragment.this.startActivity(new Intent(ProfileFragment.this.getContext(), AboutActivity.class));
            }
        });
        this.binding.webBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)ProfileFragment.this.website));
                ProfileFragment.this.startActivity(browserIntent);
            }
        });
        this.binding.privacyBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)ProfileFragment.this.privacy));
                ProfileFragment.this.startActivity(browserIntent);
            }
        });
        this.binding.termsBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)ProfileFragment.this.terms));
                ProfileFragment.this.startActivity(browserIntent);
            }
        });
        this.binding.rateAppBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    ProfileFragment.this.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + ProfileFragment.this.getActivity().getPackageName()))));
                }
                catch (ActivityNotFoundException e) {
                    ProfileFragment.this.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("https://play.google.com/store/apps/details?id=" + ProfileFragment.this.getActivity().getPackageName()))));
                }
            }
        });
        this.binding.moreAppBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)ProfileFragment.this.website));
                ProfileFragment.this.startActivity(browserIntent);
            }
        });
        final String appname = this.getString(2131951651);
        this.binding.shareBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    Intent shareIntent = new Intent("android.intent.action.SEND");
                    shareIntent.setType("text/plain");
                    shareIntent.putExtra("android.intent.extra.SUBJECT", "Check out this gaming app!");
                    String shareMessage = "Hi, friend!\n" + appname + " is my favorite gaming app \u2013 play and win real cash every day!\nDownload now and get \u20b910 instantly, plus 20% cashback on your first deposit.\nMy referral code: " + ProfileFragment.this.referCode + "\nDownload and play now: " + ProfileFragment.this.website;
                    shareIntent.putExtra("android.intent.extra.TEXT", shareMessage);
                    ProfileFragment.this.startActivity(Intent.createChooser((Intent)shareIntent, (CharSequence)"Choose an app to share"));
                }
                catch (Exception e) {
                    Toast.makeText((Context)ProfileFragment.this.getContext(), (CharSequence)"Error", (int)0).show();
                }
            }
        });
        this.binding.logout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AlertDialog.Builder alert = new AlertDialog.Builder(ProfileFragment.this.getContext());
                alert.setMessage((CharSequence)"Are you sure you want to logout?");
                alert.setNegativeButton((CharSequence)"No", (dialog, which) -> {});
                alert.setPositiveButton((CharSequence)"Yes", (dialog, which) -> {
                    MyApi api = (MyApi)APIClient.getApiClient(ProfileFragment.this.getContext()).create(MyApi.class);
                    Call<ResponseBody> call = api.logout();
                    call.enqueue((Callback)new Callback<ResponseBody>(){

                        public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                            this.performLocalLogout();
                        }

                        public void onFailure(Call<ResponseBody> call, Throwable t) {
                            this.performLocalLogout();
                        }
                    });
                });
                alert.show();
            }

            private void performLocalLogout() {
                FirebaseAuth.getInstance().signOut();
                GoogleSignInClient googleSignInClient = GoogleSignIn.getClient((Context)ProfileFragment.this.getContext(), (GoogleSignInOptions)GoogleSignInOptions.DEFAULT_SIGN_IN);
                googleSignInClient.signOut().addOnCompleteListener(task -> {
                    SharedPrefManager.getInstance(ProfileFragment.this.getContext()).clear();
                    Intent intent = new Intent(ProfileFragment.this.getContext(), LoginActivity.class);
                    intent.setFlags(0x10008000);
                    ProfileFragment.this.startActivity(intent);
                    Toast.makeText((Context)ProfileFragment.this.getContext(), (CharSequence)"Logged out successfully", (int)0).show();
                });
            }
        });
        long userId = SharedPrefManager.getInstance(this.requireContext()).getUserId();
        this.myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        Call<ApiResponse> call = this.myApi.fetchProfileData(userId);
        call.enqueue((Callback)new Callback<ApiResponse>(){

            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (ProfileFragment.this.binding == null || !ProfileFragment.this.isAdded()) {
                    return;
                }
                if (response.isSuccessful() && response.body() != null) {
                    User model = ((ApiResponse)response.body()).getUser();
                    ((ProfileFragment)ProfileFragment.this).binding.userName.setText((CharSequence)model.getName());
                    ((ProfileFragment)ProfileFragment.this).binding.email.setText((CharSequence)model.getEmail());
                    double totalBal = model.getDepoBalance() + model.getWinBalance() + model.getBonusBalance();
                    ProfileFragment.this.referCode = model.getReferCode();
                    Picasso.get().load(model.getProfile()).placeholder(2131231115).into((ImageView)((ProfileFragment)ProfileFragment.this).binding.userProfile);
                }
            }

            public void onFailure(Call<ApiResponse> call, Throwable throwable) {
            }
        });
        return root;
    }

    private void loadData() {
        MyApi myApi = (MyApi)APIClient.getApiClient(this.requireContext()).create(MyApi.class);
        Call<ArrayList<AppModel>> call = myApi.fetchAppSetting();
        call.enqueue((Callback)new Callback<ArrayList<AppModel>>(){

            public void onResponse(Call<ArrayList<AppModel>> call, Response<ArrayList<AppModel>> response) {
                if (response.isSuccessful() && response.body() != null && !((ArrayList)response.body()).isEmpty()) {
                    AppModel model = (AppModel)((ArrayList)response.body()).get(0);
                    ProfileFragment.this.website = model.getWebsiteUrl();
                    ProfileFragment.this.terms = model.getTermsUrl();
                    ProfileFragment.this.privacy = model.getPrivacyUrl();
                    ProfileFragment.this.youtube = model.getYoutube();
                } else {
                    Toast.makeText((Context)ProfileFragment.this.getContext(), (CharSequence)"No data found", (int)0).show();
                }
            }

            public void onFailure(Call<ArrayList<AppModel>> call, Throwable throwable) {
                Toast.makeText((Context)ProfileFragment.this.getContext(), (CharSequence)("Error: " + throwable.getMessage()), (int)0).show();
            }
        });
    }

    private void gotoUrl(String s) {
        Uri uri = Uri.parse((String)s);
        this.startActivity(new Intent("android.intent.action.VIEW", uri));
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.binding = null;
    }
}

