/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Fragments;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.Adapter.LotteryAdapter;
import app.firezone.synk.network.databinding.FragmentLotteryUpcomingBinding;
import app.firezone.synk.network.model.BannerModel;
import app.firezone.synk.network.model.LotteryModel;
import com.google.firebase.database.FirebaseDatabase;
import com.squareup.picasso.Picasso;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class LotteryUpcomingFragment
extends Fragment {
    FragmentLotteryUpcomingBinding binding;
    ArrayList<LotteryModel> mlist = new ArrayList();
    LotteryAdapter myAdapter;
    private MyApi myApi;
    FirebaseDatabase database;
    Dialog dialog;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.binding = FragmentLotteryUpcomingBinding.inflate(inflater, container, false);
        ConstraintLayout view = this.binding.getRoot();
        this.dialog = new Dialog(this.getContext());
        this.dialog.setContentView(2131558570);
        this.database = FirebaseDatabase.getInstance();
        if (this.dialog.getWindow() != null) {
            this.dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.dialog.setCancelable(true);
        }
        this.dialog.show();
        this.binding.loterryRecy.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        Call<List<BannerModel>> call = this.myApi.fetchBanner();
        call.enqueue((Callback)new Callback<List<BannerModel>>(){

            public void onResponse(Call<List<BannerModel>> call, Response<List<BannerModel>> response) {
                if (response.isSuccessful() && response.body() != null && !((List)response.body()).isEmpty()) {
                    BannerModel model = (BannerModel)((List)response.body()).get(0);
                    Picasso.get().load(model.getUrl()).placeholder(2131231037).into(LotteryUpcomingFragment.this.binding.lotteryBannerImg);
                } else {
                    Toast.makeText((Context)LotteryUpcomingFragment.this.getContext(), (CharSequence)"No banner found", (int)0).show();
                }
            }

            public void onFailure(Call<List<BannerModel>> call, Throwable t) {
                Toast.makeText((Context)LotteryUpcomingFragment.this.getContext(), (CharSequence)("Error: " + t.getMessage()), (int)0).show();
            }
        });
        this.fetchLotteryData();
        return view;
    }

    private void fetchLotteryData() {
        if (this.getContext() == null) {
            Toast.makeText((Context)this.getContext(), (CharSequence)"Context is null. Please restart the app.", (int)0).show();
            return;
        }
        this.dialog.show();
        this.myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        Call<ArrayList<LotteryModel>> call = this.myApi.fetchLottery();
        call.enqueue((Callback)new Callback<ArrayList<LotteryModel>>(){

            public void onResponse(Call<ArrayList<LotteryModel>> call, Response<ArrayList<LotteryModel>> response) {
                LotteryUpcomingFragment.this.dialog.dismiss();
                if (response.isSuccessful() && response.body() != null) {
                    ArrayList allLotteries = (ArrayList)response.body();
                    ArrayList<LotteryModel> ongoingLotteries = new ArrayList<LotteryModel>();
                    for (LotteryModel model : allLotteries) {
                        if (!Objects.equals("Ongoing", model.getStatus())) continue;
                        ongoingLotteries.add(model);
                    }
                    if (!ongoingLotteries.isEmpty()) {
                        LotteryUpcomingFragment.this.myAdapter = new LotteryAdapter(LotteryUpcomingFragment.this.getContext(), new ArrayList<LotteryModel>(ongoingLotteries));
                        LotteryUpcomingFragment.this.binding.loterryRecy.setAdapter((RecyclerView.Adapter)LotteryUpcomingFragment.this.myAdapter);
                    } else {
                        Toast.makeText((Context)LotteryUpcomingFragment.this.getContext(), (CharSequence)"No ongoing lotteries available.", (int)0).show();
                    }
                } else {
                    Toast.makeText((Context)LotteryUpcomingFragment.this.getContext(), (CharSequence)("Failed to fetch lottery data. Error: " + response.code()), (int)0).show();
                }
            }

            public void onFailure(Call<ArrayList<LotteryModel>> call, Throwable t) {
                LotteryUpcomingFragment.this.dialog.dismiss();
                Toast.makeText((Context)LotteryUpcomingFragment.this.getContext(), (CharSequence)("Network error: " + t.getMessage()), (int)0).show();
            }
        });
    }
}

