/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Fragments;

import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.Activities.HelpActivity;
import app.firezone.synk.network.Activities.NotificationActivity;
import app.firezone.synk.network.Activities.ProfileActivity;
import app.firezone.synk.network.Activities.ScoreActivity;
import app.firezone.synk.network.Activities.WalletActivity;
import app.firezone.synk.network.Adapter.GameAdapter;
import app.firezone.synk.network.Adapter.HomeNotificationAdapter;
import app.firezone.synk.network.databinding.FragmentHomeBinding;
import app.firezone.synk.network.model.BannerModel;
import app.firezone.synk.network.model.GameModel;
import app.firezone.synk.network.model.NotificationModel;
import app.firezone.synk.network.model.SliderModel;
import com.denzcoskun.imageslider.ImageSlider;
import com.denzcoskun.imageslider.constants.ScaleTypes;
import com.denzcoskun.imageslider.interfaces.ItemClickListener;
import com.denzcoskun.imageslider.models.SlideModel;
import com.facebook.shimmer.ShimmerFrameLayout;
import com.squareup.picasso.Picasso;
import java.util.ArrayList;
import java.util.List;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class HomeFragment
extends Fragment {
    FragmentHomeBinding binding;
    RecyclerView esportRecycler;
    RecyclerView classicRecycler;
    RecyclerView notifyRecycler;
    ImageSlider imageSlider;
    ArrayList<NotificationModel> mlist = new ArrayList();
    HomeNotificationAdapter notificationAdapter;
    ConstraintLayout cardView;
    ConstraintLayout constraintLayout7;
    ConstraintLayout constraintLayout6;
    ConstraintLayout constraintLayout2;
    GameAdapter adapter;
    ArrayList<GameModel> models;
    private MyApi myApi;
    private View shimmerLayout;
    private View contentInclude;
    private ShimmerFrameLayout shimmerFrame;

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.binding = FragmentHomeBinding.inflate(inflater, container, false);
        FrameLayout root = this.binding.getRoot();
        this.imageSlider = (ImageSlider)root.findViewById(2131362314);
        this.esportRecycler = (RecyclerView)root.findViewById(2131362265);
        this.classicRecycler = (RecyclerView)root.findViewById(2131362053);
        this.notifyRecycler = (RecyclerView)root.findViewById(2131362557);
        this.shimmerFrame = (ShimmerFrameLayout)root.findViewById(2131362780);
        this.shimmerFrame.setVisibility(0);
        this.shimmerFrame.startShimmer();
        this.binding.homeMainLayout.setVisibility(8);
        final ArrayList remoteImage = new ArrayList();
        final ArrayList webUrls = new ArrayList();
        this.myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        Call<List<SliderModel>> call = this.myApi.fetchSlider();
        call.enqueue((Callback)new Callback<List<SliderModel>>(){

            public void onResponse(Call<List<SliderModel>> call, Response<List<SliderModel>> response) {
                if (response.isSuccessful() && response.body() != null && !((List)response.body()).isEmpty()) {
                    List sliderList = (List)response.body();
                    for (SliderModel slider : sliderList) {
                        if (slider == null || slider.getUrl() == null) continue;
                        remoteImage.add(new SlideModel(slider.getUrl(), ScaleTypes.FIT));
                        webUrls.add(slider.getWeburl());
                    }
                    if (!remoteImage.isEmpty()) {
                        HomeFragment.this.imageSlider.setImageList(remoteImage, ScaleTypes.FIT);
                        HomeFragment.this.imageSlider.setItemClickListener(new ItemClickListener(){

                            public void doubleClick(int i) {
                                Toast.makeText((Context)HomeFragment.this.getContext(), (CharSequence)"Double click", (int)0).show();
                            }

                            public void onItemSelected(int position) {
                                if (position < webUrls.size()) {
                                    String webUrl = (String)webUrls.get(position);
                                    if (webUrl != null && !webUrl.isEmpty()) {
                                        Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)webUrl));
                                        HomeFragment.this.getContext().startActivity(browserIntent);
                                    } else {
                                        Toast.makeText((Context)HomeFragment.this.getContext(), (CharSequence)"No URL found for this slide", (int)0).show();
                                    }
                                }
                            }
                        });
                    } else {
                        this.setDefaultSlider();
                    }
                } else {
                    this.setDefaultSlider();
                }
            }

            public void onFailure(Call<List<SliderModel>> call, Throwable t) {
                Toast.makeText((Context)HomeFragment.this.getContext(), (CharSequence)("Failed: " + t.getMessage()), (int)0).show();
                this.setDefaultSlider();
            }

            private void setDefaultSlider() {
                remoteImage.clear();
                webUrls.clear();
                remoteImage.add(new SlideModel(Integer.valueOf(2131231037), ScaleTypes.FIT));
                HomeFragment.this.imageSlider.setImageList(remoteImage, ScaleTypes.FIT);
            }
        });
        this.binding.constraintLayout2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                HomeFragment.this.startActivity(new Intent(HomeFragment.this.getContext(), ProfileActivity.class));
            }
        });
        this.binding.constraintLayout5.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                HomeFragment.this.startActivity(new Intent(HomeFragment.this.getContext(), WalletActivity.class));
            }
        });
        this.binding.constraintLayout6.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                HomeFragment.this.startActivity(new Intent(HomeFragment.this.getContext(), ScoreActivity.class));
            }
        });
        this.binding.constraintLayout7.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                HomeFragment.this.startActivity(new Intent(HomeFragment.this.getContext(), HelpActivity.class));
            }
        });
        this.binding.cardViewNotify.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                HomeFragment.this.startActivity(new Intent(HomeFragment.this.getContext(), NotificationActivity.class));
            }
        });
        this.myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        Call<List<BannerModel>> call2 = this.myApi.fetchBanner();
        call2.enqueue((Callback)new Callback<List<BannerModel>>(){

            public void onResponse(Call<List<BannerModel>> call, Response<List<BannerModel>> response) {
                if (response.isSuccessful() && response.body() != null) {
                    List bannerList = (List)response.body();
                    if (!bannerList.isEmpty()) {
                        BannerModel model = (BannerModel)bannerList.get(0);
                        if (model != null && model.getUrl() != null && HomeFragment.this.binding != null && HomeFragment.this.binding.bannerImg != null) {
                            Picasso.get().load(model.getUrl()).placeholder(2131231037).error(2131231037).into(HomeFragment.this.binding.bannerImg);
                        } else {
                            this.setDefaultBanner();
                        }
                    } else {
                        this.setDefaultBanner();
                    }
                } else {
                    this.setDefaultBanner();
                }
            }

            public void onFailure(Call<List<BannerModel>> call, Throwable t) {
                this.setDefaultBanner();
            }

            private void setDefaultBanner() {
                if (HomeFragment.this.binding != null && HomeFragment.this.binding.bannerImg != null) {
                    HomeFragment.this.binding.bannerImg.setImageResource(2131231037);
                }
            }
        });
        GridLayoutManager layoutManager = new GridLayoutManager(this.getContext(), 3);
        this.esportRecycler.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        int spacing = this.getResources().getDimensionPixelSize(2131165342);
        this.esportRecycler.addItemDecoration((RecyclerView.ItemDecoration)new GridSpacingItemDecoration(3, spacing, true));
        this.myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        Call<ArrayList<GameModel>> game = this.myApi.fetchGameSetting();
        game.enqueue((Callback)new Callback<ArrayList<GameModel>>(){

            public void onResponse(Call<ArrayList<GameModel>> call, Response<ArrayList<GameModel>> response) {
                if (response.isSuccessful() && response.body() != null && !((ArrayList)response.body()).isEmpty()) {
                    ArrayList models = (ArrayList)response.body();
                    GameAdapter adapter = new GameAdapter(HomeFragment.this.getContext(), models);
                    HomeFragment.this.esportRecycler.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(HomeFragment.this.getContext(), 3));
                    HomeFragment.this.esportRecycler.setAdapter((RecyclerView.Adapter)adapter);
                    if (HomeFragment.this.binding != null) {
                        HomeFragment.this.shimmerFrame.stopShimmer();
                        HomeFragment.this.shimmerFrame.setVisibility(8);
                        HomeFragment.this.binding.homeMainLayout.setVisibility(0);
                    }
                } else {
                    this.showFallbackGameList();
                }
            }

            public void onFailure(Call<ArrayList<GameModel>> call, Throwable throwable) {
                this.showFallbackGameList();
            }

            private void showFallbackGameList() {
                ArrayList<GameModel> fallbackList = new ArrayList<GameModel>();
                fallbackList.add(new GameModel("Default Game", "https://admin-tournament.yadavatech.com/storage/Match/20250425081329.jpg", "com.ytech.tournament", "1.5K+ Played", "Esports"));
                GameAdapter adapter = new GameAdapter(HomeFragment.this.getContext(), fallbackList);
                HomeFragment.this.esportRecycler.setAdapter((RecyclerView.Adapter)adapter);
                if (HomeFragment.this.binding != null) {
                    HomeFragment.this.shimmerFrame.stopShimmer();
                    HomeFragment.this.shimmerFrame.setVisibility(8);
                    HomeFragment.this.binding.homeMainLayout.setVisibility(0);
                }
            }
        });
        LinearLayoutManager layoutManager4 = new LinearLayoutManager(this.getContext());
        this.notifyRecycler.setLayoutManager((RecyclerView.LayoutManager)layoutManager4);
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        Call<NotificationModel> notifications = myApi.fetchLatestNotification();
        notifications.enqueue((Callback)new Callback<NotificationModel>(){

            public void onResponse(Call<NotificationModel> call, Response<NotificationModel> response) {
                if (response.isSuccessful() && response.body() != null) {
                    HomeFragment.this.mlist.clear();
                    HomeFragment.this.mlist.add((NotificationModel)response.body());
                    HomeFragment.this.notificationAdapter = new HomeNotificationAdapter(HomeFragment.this.getContext(), HomeFragment.this.mlist);
                    HomeFragment.this.notifyRecycler.setAdapter((RecyclerView.Adapter)HomeFragment.this.notificationAdapter);
                    HomeFragment.this.notificationAdapter.notifyDataSetChanged();
                }
            }

            public void onFailure(Call<NotificationModel> call, Throwable throwable) {
            }
        });
        return root;
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.binding = null;
    }

    public class GridSpacingItemDecoration
    extends RecyclerView.ItemDecoration {
        private final int spanCount;
        private final int spacing;
        private final boolean includeEdge;

        public GridSpacingItemDecoration(int spanCount, int spacing, boolean includeEdge) {
            this.spanCount = spanCount;
            this.spacing = spacing;
            this.includeEdge = includeEdge;
        }

        public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
            int position = parent.getChildAdapterPosition(view);
            int column = position % this.spanCount;
            if (this.includeEdge) {
                outRect.left = this.spacing - column * this.spacing / this.spanCount;
                outRect.right = (column + 1) * this.spacing / this.spanCount;
                if (position < this.spanCount) {
                    outRect.top = this.spacing;
                }
                outRect.bottom = this.spacing;
            } else {
                outRect.left = column * this.spacing / this.spanCount;
                outRect.right = this.spacing - (column + 1) * this.spacing / this.spanCount;
                if (position >= this.spanCount) {
                    outRect.top = this.spacing;
                }
            }
        }
    }

    public class EqualSpacingItemDecoration
    extends RecyclerView.ItemDecoration {
        private final int spacing;

        public EqualSpacingItemDecoration(int spacing) {
            this.spacing = spacing;
        }

        public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
            outRect.left = this.spacing;
            outRect.right = this.spacing;
            outRect.top = this.spacing;
            outRect.bottom = this.spacing;
        }
    }
}

