/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Fragments;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Adapter.TrHistoryAdapter;
import app.firezone.synk.network.databinding.FragmentHistoryBinding;
import app.firezone.synk.network.model.TransactionModel;
import app.firezone.synk.network.model.TransactionResponse;
import java.util.ArrayList;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class HistoryFragment
extends Fragment {
    FragmentHistoryBinding binding;
    ArrayList<TransactionModel> list;
    TrHistoryAdapter adapter;
    long userId;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.binding = FragmentHistoryBinding.inflate(inflater, container, false);
        ConstraintLayout view = this.binding.getRoot();
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        this.binding.historyRecy.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        layoutManager.setReverseLayout(true);
        layoutManager.setStackFromEnd(true);
        this.userId = SharedPrefManager.getInstance(this.getContext()).getUserId();
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        Call<TransactionResponse> call = myApi.fetchUserTransaction(this.userId);
        call.enqueue((Callback)new Callback<TransactionResponse>(){

            public void onResponse(Call<TransactionResponse> call, Response<TransactionResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    if (((TransactionResponse)response.body()).isSuccess()) {
                        ArrayList<TransactionModel> list = ((TransactionResponse)response.body()).getTransactions();
                        if (!list.isEmpty()) {
                            HistoryFragment.this.adapter = new TrHistoryAdapter(HistoryFragment.this.getContext(), list);
                            HistoryFragment.this.binding.historyRecy.setAdapter((RecyclerView.Adapter)HistoryFragment.this.adapter);
                        }
                    } else {
                        Toast.makeText((Context)HistoryFragment.this.getContext(), (CharSequence)((TransactionResponse)response.body()).getMessage(), (int)0).show();
                    }
                } else {
                    Toast.makeText((Context)HistoryFragment.this.getContext(), (CharSequence)"Failed to fetch transactions", (int)0).show();
                }
            }

            public void onFailure(Call<TransactionResponse> call, Throwable t) {
                Toast.makeText((Context)HistoryFragment.this.getContext(), (CharSequence)("Error: " + t.getMessage()), (int)0).show();
            }
        });
        return view;
    }
}

