/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Fragments;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.widget.AppCompatButton;
import androidx.core.widget.NestedScrollView;
import androidx.fragment.app.Fragment;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Activities.TransactionHistoryActivity;
import app.firezone.synk.network.databinding.Fragment3Binding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.PaymentModel;
import app.firezone.synk.network.model.TransactionModel;
import app.firezone.synk.network.model.User;
import app.firezone.synk.network.model.UserResponse;
import app.firezone.synk.network.model.WithdrawModel;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class Fragment3
extends Fragment {
    Fragment3Binding binding;
    Dialog dialog;
    AppCompatButton cancelBtn;
    AppCompatButton redeemBtn;
    ImageView trLogo;
    TextView traMethods;
    private MyApi myApi;
    long userId;
    String email;
    String username;
    String phoneno;
    EditText edtAmount;
    EditText edtNumber;
    DatabaseReference dr;
    long minWithdraw;
    long availWithdraw;
    FirebaseDatabase database;
    FirebaseUser auth;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.binding = Fragment3Binding.inflate(inflater, container, false);
        NestedScrollView root = this.binding.getRoot();
        this.myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        this.database = FirebaseDatabase.getInstance();
        this.auth = FirebaseAuth.getInstance().getCurrentUser();
        this.userId = SharedPrefManager.getInstance(this.getContext()).getUserId();
        if (this.userId <= 0L) {
            Toast.makeText((Context)this.getContext(), (CharSequence)"Invalid user ID", (int)0).show();
        }
        this.loadUserData();
        this.dialog = new Dialog(this.getContext());
        this.dialog.setContentView(2131558490);
        if (this.dialog.getWindow() != null) {
            this.dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.dialog.setCancelable(false);
        }
        this.cancelBtn = (AppCompatButton)this.dialog.findViewById(2131361969);
        this.redeemBtn = (AppCompatButton)this.dialog.findViewById(2131362671);
        this.edtAmount = (EditText)this.dialog.findViewById(2131362191);
        this.edtNumber = (EditText)this.dialog.findViewById(2131363002);
        this.trLogo = (ImageView)this.dialog.findViewById(2131363001);
        this.traMethods = (TextView)this.dialog.findViewById(2131362593);
        this.setMinimumWithdrawal();
        this.binding.btnHistory.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Fragment3.this.startActivity(new Intent(Fragment3.this.getContext(), TransactionHistoryActivity.class));
            }
        });
        this.binding.gplayBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Fragment3.this.trLogo.setImageResource(2131230982);
                Fragment3.this.traMethods.setText((CharSequence)"Google Gift Card");
                Fragment3.this.dialog.show();
            }
        });
        this.binding.amzonBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Fragment3.this.trLogo.setImageResource(2131230847);
                Fragment3.this.traMethods.setText((CharSequence)"Amazon Gift Card");
                Fragment3.this.dialog.show();
            }
        });
        this.binding.flipkartBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Fragment3.this.trLogo.setImageResource(2131230968);
                Fragment3.this.traMethods.setText((CharSequence)"Flipkart Gift Card");
                Fragment3.this.dialog.show();
            }
        });
        if (this.availWithdraw <= this.minWithdraw) {
            this.binding.gplayBtn.setBackgroundResource(2131230903);
            this.binding.amzonBtn.setBackgroundResource(2131230903);
            this.binding.flipkartBtn.setBackgroundResource(2131230903);
        } else {
            Toast.makeText((Context)this.getContext(), (CharSequence)("Minimum Withdraw " + this.minWithdraw + "rs"), (int)0).show();
            this.binding.gplayBtn.setBackgroundResource(2131230896);
            this.binding.amzonBtn.setBackgroundResource(2131230896);
            this.binding.flipkartBtn.setBackgroundResource(2131230896);
        }
        this.binding.totalCoinmx.setText((CharSequence)String.valueOf(this.minWithdraw));
        this.binding.coinMinum.setText((CharSequence)String.valueOf(this.minWithdraw));
        this.binding.reqEsewa.setText((CharSequence)String.valueOf(this.minWithdraw));
        this.binding.reqKhalti.setText((CharSequence)String.valueOf(this.minWithdraw));
        this.binding.reqNtc.setText((CharSequence)String.valueOf(this.minWithdraw));
        this.cancelBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Fragment3.this.dialog.dismiss();
            }
        });
        this.redeemBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Fragment3.this.checkAmount();
            }
        });
        return root;
    }

    private void loadUserData() {
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        Call<ApiResponse> call = myApi.fetchProfileData(this.userId);
        call.enqueue((Callback)new Callback<ApiResponse>(){

            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    User model = ((ApiResponse)response.body()).getUser();
                    Fragment3.this.binding.totalCoinmx.setText((CharSequence)String.valueOf(model.getWinBalance()));
                    Fragment3.this.binding.reqEsewa.setText((CharSequence)String.valueOf(model.getWinBalance()));
                    Fragment3.this.binding.reqKhalti.setText((CharSequence)String.valueOf(model.getWinBalance()));
                    Fragment3.this.binding.reqNtc.setText((CharSequence)String.valueOf(model.getWinBalance()));
                    Fragment3.this.email = model.getEmail();
                    Fragment3.this.username = model.getName();
                    Fragment3.this.phoneno = model.getPhoneno();
                    Fragment3.this.availWithdraw = model.getWinBalance();
                    int availwith = (int)model.getWinBalance();
                    Fragment3.this.binding.progressBarUp.setProgress(availwith);
                    Fragment3.this.binding.esewaProg.setProgress((int)model.getWinBalance());
                    Fragment3.this.binding.khaltiProg.setProgress((int)model.getWinBalance());
                    Fragment3.this.binding.ntcProg.setProgress((int)model.getWinBalance());
                } else {
                    Toast.makeText((Context)Fragment3.this.getContext(), (CharSequence)"Failed to fetch user data", (int)0).show();
                }
            }

            public void onFailure(Call<ApiResponse> call, Throwable throwable) {
            }
        });
    }

    private void checkAmount() {
        if ((long)Integer.parseInt(this.edtAmount.getText().toString()) <= this.minWithdraw) {
            this.edtAmount.setError((CharSequence)("Minimum " + this.minWithdraw + " Coin Withdraw"));
        } else if (Long.parseLong(this.edtAmount.getText().toString()) >= this.availWithdraw) {
            Toast.makeText((Context)this.getContext(), (CharSequence)"Not Enough Money", (int)0).show();
            this.dialog.dismiss();
        } else {
            String paymentMethods = this.traMethods.getText().toString();
            this.updateRedeem(paymentMethods);
        }
    }

    private void updateRedeem(String paymentMethods) {
        String withdCoin = this.edtAmount.getText().toString();
        String mobNumber = this.edtNumber.getText().toString();
        Calendar calForDate = Calendar.getInstance();
        SimpleDateFormat currentDate = new SimpleDateFormat("dd-MM-yy");
        String date = currentDate.format(calForDate.getTime());
        String method = paymentMethods;
        this.myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        Call<WithdrawModel> call = this.myApi.storeWithdraw(String.valueOf(this.userId), withdCoin, this.username, this.email, mobNumber, date, this.phoneno, "N/A", "N/A", "N/A", "N/A", "Pending", method);
        call.enqueue((Callback)new Callback<WithdrawModel>(){

            public void onResponse(Call<WithdrawModel> call, Response<WithdrawModel> response) {
                if (response.isSuccessful() && response.body() != null) {
                    Toast.makeText((Context)Fragment3.this.getContext(), (CharSequence)"Withdraw request submitted successfully!", (int)0).show();
                    Fragment3.this.deductedMoney();
                    Fragment3.this.dialog.dismiss();
                } else {
                    Toast.makeText((Context)Fragment3.this.getContext(), (CharSequence)("Failed to submit request: " + response.message()), (int)1).show();
                }
            }

            public void onFailure(Call<WithdrawModel> call, Throwable t) {
                Toast.makeText((Context)Fragment3.this.getContext(), (CharSequence)("Error: " + t.getMessage()), (int)1).show();
            }
        });
    }

    private void setMinimumWithdrawal() {
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        Call<ArrayList<PaymentModel>> call = myApi.fetchPaymentSetting();
        call.enqueue((Callback)new Callback<ArrayList<PaymentModel>>(){

            public void onResponse(Call<ArrayList<PaymentModel>> call, Response<ArrayList<PaymentModel>> response) {
                if (response.isSuccessful() && response.body() != null && !((ArrayList)response.body()).isEmpty()) {
                    PaymentModel model = (PaymentModel)((ArrayList)response.body()).get(0);
                    Fragment3.this.minWithdraw = model.getMinWithdraw();
                    int avail = (int)Fragment3.this.minWithdraw;
                    Fragment3.this.binding.esewaProg.setMax(avail);
                    Fragment3.this.binding.khaltiProg.setMax((int)Fragment3.this.minWithdraw);
                    Fragment3.this.binding.ntcProg.setMax((int)Fragment3.this.minWithdraw);
                    Fragment3.this.binding.progressBarUp.setMax(avail);
                    Fragment3.this.binding.coinMinum.setText((CharSequence)String.valueOf(model.getMinWithdraw()));
                } else {
                    Toast.makeText((Context)Fragment3.this.getContext(), (CharSequence)"Failed to fetch payment settings", (int)0).show();
                }
            }

            public void onFailure(Call<ArrayList<PaymentModel>> call, Throwable throwable) {
                Toast.makeText((Context)Fragment3.this.getContext(), (CharSequence)("Error: " + throwable.getMessage()), (int)0).show();
            }
        });
    }

    private void deductedMoney() {
        long inputUserCoins = Long.parseLong(this.edtAmount.getText().toString());
        long finalCoins = this.availWithdraw - inputUserCoins;
        HashMap<String, Object> updateData = new HashMap<String, Object>();
        updateData.put("winBalance", finalCoins);
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        Call<UserResponse> call = myApi.updateUser(this.userId, updateData);
        call.enqueue((Callback)new Callback<UserResponse>(){

            public void onResponse(Call<UserResponse> call, Response<UserResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    if (((UserResponse)response.body()).isSuccess()) {
                        Fragment3.this.saveUsersTransactionDetails();
                        Toast.makeText((Context)Fragment3.this.getContext(), (CharSequence)"Amount Debited..", (int)0).show();
                        Fragment3.this.loadUserData();
                    } else {
                        Toast.makeText((Context)Fragment3.this.getContext(), (CharSequence)((UserResponse)response.body()).getMessage(), (int)0).show();
                    }
                } else {
                    Toast.makeText((Context)Fragment3.this.getContext(), (CharSequence)"Failed to update balance", (int)0).show();
                }
            }

            public void onFailure(Call<UserResponse> call, Throwable throwable) {
                Toast.makeText((Context)Fragment3.this.getContext(), (CharSequence)("Error: " + throwable.getMessage()), (int)0).show();
            }
        });
    }

    private void saveUsersTransactionDetails() {
        String inputCoin = this.edtAmount.getText().toString();
        long userIdLong = SharedPrefManager.getInstance(this.getContext()).getUserId();
        String userId = String.valueOf(userIdLong);
        String date = new SimpleDateFormat("dd-MM-yy", Locale.getDefault()).format(Calendar.getInstance().getTime());
        String time = new SimpleDateFormat("HH:mm:ss", Locale.getDefault()).format(Calendar.getInstance().getTime());
        String transactionId = "TRAN" + System.currentTimeMillis();
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        Call<TransactionModel> call = myApi.storeUserTransaction(userId, "Withdraw", this.email, inputCoin, date, time, transactionId, "Wallet", "Pending");
        call.enqueue((Callback)new Callback<TransactionModel>(){

            public void onResponse(Call<TransactionModel> call, Response<TransactionModel> response) {
                if (response.isSuccessful() && response.body() != null) {
                    Toast.makeText((Context)Fragment3.this.getContext(), (CharSequence)"Transaction Recorded Successfully", (int)0).show();
                } else {
                    Toast.makeText((Context)Fragment3.this.getContext(), (CharSequence)("Failed to Record Transaction: " + response.message()), (int)0).show();
                }
            }

            public void onFailure(Call<TransactionModel> call, Throwable throwable) {
                Toast.makeText((Context)Fragment3.this.getContext(), (CharSequence)("Error: " + throwable.getMessage()), (int)0).show();
            }
        });
    }
}

