/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Fragments;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.core.widget.NestedScrollView;
import androidx.fragment.app.Fragment;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.databinding.Fragment2Binding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.PaymentModel;
import app.firezone.synk.network.model.TransactionModel;
import app.firezone.synk.network.model.User;
import app.firezone.synk.network.model.UserResponse;
import app.firezone.synk.network.model.WithdrawModel;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;
import com.squareup.picasso.Picasso;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class Fragment2
extends Fragment {
    FirebaseUser auth;
    FirebaseDatabase database;
    DatabaseReference dr;
    Fragment2Binding binding;
    long minWithdraw;
    long availWithdraw;
    long inputUserCoins;
    private MyApi myApi;
    long userId;
    String email;
    String username;
    String phoneno;

    @SuppressLint(value={"MissingInflatedId"})
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.binding = Fragment2Binding.inflate(inflater, container, false);
        NestedScrollView root = this.binding.getRoot();
        this.myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        this.userId = SharedPrefManager.getInstance(this.getContext()).getUserId();
        if (this.userId <= 0L) {
            Toast.makeText((Context)this.getContext(), (CharSequence)"Invalid user ID", (int)0).show();
        }
        this.loadUserData();
        this.auth = FirebaseAuth.getInstance().getCurrentUser();
        this.database = FirebaseDatabase.getInstance();
        this.auth = FirebaseAuth.getInstance().getCurrentUser();
        this.setMinimumWithdrawal();
        if (this.availWithdraw <= this.minWithdraw) {
            this.binding.withdrawBankBtn.setBackgroundResource(2131230903);
        } else {
            Toast.makeText((Context)this.getContext(), (CharSequence)("Minimum Withdraw " + this.minWithdraw + "rs"), (int)0).show();
            this.binding.withdrawBankBtn.setBackgroundResource(2131230896);
        }
        this.binding.withdrawBankBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String amount = Fragment2.this.binding.withdrawBankAc.getText().toString();
                if (TextUtils.isEmpty((CharSequence)amount)) {
                    Toast.makeText((Context)Fragment2.this.getContext(), (CharSequence)"Enter Amount", (int)0).show();
                } else if ((long)Integer.parseInt(Fragment2.this.binding.withdrawBankAc.getText().toString()) <= Fragment2.this.minWithdraw) {
                    Fragment2.this.binding.withdrawBankAc.setError((CharSequence)("Minimum " + Fragment2.this.minWithdraw + "rs Withdraw"));
                } else if (Long.parseLong(Fragment2.this.binding.withdrawBankAc.getText().toString()) >= Fragment2.this.availWithdraw) {
                    Toast.makeText((Context)Fragment2.this.getContext(), (CharSequence)"Not Enough Money", (int)0).show();
                } else {
                    Fragment2.this.inputUserCoins = Long.parseLong(Fragment2.this.binding.withdrawBankAc.getText().toString());
                    Fragment2.this.withdrawMoney();
                }
            }
        });
        return root;
    }

    private void loadUserData() {
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        Call<ApiResponse> call = myApi.fetchProfileData(this.userId);
        call.enqueue((Callback)new Callback<ApiResponse>(){

            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    User model = ((ApiResponse)response.body()).getUser();
                    long totalWinBal = model.getWinBalance();
                    long totalDepoBal = model.getDepoBalance();
                    Fragment2.this.availWithdraw = model.getWinBalance();
                    Fragment2.this.email = model.getEmail();
                    Fragment2.this.username = model.getName();
                    String totalBal = String.valueOf(totalWinBal);
                    Fragment2.this.binding.totalBalances.setText((CharSequence)totalBal);
                    Fragment2.this.binding.name.setText((CharSequence)model.getName());
                    Picasso.get().load(model.getProfile()).placeholder(2131231115).into((ImageView)Fragment2.this.binding.imageView15);
                    Fragment2.this.email = model.getEmail();
                    Fragment2.this.phoneno = model.getPhoneno();
                } else {
                    Toast.makeText((Context)Fragment2.this.getContext(), (CharSequence)"Failed to fetch user data", (int)0).show();
                }
            }

            public void onFailure(Call<ApiResponse> call, Throwable throwable) {
            }
        });
    }

    private void withdrawMoney() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        View mView = this.getLayoutInflater().inflate(2131558486, null);
        final EditText bankname = (EditText)mView.findViewById(2131361920);
        final EditText accountno = (EditText)mView.findViewById(2131361847);
        final EditText accountnocnfm = (EditText)mView.findViewById(2131361848);
        final EditText holdername = (EditText)mView.findViewById(2131361846);
        final EditText ifsccode = (EditText)mView.findViewById(2131362310);
        TextView amount = (TextView)mView.findViewById(2131361919);
        Button bankWithdrawBtn = (Button)mView.findViewById(2131362827);
        amount.setText((CharSequence)this.binding.withdrawBankAc.getText().toString());
        builder.setView(mView);
        final AlertDialog alertDialogs = builder.create();
        bankWithdrawBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String bankName = bankname.getText().toString();
                String accountNo = accountno.getText().toString();
                String accountNoCnfm = accountnocnfm.getText().toString();
                String holderName = holdername.getText().toString();
                String ifscCode = ifsccode.getText().toString();
                if (TextUtils.isEmpty((CharSequence)bankName)) {
                    bankname.setError((CharSequence)"Your Bank Name");
                    Toast.makeText((Context)Fragment2.this.getContext(), (CharSequence)"Enter Your Bank Name", (int)0).show();
                    return;
                }
                if (TextUtils.isEmpty((CharSequence)accountNo)) {
                    accountno.setError((CharSequence)"Account No.");
                    Toast.makeText((Context)Fragment2.this.getContext(), (CharSequence)"Enter Your Account No.", (int)0).show();
                    return;
                }
                if (TextUtils.isEmpty((CharSequence)accountNoCnfm)) {
                    Toast.makeText((Context)Fragment2.this.getContext(), (CharSequence)"Re-enter Account No.", (int)0).show();
                    accountnocnfm.setError((CharSequence)"Re-enter Account no");
                    return;
                }
                if (TextUtils.isEmpty((CharSequence)holderName)) {
                    Toast.makeText((Context)Fragment2.this.getContext(), (CharSequence)"Enter Account Holder Name", (int)0).show();
                    holdername.setError((CharSequence)"Enter Account Holder Name");
                    return;
                }
                if (TextUtils.isEmpty((CharSequence)ifscCode)) {
                    Toast.makeText((Context)Fragment2.this.getContext(), (CharSequence)"Enter Your IFSC Code", (int)0).show();
                    ifsccode.setError((CharSequence)"Enter IFSC Code");
                } else {
                    String withdrawCoins = String.valueOf(Fragment2.this.inputUserCoins);
                    String banknames = bankname.getText().toString();
                    String accountNos = accountno.getText().toString();
                    String accountNoCnfms = accountnocnfm.getText().toString();
                    String holderNames = holdername.getText().toString();
                    String ifscCodes = ifsccode.getText().toString();
                    String status = "Pending";
                    String method = "BANK";
                    Calendar calForDate = Calendar.getInstance();
                    SimpleDateFormat currentDate = new SimpleDateFormat("dd-MM-yy");
                    String date = currentDate.format(calForDate.getTime());
                    Fragment2.this.myApi = (MyApi)APIClient.getApiClient(Fragment2.this.getContext()).create(MyApi.class);
                    Call<WithdrawModel> call = Fragment2.this.myApi.storeWithdraw(String.valueOf(Fragment2.this.userId), withdrawCoins, Fragment2.this.username, Fragment2.this.email, Fragment2.this.phoneno, date, "N/A", banknames, accountNos, ifscCodes, holderNames, status, method);
                    call.enqueue((Callback)new Callback<WithdrawModel>(){

                        public void onResponse(Call<WithdrawModel> call, Response<WithdrawModel> response) {
                            if (response.isSuccessful() && response.body() != null) {
                                Toast.makeText((Context)Fragment2.this.getContext(), (CharSequence)"Withdraw request submitted successfully!", (int)0).show();
                                alertDialogs.dismiss();
                                Fragment2.this.binding.withdrawBankAc.setText((CharSequence)"");
                                Fragment2.this.deductedMoney();
                            } else {
                                Toast.makeText((Context)Fragment2.this.getContext(), (CharSequence)("Failed to submit request: " + response.message()), (int)1).show();
                            }
                        }

                        public void onFailure(Call<WithdrawModel> call, Throwable t) {
                            Toast.makeText((Context)Fragment2.this.getContext(), (CharSequence)("Error: " + t.getMessage()), (int)1).show();
                        }
                    });
                }
            }
        });
        alertDialogs.show();
    }

    private void setMinimumWithdrawal() {
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        Call<ArrayList<PaymentModel>> call = myApi.fetchPaymentSetting();
        call.enqueue((Callback)new Callback<ArrayList<PaymentModel>>(){

            public void onResponse(Call<ArrayList<PaymentModel>> call, Response<ArrayList<PaymentModel>> response) {
                if (response.isSuccessful() && response.body() != null && !((ArrayList)response.body()).isEmpty()) {
                    PaymentModel model = (PaymentModel)((ArrayList)response.body()).get(0);
                    Fragment2.this.minWithdraw = model.getMinWithdraw();
                } else {
                    Toast.makeText((Context)Fragment2.this.getContext(), (CharSequence)"Failed to fetch payment settings", (int)0).show();
                }
            }

            public void onFailure(Call<ArrayList<PaymentModel>> call, Throwable throwable) {
                Toast.makeText((Context)Fragment2.this.getContext(), (CharSequence)("Error: " + throwable.getMessage()), (int)0).show();
            }
        });
    }

    private void deductedMoney() {
        long finalCoins = this.availWithdraw - this.inputUserCoins;
        HashMap<String, Object> updateData = new HashMap<String, Object>();
        updateData.put("winBalance", finalCoins);
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        Call<UserResponse> call = myApi.updateUser(this.userId, updateData);
        call.enqueue((Callback)new Callback<UserResponse>(){

            public void onResponse(Call<UserResponse> call, Response<UserResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    if (((UserResponse)response.body()).isSuccess()) {
                        Fragment2.this.saveUsersTransactionDetails();
                        Toast.makeText((Context)Fragment2.this.getContext(), (CharSequence)"Amount Debited...", (int)0).show();
                        Fragment2.this.loadUserData();
                    } else {
                        Toast.makeText((Context)Fragment2.this.getContext(), (CharSequence)((UserResponse)response.body()).getMessage(), (int)0).show();
                    }
                } else {
                    Toast.makeText((Context)Fragment2.this.getContext(), (CharSequence)"Failed to update balance", (int)0).show();
                }
            }

            public void onFailure(Call<UserResponse> call, Throwable throwable) {
                Toast.makeText((Context)Fragment2.this.getContext(), (CharSequence)("Error: " + throwable.getMessage()), (int)0).show();
            }
        });
    }

    private void saveUsersTransactionDetails() {
        long userIdLong = SharedPrefManager.getInstance(this.getContext()).getUserId();
        String userId = String.valueOf(userIdLong);
        String date = new SimpleDateFormat("dd-MM-yy", Locale.getDefault()).format(Calendar.getInstance().getTime());
        String time = new SimpleDateFormat("HH:mm:ss", Locale.getDefault()).format(Calendar.getInstance().getTime());
        String transactionId = "TRAN" + System.currentTimeMillis();
        String inputCoin = String.valueOf(this.inputUserCoins);
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        Call<TransactionModel> call = myApi.storeUserTransaction(userId, "Withdraw", this.email, inputCoin, date, time, transactionId, "Wallet", "Pending");
        call.enqueue((Callback)new Callback<TransactionModel>(){

            public void onResponse(Call<TransactionModel> call, Response<TransactionModel> response) {
                if (response.isSuccessful() && response.body() != null) {
                    Toast.makeText((Context)Fragment2.this.getContext(), (CharSequence)"Transaction Recorded Successfully", (int)0).show();
                } else {
                    Toast.makeText((Context)Fragment2.this.getContext(), (CharSequence)("Failed to Record Transaction: " + response.message()), (int)0).show();
                }
            }

            public void onFailure(Call<TransactionModel> call, Throwable throwable) {
                Toast.makeText((Context)Fragment2.this.getContext(), (CharSequence)("Error: " + throwable.getMessage()), (int)0).show();
            }
        });
    }
}

