/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Fragments;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.core.widget.NestedScrollView;
import androidx.fragment.app.Fragment;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.databinding.Fragment1Binding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.PaymentModel;
import app.firezone.synk.network.model.TransactionModel;
import app.firezone.synk.network.model.User;
import app.firezone.synk.network.model.UserResponse;
import app.firezone.synk.network.model.WithdrawModel;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;
import com.squareup.picasso.Picasso;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class Fragment1
extends Fragment {
    Fragment1Binding binding;
    FirebaseDatabase database;
    private MyApi myApi;
    long userId;
    String email;
    String username;
    String phoneno;
    Dialog dialog;
    long minWithdraw;
    long availWithdraw;
    long inputUserCoins;
    FirebaseUser auth;
    DatabaseReference dr;

    @SuppressLint(value={"MissingInflatedId"})
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.binding = Fragment1Binding.inflate(inflater, container, false);
        NestedScrollView root = this.binding.getRoot();
        this.myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        this.database = FirebaseDatabase.getInstance();
        this.auth = FirebaseAuth.getInstance().getCurrentUser();
        this.userId = SharedPrefManager.getInstance(this.getContext()).getUserId();
        if (this.userId <= 0L) {
            Toast.makeText((Context)this.getContext(), (CharSequence)"Invalid user ID", (int)0).show();
        }
        this.loadUserData();
        this.setMinimumWithdrawal();
        this.dialog = new Dialog(this.getContext());
        this.dialog.setContentView(2131558570);
        if (this.dialog.getWindow() != null) {
            this.dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.dialog.setCancelable(true);
        }
        this.dialog.show();
        this.dialog.setCancelable(false);
        if (this.availWithdraw <= this.minWithdraw) {
            this.binding.withdrawUpiBtn.setBackgroundResource(2131230903);
        } else {
            Toast.makeText((Context)this.getContext(), (CharSequence)("Minimum Withdraw " + this.minWithdraw + "rs"), (int)0).show();
            this.binding.withdrawUpiBtn.setBackgroundResource(2131230896);
            this.binding.withdrawUpiBtn.setClickable(false);
        }
        this.binding.withdrawUpiBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String amountStr = Fragment1.this.binding.withDrawUpi.getText().toString().trim();
                if (TextUtils.isEmpty((CharSequence)amountStr)) {
                    Toast.makeText((Context)Fragment1.this.getContext(), (CharSequence)"Enter Amount", (int)0).show();
                    return;
                }
                try {
                    long amount = Long.parseLong(amountStr);
                    if (amount < Fragment1.this.minWithdraw) {
                        Fragment1.this.binding.withDrawUpi.setError((CharSequence)("Withdraw above " + Fragment1.this.minWithdraw + " rs"));
                    } else if (amount > Fragment1.this.availWithdraw) {
                        Toast.makeText((Context)Fragment1.this.getContext(), (CharSequence)"Not Enough Money", (int)0).show();
                    } else {
                        Fragment1.this.inputUserCoins = amount;
                        Fragment1.this.withdrawMoney();
                    }
                }
                catch (NumberFormatException e) {
                    Fragment1.this.binding.withDrawUpi.setError((CharSequence)"Please enter a valid number");
                }
            }
        });
        return root;
    }

    private void loadUserData() {
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        Call<ApiResponse> call = myApi.fetchProfileData(this.userId);
        call.enqueue((Callback)new Callback<ApiResponse>(){

            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                Fragment1.this.dialog.dismiss();
                if (response.isSuccessful() && response.body() != null) {
                    User model = ((ApiResponse)response.body()).getUser();
                    long totalWinBal = model.getWinBalance();
                    long totalDepoBal = model.getDepoBalance();
                    Fragment1.this.availWithdraw = totalWinBal;
                    Fragment1.this.email = model.getEmail();
                    Fragment1.this.username = model.getName();
                    Fragment1.this.phoneno = model.getPhoneno();
                    Fragment1.this.binding.totalBalances.setText((CharSequence)String.valueOf(totalWinBal));
                    Fragment1.this.binding.name.setText((CharSequence)model.getName());
                    Picasso.get().load(model.getProfile()).placeholder(2131231115).into((ImageView)Fragment1.this.binding.imageView15);
                } else {
                    Toast.makeText((Context)Fragment1.this.getContext(), (CharSequence)"Failed to fetch user data", (int)0).show();
                }
            }

            public void onFailure(Call<ApiResponse> call, Throwable throwable) {
                Fragment1.this.dialog.dismiss();
                Toast.makeText((Context)Fragment1.this.getContext(), (CharSequence)("Error: " + throwable.getMessage()), (int)0).show();
            }
        });
    }

    private void withdrawMoney() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        View mView = this.getLayoutInflater().inflate(2131558649, null);
        final EditText userUpiId = (EditText)mView.findViewById(2131363036);
        TextView amount = (TextView)mView.findViewById(2131361891);
        Button withdrawBtn = (Button)mView.findViewById(2131363037);
        amount.setText((CharSequence)this.binding.withDrawUpi.getText().toString());
        builder.setView(mView);
        final AlertDialog alertDialogs = builder.create();
        withdrawBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String upiId = userUpiId.getText().toString();
                if (TextUtils.isEmpty((CharSequence)upiId)) {
                    Toast.makeText((Context)Fragment1.this.getContext(), (CharSequence)"Enter Your UPI Id.", (int)0).show();
                    userUpiId.setError((CharSequence)"Enter UPI Id");
                } else {
                    String withdrawCoins = Fragment1.this.binding.withDrawUpi.getText().toString();
                    String upiIds = userUpiId.getText().toString();
                    String status = "Pending";
                    String method = "UPI";
                    Calendar calForDate = Calendar.getInstance();
                    SimpleDateFormat currentDate = new SimpleDateFormat("dd-MM-yy");
                    String date = currentDate.format(calForDate.getTime());
                    Fragment1.this.myApi = (MyApi)APIClient.getApiClient(Fragment1.this.getContext()).create(MyApi.class);
                    Call<WithdrawModel> call = Fragment1.this.myApi.storeWithdraw(String.valueOf(Fragment1.this.userId), withdrawCoins, Fragment1.this.username, Fragment1.this.email, Fragment1.this.phoneno, date, upiIds, "N/A", "N/A", "N/A", "N/A", status, method);
                    call.enqueue((Callback)new Callback<WithdrawModel>(){

                        public void onResponse(Call<WithdrawModel> call, Response<WithdrawModel> response) {
                            if (response.isSuccessful() && response.body() != null) {
                                Toast.makeText((Context)Fragment1.this.getContext(), (CharSequence)"Withdraw request submitted successfully!", (int)0).show();
                                alertDialogs.dismiss();
                                Fragment1.this.binding.withDrawUpi.setText((CharSequence)"");
                                Fragment1.this.deductedMoney();
                            } else {
                                Toast.makeText((Context)Fragment1.this.getContext(), (CharSequence)("Failed: " + response.message()), (int)1).show();
                            }
                        }

                        public void onFailure(Call<WithdrawModel> call, Throwable t) {
                            Toast.makeText((Context)Fragment1.this.getContext(), (CharSequence)("Error: " + t.getMessage()), (int)1).show();
                        }
                    });
                }
            }
        });
        alertDialogs.show();
    }

    private void setMinimumWithdrawal() {
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        Call<ArrayList<PaymentModel>> call = myApi.fetchPaymentSetting();
        call.enqueue((Callback)new Callback<ArrayList<PaymentModel>>(){

            public void onResponse(Call<ArrayList<PaymentModel>> call, Response<ArrayList<PaymentModel>> response) {
                Fragment1.this.dialog.dismiss();
                if (response.isSuccessful() && response.body() != null && !((ArrayList)response.body()).isEmpty()) {
                    PaymentModel model = (PaymentModel)((ArrayList)response.body()).get(0);
                    Fragment1.this.minWithdraw = model.getMinWithdraw();
                } else {
                    Toast.makeText((Context)Fragment1.this.getContext(), (CharSequence)"Failed to fetch payment settings", (int)0).show();
                }
            }

            public void onFailure(Call<ArrayList<PaymentModel>> call, Throwable throwable) {
                Fragment1.this.dialog.dismiss();
                Toast.makeText((Context)Fragment1.this.getContext(), (CharSequence)("Error: " + throwable.getMessage()), (int)0).show();
            }
        });
    }

    private void deductedMoney() {
        long finalCoins = this.availWithdraw - this.inputUserCoins;
        HashMap<String, Object> updateData = new HashMap<String, Object>();
        updateData.put("winBalance", finalCoins);
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        Call<UserResponse> call = myApi.updateUser(this.userId, updateData);
        call.enqueue((Callback)new Callback<UserResponse>(){

            public void onResponse(Call<UserResponse> call, Response<UserResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    if (((UserResponse)response.body()).isSuccess()) {
                        Fragment1.this.saveUsersTransactionDetails();
                        Toast.makeText((Context)Fragment1.this.getContext(), (CharSequence)"Amount Debited..", (int)0).show();
                        Fragment1.this.loadUserData();
                    } else {
                        Toast.makeText((Context)Fragment1.this.getContext(), (CharSequence)((UserResponse)response.body()).getMessage(), (int)0).show();
                    }
                } else {
                    Toast.makeText((Context)Fragment1.this.getContext(), (CharSequence)"Failed to update balance", (int)0).show();
                }
            }

            public void onFailure(Call<UserResponse> call, Throwable throwable) {
                Toast.makeText((Context)Fragment1.this.getContext(), (CharSequence)("Error: " + throwable.getMessage()), (int)0).show();
            }
        });
    }

    private void saveUsersTransactionDetails() {
        long userIdLong = SharedPrefManager.getInstance(this.getContext()).getUserId();
        String userId = String.valueOf(userIdLong);
        String date = new SimpleDateFormat("dd-MM-yy", Locale.getDefault()).format(Calendar.getInstance().getTime());
        String time = new SimpleDateFormat("HH:mm:ss", Locale.getDefault()).format(Calendar.getInstance().getTime());
        String transactionId = "TRAN" + System.currentTimeMillis();
        String inputCoin = String.valueOf(this.inputUserCoins);
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        Call<TransactionModel> call = myApi.storeUserTransaction(userId, "Withdraw", this.email, inputCoin, date, time, transactionId, "Wallet", "Pending");
        call.enqueue((Callback)new Callback<TransactionModel>(){

            public void onResponse(Call<TransactionModel> call, Response<TransactionModel> response) {
                if (response.isSuccessful() && response.body() != null) {
                    Toast.makeText((Context)Fragment1.this.getContext(), (CharSequence)"Transaction Recorded Successfully", (int)0).show();
                } else {
                    Toast.makeText((Context)Fragment1.this.getContext(), (CharSequence)("Failed to Record Transaction: " + response.message()), (int)0).show();
                }
            }

            public void onFailure(Call<TransactionModel> call, Throwable throwable) {
                Toast.makeText((Context)Fragment1.this.getContext(), (CharSequence)("Error: " + throwable.getMessage()), (int)0).show();
            }
        });
    }
}

