/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Fragments;

import android.app.Dialog;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Adapter.LudoResultAdapter;
import app.firezone.synk.network.databinding.FragmentFFResultBinding;
import app.firezone.synk.network.model.CheckJoinedResponse;
import app.firezone.synk.network.model.Joined_Match_Model;
import app.firezone.synk.network.model.Match_Model;
import app.firezone.synk.network.model.ResultModel;
import app.firezone.synk.network.model.ResultResponse;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class FF_Result_Fragment
extends Fragment {
    ArrayList<Match_Model> mlist = new ArrayList();
    RecyclerView recyclerView;
    FragmentFFResultBinding binding;
    Dialog dialog;
    String gamename;
    LudoResultAdapter myAdapter;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.binding = FragmentFFResultBinding.inflate(inflater, container, false);
        ConstraintLayout root = this.binding.getRoot();
        if (this.getArguments() != null) {
            this.gamename = this.getArguments().getString("gamename");
        }
        this.recyclerView = (RecyclerView)root.findViewById(2131362228);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mlist.clear();
        this.setupDialog();
        this.fetchMatchResults();
        this.binding.swipeRefresh.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                FF_Result_Fragment.this.fetchMatchResults();
            }
        });
        return root;
    }

    private void setupDialog() {
        this.dialog = new Dialog(this.getContext());
        this.dialog.setContentView(2131558570);
        if (this.dialog.getWindow() != null) {
            this.dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.dialog.setCancelable(true);
        }
        this.dialog.show();
    }

    private void fetchMatchResults() {
        if (!this.binding.swipeRefresh.isRefreshing()) {
            this.dialog.show();
        }
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        Call<ResultResponse> call = myApi.fetchResultMatchData(this.gamename);
        call.enqueue((Callback)new Callback<ResultResponse>(){

            public void onResponse(Call<ResultResponse> call, Response<ResultResponse> response) {
                FF_Result_Fragment.this.dialog.dismiss();
                FF_Result_Fragment.this.binding.swipeRefresh.setRefreshing(false);
                if (response.isSuccessful() && response.body() != null && ((ResultResponse)response.body()).isSuccess()) {
                    ArrayList<ResultModel> matches = new ArrayList<ResultModel>(((ResultResponse)response.body()).getMatches());
                    ArrayList<ResultModel> resultMatches = new ArrayList<ResultModel>();
                    for (ResultModel match : matches) {
                        if (!"Result".equalsIgnoreCase(match.getMatchstatus())) continue;
                        resultMatches.add(match);
                    }
                    if (!resultMatches.isEmpty()) {
                        FF_Result_Fragment.this.enrichMatchesWithJoinData(resultMatches);
                    }
                }
            }

            public void onFailure(Call<ResultResponse> call, Throwable throwable) {
                FF_Result_Fragment.this.binding.swipeRefresh.setRefreshing(false);
            }
        });
    }

    private void enrichMatchesWithJoinData(ArrayList<ResultModel> matchList) {
        long userId = SharedPrefManager.getInstance(this.getContext()).getUserId();
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        final ArrayList enrichedList = new ArrayList();
        final AtomicInteger completedCount = new AtomicInteger(0);
        final int totalMatches = matchList.size();
        for (ResultModel originalMatch : matchList) {
            final ResultModel match = new ResultModel();
            match.copyFrom(originalMatch);
            final AtomicInteger perMatchCount = new AtomicInteger(0);
            match.setMatchCode("not_joined");
            match.setTotalPlayerJoined("0");
            myApi.checkIfUserJoined(userId, match.getId()).enqueue((Callback)new Callback<CheckJoinedResponse>(){

                public void onResponse(Call<CheckJoinedResponse> call, Response<CheckJoinedResponse> response) {
                    if (response.isSuccessful() && response.body() != null && ((CheckJoinedResponse)response.body()).isSuccess()) {
                        match.setMatchCode("joined");
                    }
                    if (perMatchCount.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        FF_Result_Fragment.this.checkIfAllMatchesProcessed(enrichedList, completedCount, totalMatches);
                    }
                }

                public void onFailure(Call<CheckJoinedResponse> call, Throwable t) {
                    if (perMatchCount.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        FF_Result_Fragment.this.checkIfAllMatchesProcessed(enrichedList, completedCount, totalMatches);
                    }
                }
            });
            myApi.fetchMatchJoinedUsers(match.getId()).enqueue((Callback)new Callback<ArrayList<Joined_Match_Model>>(){

                public void onResponse(Call<ArrayList<Joined_Match_Model>> call, Response<ArrayList<Joined_Match_Model>> response) {
                    if (response.isSuccessful() && response.body() != null) {
                        match.setTotalPlayerJoined(String.valueOf(((ArrayList)response.body()).size()));
                    }
                    if (perMatchCount.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        FF_Result_Fragment.this.checkIfAllMatchesProcessed(enrichedList, completedCount, totalMatches);
                    }
                }

                public void onFailure(Call<ArrayList<Joined_Match_Model>> call, Throwable t) {
                    if (perMatchCount.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        FF_Result_Fragment.this.checkIfAllMatchesProcessed(enrichedList, completedCount, totalMatches);
                    }
                }
            });
        }
    }

    private void checkIfAllMatchesProcessed(ArrayList<ResultModel> enrichedList, AtomicInteger completedCount, int totalMatches) {
        if (completedCount.incrementAndGet() == totalMatches) {
            this.myAdapter = new LudoResultAdapter(enrichedList, this.getContext());
            this.recyclerView.setAdapter((RecyclerView.Adapter)this.myAdapter);
        }
    }
}

