/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Fragments;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Adapter.LudoMatchAdapter;
import app.firezone.synk.network.databinding.FragmentFFOngoingBinding;
import app.firezone.synk.network.model.CheckJoinedResponse;
import app.firezone.synk.network.model.Joined_Match_Model;
import app.firezone.synk.network.model.MatchResponse;
import app.firezone.synk.network.model.Match_Model;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class FFOngoingFragment
extends Fragment {
    FragmentFFOngoingBinding binding;
    Dialog dialog;
    ArrayList<Match_Model> mlist = new ArrayList();
    LudoMatchAdapter myAdapter;
    String gamename;
    private Handler handler = new Handler();
    private Runnable autoRefreshRunnable;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.binding = FragmentFFOngoingBinding.inflate(inflater, container, false);
        ConstraintLayout root = this.binding.getRoot();
        if (this.getArguments() != null) {
            this.gamename = this.getArguments().getString("gamename");
        }
        this.setupDialog();
        this.setupRecycler();
        this.fetchMatchData();
        this.binding.swipeRefresh.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                FFOngoingFragment.this.fetchMatchData();
            }
        });
        return root;
    }

    private void setupDialog() {
        this.dialog = new Dialog(this.getContext());
        this.dialog.setContentView(2131558570);
        if (this.dialog.getWindow() != null) {
            this.dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        }
        this.dialog.setCancelable(false);
        this.dialog.show();
    }

    private void setupRecycler() {
        this.binding.ffMatchRecy.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.myAdapter = new LudoMatchAdapter(this.getContext(), new ArrayList<Match_Model>());
        this.binding.ffMatchRecy.setAdapter((RecyclerView.Adapter)this.myAdapter);
    }

    private void fetchMatchData() {
        if (!this.binding.swipeRefresh.isRefreshing()) {
            this.dialog.show();
        }
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        Call<MatchResponse> call = myApi.getMatchDataByGameName(this.gamename);
        call.enqueue((Callback)new Callback<MatchResponse>(){

            public void onResponse(Call<MatchResponse> call, Response<MatchResponse> response) {
                if (!FFOngoingFragment.this.isAdded()) {
                    return;
                }
                if (FFOngoingFragment.this.dialog.isShowing()) {
                    FFOngoingFragment.this.dialog.dismiss();
                }
                FFOngoingFragment.this.mlist.clear();
                FFOngoingFragment.this.binding.swipeRefresh.setRefreshing(false);
                if (response.isSuccessful() && response.body() != null && ((MatchResponse)response.body()).isSuccess()) {
                    ArrayList<Match_Model> matches = ((MatchResponse)response.body()).getMatches();
                    if (matches != null && !matches.isEmpty()) {
                        for (Match_Model match : matches) {
                            if (!"Ongoing".equalsIgnoreCase(match.getMatchstatus())) continue;
                            FFOngoingFragment.this.mlist.add(match);
                        }
                        FFOngoingFragment.this.enrichMatchesWithJoinData(FFOngoingFragment.this.mlist);
                    } else {
                        FFOngoingFragment.this.myAdapter.updateList(new ArrayList<Match_Model>());
                    }
                } else {
                    Toast.makeText((Context)FFOngoingFragment.this.getContext(), (CharSequence)"Failed to load data.", (int)0).show();
                }
            }

            public void onFailure(Call<MatchResponse> call, Throwable throwable) {
                if (!FFOngoingFragment.this.isAdded()) {
                    return;
                }
                if (FFOngoingFragment.this.dialog.isShowing()) {
                    FFOngoingFragment.this.dialog.dismiss();
                }
                FFOngoingFragment.this.binding.swipeRefresh.setRefreshing(false);
                Toast.makeText((Context)FFOngoingFragment.this.getContext(), (CharSequence)("Network error: " + throwable.getMessage()), (int)1).show();
            }
        });
    }

    private void enrichMatchesWithJoinData(ArrayList<Match_Model> matchList) {
        long userId = SharedPrefManager.getInstance(this.getContext()).getUserId();
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        final ArrayList enrichedList = new ArrayList();
        final AtomicInteger completedCount = new AtomicInteger(0);
        final int totalMatches = matchList.size();
        for (Match_Model originalMatch : matchList) {
            final Match_Model match = new Match_Model();
            match.copyFrom(originalMatch);
            final AtomicInteger perMatchCounter = new AtomicInteger(0);
            match.setMatchCode("not_joined");
            match.setTotalPlayerJoined("0");
            match.setJoinedCount(0);
            match.setUserJoined(false);
            myApi.checkIfUserJoined(userId, match.getId()).enqueue((Callback)new Callback<CheckJoinedResponse>(){

                public void onResponse(Call<CheckJoinedResponse> call, Response<CheckJoinedResponse> response) {
                    if (response.isSuccessful() && response.body() != null && ((CheckJoinedResponse)response.body()).isSuccess()) {
                        match.setMatchCode("Joined");
                        match.setUserJoined(true);
                    }
                    if (perMatchCounter.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        if (completedCount.incrementAndGet() == totalMatches) {
                            FFOngoingFragment.this.myAdapter.updateList(enrichedList);
                        }
                    }
                }

                public void onFailure(Call<CheckJoinedResponse> call, Throwable t) {
                    if (perMatchCounter.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        if (completedCount.incrementAndGet() == totalMatches) {
                            FFOngoingFragment.this.myAdapter.updateList(enrichedList);
                        }
                    }
                }
            });
            myApi.fetchMatchJoinedUsers(match.getId()).enqueue((Callback)new Callback<ArrayList<Joined_Match_Model>>(){

                public void onResponse(Call<ArrayList<Joined_Match_Model>> call, Response<ArrayList<Joined_Match_Model>> response) {
                    if (response.isSuccessful() && response.body() != null) {
                        int count = ((ArrayList)response.body()).size();
                        match.setTotalPlayerJoined(String.valueOf(count));
                        match.setJoinedCount(count);
                    }
                    if (perMatchCounter.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        if (completedCount.incrementAndGet() == totalMatches) {
                            FFOngoingFragment.this.myAdapter.updateList(enrichedList);
                        }
                    }
                }

                public void onFailure(Call<ArrayList<Joined_Match_Model>> call, Throwable t) {
                    if (perMatchCounter.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        if (completedCount.incrementAndGet() == totalMatches) {
                            FFOngoingFragment.this.myAdapter.updateList(enrichedList);
                        }
                    }
                }
            });
        }
    }
}

