/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Fragments;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Adapter.BgmiResultAdapter;
import app.firezone.synk.network.databinding.FragmentBgmiResultBinding;
import app.firezone.synk.network.model.CheckJoinedResponse;
import app.firezone.synk.network.model.Joined_Match_Model;
import app.firezone.synk.network.model.ResultModel;
import app.firezone.synk.network.model.ResultResponse;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class Bgmi_Result_Fragment
extends Fragment {
    ArrayList<ResultModel> mlist = new ArrayList();
    BgmiResultAdapter myAdapter;
    FragmentBgmiResultBinding binding;
    String gamename;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.binding = FragmentBgmiResultBinding.inflate(inflater, container, false);
        ConstraintLayout root = this.binding.getRoot();
        if (this.getArguments() != null) {
            this.gamename = this.getArguments().getString("gamename");
        }
        this.setupRecyclerView();
        this.fetchMatchResults();
        this.binding.swipeRefresh.setOnRefreshListener(() -> this.fetchMatchResults());
        return root;
    }

    private void setupRecyclerView() {
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        layoutManager.setReverseLayout(true);
        layoutManager.setStackFromEnd(true);
        this.binding.bgmiResultRecy.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.myAdapter = new BgmiResultAdapter(this.mlist, this.getContext());
        this.binding.bgmiResultRecy.setAdapter((RecyclerView.Adapter)this.myAdapter);
    }

    private void fetchMatchResults() {
        if (!this.binding.swipeRefresh.isRefreshing()) {
            this.binding.shimmerContainer.setVisibility(0);
        }
        this.binding.shimmerContainer.setVisibility(0);
        this.binding.bgmiResultRecy.setVisibility(8);
        this.binding.tvNoData.setVisibility(8);
        this.mlist.clear();
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        Call<ResultResponse> call = myApi.fetchResultMatchData(this.gamename);
        call.enqueue((Callback)new Callback<ResultResponse>(){

            public void onResponse(Call<ResultResponse> call, Response<ResultResponse> response) {
                Bgmi_Result_Fragment.this.binding.swipeRefresh.setRefreshing(false);
                if (response.isSuccessful() && response.body() != null && ((ResultResponse)response.body()).isSuccess()) {
                    ArrayList<ResultModel> resultMatches = new ArrayList<ResultModel>();
                    for (ResultModel match : ((ResultResponse)response.body()).getMatches()) {
                        if (!"Result".equalsIgnoreCase(match.getMatchstatus())) continue;
                        resultMatches.add(match);
                    }
                    if (resultMatches.isEmpty()) {
                        Bgmi_Result_Fragment.this.showNoDataView();
                    } else {
                        Bgmi_Result_Fragment.this.enrichMatchesWithJoinData(resultMatches);
                    }
                } else {
                    Bgmi_Result_Fragment.this.showNoDataView();
                }
            }

            public void onFailure(Call<ResultResponse> call, Throwable t) {
                Bgmi_Result_Fragment.this.binding.swipeRefresh.setRefreshing(false);
                Toast.makeText((Context)Bgmi_Result_Fragment.this.getContext(), (CharSequence)("Error: " + t.getMessage()), (int)0).show();
                Bgmi_Result_Fragment.this.showNoDataView();
            }
        });
    }

    private void enrichMatchesWithJoinData(ArrayList<ResultModel> matchList) {
        long userId = SharedPrefManager.getInstance(this.getContext()).getUserId();
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        final ArrayList enrichedList = new ArrayList();
        final AtomicInteger completedCount = new AtomicInteger(0);
        final int totalMatches = matchList.size();
        for (ResultModel originalMatch : matchList) {
            final ResultModel match = new ResultModel();
            match.copyFrom(originalMatch);
            final AtomicInteger perMatchCount = new AtomicInteger(0);
            match.setMatchCode("not_joined");
            match.setTotalPlayerJoined("0");
            myApi.checkIfUserJoined(userId, match.getId()).enqueue((Callback)new Callback<CheckJoinedResponse>(){

                public void onResponse(Call<CheckJoinedResponse> call, Response<CheckJoinedResponse> response) {
                    if (response.isSuccessful() && response.body() != null && ((CheckJoinedResponse)response.body()).isSuccess()) {
                        match.setMatchCode("joined");
                    }
                    if (perMatchCount.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        Bgmi_Result_Fragment.this.checkIfAllMatchesProcessed(enrichedList, completedCount, totalMatches);
                    }
                }

                public void onFailure(Call<CheckJoinedResponse> call, Throwable t) {
                    if (perMatchCount.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        Bgmi_Result_Fragment.this.checkIfAllMatchesProcessed(enrichedList, completedCount, totalMatches);
                    }
                }
            });
            myApi.fetchMatchJoinedUsers(match.getId()).enqueue((Callback)new Callback<ArrayList<Joined_Match_Model>>(){

                public void onResponse(Call<ArrayList<Joined_Match_Model>> call, Response<ArrayList<Joined_Match_Model>> response) {
                    if (response.isSuccessful() && response.body() != null) {
                        match.setTotalPlayerJoined(String.valueOf(((ArrayList)response.body()).size()));
                    }
                    if (perMatchCount.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        Bgmi_Result_Fragment.this.checkIfAllMatchesProcessed(enrichedList, completedCount, totalMatches);
                    }
                }

                public void onFailure(Call<ArrayList<Joined_Match_Model>> call, Throwable t) {
                    if (perMatchCount.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        Bgmi_Result_Fragment.this.checkIfAllMatchesProcessed(enrichedList, completedCount, totalMatches);
                    }
                }
            });
        }
    }

    private void checkIfAllMatchesProcessed(ArrayList<ResultModel> enrichedList, AtomicInteger completedCount, int totalMatches) {
        if (completedCount.incrementAndGet() == totalMatches) {
            this.mlist.clear();
            this.mlist.addAll(enrichedList);
            if (this.myAdapter != null) {
                this.myAdapter.notifyDataSetChanged();
            }
            if (this.mlist.isEmpty()) {
                this.showNoDataView();
            } else {
                this.binding.shimmerContainer.setVisibility(8);
                this.binding.bgmiResultRecy.setVisibility(0);
                this.binding.tvNoData.setVisibility(8);
            }
        }
    }

    private void showNoDataView() {
        this.binding.shimmerContainer.setVisibility(8);
        this.binding.bgmiResultRecy.setVisibility(8);
        this.binding.tvNoData.setVisibility(0);
    }
}

