/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Fragments;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Adapter.BgmiMatchAdapter;
import app.firezone.synk.network.databinding.FragmentBgmiOngoingBinding;
import app.firezone.synk.network.model.CheckJoinedResponse;
import app.firezone.synk.network.model.Joined_Match_Model;
import app.firezone.synk.network.model.MatchResponse;
import app.firezone.synk.network.model.Match_Model;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class BgmiOngoingFragment
extends Fragment {
    FragmentBgmiOngoingBinding binding;
    ArrayList<Match_Model> mlist = new ArrayList();
    BgmiMatchAdapter myAdapter;
    TextView tvNoData;
    String gamename;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.binding = FragmentBgmiOngoingBinding.inflate(inflater, container, false);
        ConstraintLayout view = this.binding.getRoot();
        if (this.getArguments() != null) {
            this.gamename = this.getArguments().getString("gamename");
        }
        this.tvNoData = (TextView)view.findViewById(2131363015);
        this.setupRecyclerView();
        this.binding.swipeRefresh.setOnRefreshListener(() -> this.fetchOngoingMatches());
        this.fetchOngoingMatches();
        return view;
    }

    private void setupRecyclerView() {
        this.binding.bgmiMatchRecy.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.myAdapter = new BgmiMatchAdapter(this.getContext(), this.mlist);
        this.binding.bgmiMatchRecy.setAdapter((RecyclerView.Adapter)this.myAdapter);
    }

    private void fetchOngoingMatches() {
        if (!this.binding.swipeRefresh.isRefreshing()) {
            this.binding.shimmerContainer.setVisibility(0);
        }
        this.mlist.clear();
        this.binding.bgmiMatchRecy.setVisibility(8);
        this.tvNoData.setVisibility(8);
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        Call<MatchResponse> call = myApi.getMatchDataByGameName(this.gamename);
        call.enqueue((Callback)new Callback<MatchResponse>(){

            public void onResponse(Call<MatchResponse> call, Response<MatchResponse> response) {
                BgmiOngoingFragment.this.binding.swipeRefresh.setRefreshing(false);
                if (response.isSuccessful() && response.body() != null && ((MatchResponse)response.body()).isSuccess() && ((MatchResponse)response.body()).getMatches() != null) {
                    ArrayList<Match_Model> matches = new ArrayList<Match_Model>(((MatchResponse)response.body()).getMatches());
                    ArrayList<Match_Model> ongoingMatches = new ArrayList<Match_Model>();
                    for (Match_Model match : matches) {
                        if (!"Ongoing".equalsIgnoreCase(match.getMatchstatus())) continue;
                        ongoingMatches.add(match);
                    }
                    if (ongoingMatches.isEmpty()) {
                        BgmiOngoingFragment.this.showNoDataView();
                    } else {
                        BgmiOngoingFragment.this.enrichMatchesWithJoinData(ongoingMatches);
                    }
                } else {
                    BgmiOngoingFragment.this.showNoDataView();
                }
            }

            public void onFailure(Call<MatchResponse> call, Throwable t) {
                BgmiOngoingFragment.this.binding.swipeRefresh.setRefreshing(false);
                Toast.makeText((Context)BgmiOngoingFragment.this.getContext(), (CharSequence)("Error: " + t.getMessage()), (int)0).show();
                BgmiOngoingFragment.this.showNoDataView();
            }
        });
    }

    private void enrichMatchesWithJoinData(ArrayList<Match_Model> matchList) {
        long userId = SharedPrefManager.getInstance(this.getContext()).getUserId();
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getContext()).create(MyApi.class);
        final ArrayList enrichedList = new ArrayList();
        final AtomicInteger completedCount = new AtomicInteger(0);
        final int totalMatches = matchList.size();
        for (Match_Model originalMatch : matchList) {
            final Match_Model match = new Match_Model();
            match.copyFrom(originalMatch);
            final AtomicInteger perMatchCount = new AtomicInteger(0);
            match.setMatchCode("not_joined");
            match.setTotalPlayerJoined("0");
            myApi.checkIfUserJoined(userId, match.getId()).enqueue((Callback)new Callback<CheckJoinedResponse>(){

                public void onResponse(Call<CheckJoinedResponse> call, Response<CheckJoinedResponse> response) {
                    if (response.isSuccessful() && response.body() != null && ((CheckJoinedResponse)response.body()).isSuccess()) {
                        match.setMatchCode("joined");
                    }
                    if (perMatchCount.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        BgmiOngoingFragment.this.checkIfAllMatchesProcessed(enrichedList, completedCount, totalMatches);
                    }
                }

                public void onFailure(Call<CheckJoinedResponse> call, Throwable t) {
                    if (perMatchCount.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        BgmiOngoingFragment.this.checkIfAllMatchesProcessed(enrichedList, completedCount, totalMatches);
                    }
                }
            });
            myApi.fetchMatchJoinedUsers(match.getId()).enqueue((Callback)new Callback<ArrayList<Joined_Match_Model>>(){

                public void onResponse(Call<ArrayList<Joined_Match_Model>> call, Response<ArrayList<Joined_Match_Model>> response) {
                    if (response.isSuccessful() && response.body() != null) {
                        match.setTotalPlayerJoined(String.valueOf(((ArrayList)response.body()).size()));
                    }
                    if (perMatchCount.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        BgmiOngoingFragment.this.checkIfAllMatchesProcessed(enrichedList, completedCount, totalMatches);
                    }
                }

                public void onFailure(Call<ArrayList<Joined_Match_Model>> call, Throwable t) {
                    if (perMatchCount.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        BgmiOngoingFragment.this.checkIfAllMatchesProcessed(enrichedList, completedCount, totalMatches);
                    }
                }
            });
        }
    }

    private void checkIfAllMatchesProcessed(ArrayList<Match_Model> enrichedList, AtomicInteger completedCount, int totalMatches) {
        if (completedCount.incrementAndGet() == totalMatches) {
            this.mlist.clear();
            this.mlist.addAll(enrichedList);
            if (this.myAdapter != null) {
                this.myAdapter.notifyDataSetChanged();
            }
            if (this.mlist.isEmpty()) {
                this.showNoDataView();
            } else {
                this.binding.shimmerContainer.setVisibility(8);
                this.binding.bgmiMatchRecy.setVisibility(0);
                this.tvNoData.setVisibility(8);
            }
        }
    }

    private void showNoDataView() {
        this.binding.shimmerContainer.setVisibility(8);
        this.binding.bgmiMatchRecy.setVisibility(8);
        this.tvNoData.setVisibility(0);
    }
}

