/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Adapter.BgmiPlayerAdapter;
import app.firezone.synk.network.Adapter.RulesAdapter;
import app.firezone.synk.network.MatchSlotsActivity;
import app.firezone.synk.network.databinding.ActivityBgmiOneBinding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.CheckJoinedResponse;
import app.firezone.synk.network.model.Joined_Match_Model;
import app.firezone.synk.network.model.MatchResponse;
import app.firezone.synk.network.model.MatchRulesResponse;
import app.firezone.synk.network.model.Match_Model;
import app.firezone.synk.network.model.RulesModel;
import app.firezone.synk.network.model.User;
import com.google.firebase.database.DatabaseReference;
import com.squareup.picasso.Picasso;
import java.util.ArrayList;
import java.util.Collection;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class Bgmi_Activity_One
extends AppCompatActivity {
    ActivityBgmiOneBinding binding;
    BgmiPlayerAdapter mAdapter;
    ArrayList<Joined_Match_Model> mlist;
    private ClipboardManager myClipboard;
    private ClipData myClip;
    long userId;
    ArrayList<RulesModel> rulesModels;
    RulesAdapter adapter;
    ProgressDialog progressDialog;
    Dialog dialog;
    String gamename;
    String teamType;
    String matchNo;
    String roomId;
    String roomPass;
    boolean joinedUsers;
    DatabaseReference dr;
    DatabaseReference dr2;
    DatabaseReference dr3;
    DatabaseReference dr4;
    long winBalance;
    long depoBalance;
    long bonusBalance;
    long totalCoin;
    long entryFee;
    long totalFee;
    long matchPlayed;
    long totalPlayer;
    long player;
    EditText ffUsername1;
    EditText ffUsername2;
    EditText ffUsername3;
    EditText ffUsername4;
    TextView spersonTxt;
    private boolean isLoading = false;
    private MyApi myApi;
    long matchId;
    ConstraintLayout addPlayers;
    ConstraintLayout playerConstraint1;
    ConstraintLayout playerConstraint2;
    ConstraintLayout playerConstraint3;
    ConstraintLayout playerConstraint4;
    String email;
    String name;

    @SuppressLint(value={"MissingInflatedId"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityBgmiOneBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.binding.backArrow.setOnClickListener(v -> this.finish());
        this.myClipboard = (ClipboardManager)this.getSystemService("clipboard");
        this.progressDialog = new ProgressDialog((Context)this);
        this.progressDialog.setTitle((CharSequence)"Joining Match");
        this.progressDialog.setMessage((CharSequence)"Please Wait.....");
        this.progressDialog.setCancelable(true);
        this.myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        this.gamename = this.getIntent().getStringExtra("gamename");
        this.binding.toolText.setText((CharSequence)this.gamename);
        String totalPlayers = this.getIntent().getStringExtra("totalPlayer");
        String entryFees = this.getIntent().getStringExtra("entryFee");
        this.totalPlayer = Long.parseLong(totalPlayers);
        this.entryFee = Long.parseLong(entryFees);
        this.userId = SharedPrefManager.getInstance((Context)this).getUserId();
        this.loadData();
        Bundle extras = this.getIntent().getExtras();
        if (extras != null && extras.containsKey("matchid")) {
            this.matchId = extras.getLong("matchid");
            if (this.matchId != 0L) {
                this.fetchMatchData(this.matchId);
            } else {
                Toast.makeText((Context)this, (CharSequence)"Match ID is invalid", (int)0).show();
            }
        } else {
            Toast.makeText((Context)this, (CharSequence)"Match ID not found", (int)0).show();
        }
        this.checkJoinedUsers();
        this.binding.joinedRecy.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.mlist = new ArrayList();
        Call<ArrayList<Joined_Match_Model>> joinedUserData = this.myApi.fetchMatchJoinedUsers(this.matchId);
        joinedUserData.enqueue((Callback)new Callback<ArrayList<Joined_Match_Model>>(){

            public void onResponse(Call<ArrayList<Joined_Match_Model>> call, Response<ArrayList<Joined_Match_Model>> response) {
                if (response.isSuccessful() && response.body() != null) {
                    Bgmi_Activity_One.this.mlist.clear();
                    Bgmi_Activity_One.this.mlist.addAll((Collection)response.body());
                    long child = Bgmi_Activity_One.this.mlist.size();
                    if (child >= Bgmi_Activity_One.this.totalPlayer) {
                        Bgmi_Activity_One.this.binding.joinText.setText((CharSequence)"Match Full");
                        Bgmi_Activity_One.this.binding.subssribeBtn.setBackgroundResource(2131230896);
                        Bgmi_Activity_One.this.binding.subssribeBtn.setClickable(false);
                    } else {
                        Bgmi_Activity_One.this.binding.joinText.setText((CharSequence)"Join Match");
                        Bgmi_Activity_One.this.binding.subssribeBtn.setClickable(true);
                    }
                    Bgmi_Activity_One.this.mAdapter = new BgmiPlayerAdapter(Bgmi_Activity_One.this.mlist, (Context)Bgmi_Activity_One.this);
                    Bgmi_Activity_One.this.binding.joinedRecy.setAdapter((RecyclerView.Adapter)Bgmi_Activity_One.this.mAdapter);
                } else {
                    Toast.makeText((Context)Bgmi_Activity_One.this, (CharSequence)"No data available.", (int)0).show();
                }
            }

            public void onFailure(Call<ArrayList<Joined_Match_Model>> call, Throwable throwable) {
                Toast.makeText((Context)Bgmi_Activity_One.this, (CharSequence)("Error: " + throwable.getMessage()), (int)0).show();
            }
        });
        this.binding.rulesRecy.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.rulesModels = new ArrayList();
        this.myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        Call<MatchRulesResponse> call = this.myApi.fetchMatchRules(this.gamename);
        call.enqueue((Callback)new Callback<MatchRulesResponse>(){

            public void onResponse(Call<MatchRulesResponse> call, Response<MatchRulesResponse> response) {
                if (response.isSuccessful() && response.body() != null && ((MatchRulesResponse)response.body()).isSuccess()) {
                    Bgmi_Activity_One.this.rulesModels.clear();
                    Bgmi_Activity_One.this.rulesModels.addAll(((MatchRulesResponse)response.body()).getMatchRules());
                    Bgmi_Activity_One.this.adapter = new RulesAdapter(Bgmi_Activity_One.this.rulesModels, (Context)Bgmi_Activity_One.this);
                    Bgmi_Activity_One.this.binding.rulesRecy.setAdapter((RecyclerView.Adapter)Bgmi_Activity_One.this.adapter);
                }
            }

            public void onFailure(Call<MatchRulesResponse> call, Throwable t) {
                Toast.makeText((Context)Bgmi_Activity_One.this, (CharSequence)("Failed to load rules: " + t.getMessage()), (int)0).show();
            }
        });
        this.binding.roomPassCopy.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String text = Bgmi_Activity_One.this.binding.roomPass.getText().toString();
                Bgmi_Activity_One.this.myClip = ClipData.newPlainText((CharSequence)"text", (CharSequence)text);
                Bgmi_Activity_One.this.myClipboard.setPrimaryClip(Bgmi_Activity_One.this.myClip);
                Toast.makeText((Context)Bgmi_Activity_One.this.getApplicationContext(), (CharSequence)"Room Pass Copied", (int)0).show();
            }
        });
        this.binding.roomIdCopy.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String text = Bgmi_Activity_One.this.binding.roomId.getText().toString();
                Bgmi_Activity_One.this.myClip = ClipData.newPlainText((CharSequence)"text", (CharSequence)text);
                Bgmi_Activity_One.this.myClipboard.setPrimaryClip(Bgmi_Activity_One.this.myClip);
                Toast.makeText((Context)Bgmi_Activity_One.this.getApplicationContext(), (CharSequence)"Room Id Copied", (int)0).show();
            }
        });
        this.binding.subssribeBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent intent = new Intent((Context)Bgmi_Activity_One.this, MatchSlotsActivity.class);
                intent.putExtra("teamType", Bgmi_Activity_One.this.teamType);
                intent.putExtra("totalPlayer", Bgmi_Activity_One.this.totalPlayer);
                intent.putExtra("matchId", Bgmi_Activity_One.this.matchId);
                intent.putExtra("gamename", Bgmi_Activity_One.this.gamename);
                intent.putExtra("entryFee", Bgmi_Activity_One.this.entryFee);
                Bgmi_Activity_One.this.startActivity(intent);
            }
        });
    }

    private void fetchMatchData(long matchId) {
        this.binding.shimmerLayout.setVisibility(0);
        this.binding.shimmerLayout.startShimmer();
        this.binding.contentLayout.setVisibility(8);
        Call<MatchResponse> matchData = this.myApi.getMatchDataById(matchId);
        matchData.enqueue((Callback)new Callback<MatchResponse>(){

            public void onResponse(Call<MatchResponse> call, Response<MatchResponse> response) {
                Bgmi_Activity_One.this.binding.shimmerLayout.stopShimmer();
                Bgmi_Activity_One.this.binding.shimmerLayout.setVisibility(8);
                Bgmi_Activity_One.this.binding.contentLayout.setVisibility(0);
                Bgmi_Activity_One.this.binding.cardView19.setVisibility(0);
                if (response.isSuccessful() && response.body() != null && ((MatchResponse)response.body()).getMatch() != null) {
                    Match_Model model = ((MatchResponse)response.body()).getMatch();
                    Bgmi_Activity_One.this.binding.perkill.setText((CharSequence)("\u20b9" + (TextUtils.isEmpty((CharSequence)model.getPerkill()) ? "0" : model.getPerkill())));
                    Bgmi_Activity_One.this.binding.prizepool.setText((CharSequence)("\u20b9" + (TextUtils.isEmpty((CharSequence)model.getPrizepool()) ? "0" : model.getPrizepool())));
                    Bgmi_Activity_One.this.binding.teamTypes.setText((CharSequence)("#" + (TextUtils.isEmpty((CharSequence)model.getTeamtype()) ? "N/A" : model.getTeamtype()) + " Match"));
                    Bgmi_Activity_One.this.binding.teamType.setText((CharSequence)model.getTeamtype());
                    Bgmi_Activity_One.this.binding.entryfee.setText((CharSequence)("\u20b9" + model.getEntryfee() + "/Person"));
                    Bgmi_Activity_One.this.binding.entryprice.setText((CharSequence)("Pay \u20b9" + model.getEntryfee()));
                    Bgmi_Activity_One.this.binding.dateTxt.setText((CharSequence)model.getDate());
                    Bgmi_Activity_One.this.binding.playerWisePrize.setText((CharSequence)model.getPlayerPrize());
                    Bgmi_Activity_One.this.binding.timeTxt.setText((CharSequence)model.getTime());
                    Bgmi_Activity_One.this.binding.matchMap.setText((CharSequence)model.getMap());
                    Bgmi_Activity_One.this.binding.matchType.setText((CharSequence)model.getMatchType());
                    Bgmi_Activity_One.this.binding.matchName.setText((CharSequence)(model.getGamename() + " ( SKILL GAME ) - Match" + model.getMatchno()));
                    if (Bgmi_Activity_One.this.entryFee >= 1L) {
                        Bgmi_Activity_One.this.binding.matchType.setText((CharSequence)"Paid");
                    } else {
                        Bgmi_Activity_One.this.binding.matchType.setText((CharSequence)"Free");
                    }
                    Bgmi_Activity_One.this.teamType = model.getTeamtype();
                    Bgmi_Activity_One.this.matchNo = model.getMatchno();
                    Bgmi_Activity_One.this.roomId = model.getRoomid();
                    Bgmi_Activity_One.this.roomPass = model.getRoompass();
                    if ("Ongoing".equalsIgnoreCase(model.getMatchstatus())) {
                        Bgmi_Activity_One.this.binding.joinText.setText((CharSequence)"Match Started");
                        Bgmi_Activity_One.this.binding.subssribeBtn.setBackgroundResource(2131230896);
                        Bgmi_Activity_One.this.binding.subssribeBtn.setClickable(false);
                        Bgmi_Activity_One.this.binding.btnImages.setVisibility(4);
                        Bgmi_Activity_One.this.binding.cardView22.setVisibility(0);
                    }
                    if (Bgmi_Activity_One.this.joinedUsers) {
                        Bgmi_Activity_One.this.binding.roomId.setText((CharSequence)model.getRoomid());
                        Bgmi_Activity_One.this.binding.roomPass.setText((CharSequence)model.getRoompass());
                        Bgmi_Activity_One.this.binding.cardView19.setVisibility(8);
                    } else {
                        Bgmi_Activity_One.this.binding.roomId.setText((CharSequence)"Not Joined");
                        Bgmi_Activity_One.this.binding.roomPass.setText((CharSequence)"Not Joined");
                    }
                    Picasso.get().load(model.getImages()).placeholder(2131231037).into(Bgmi_Activity_One.this.binding.imageView5);
                } else {
                    Toast.makeText((Context)Bgmi_Activity_One.this.getApplicationContext(), (CharSequence)"No Match Data Found", (int)0).show();
                }
            }

            public void onFailure(Call<MatchResponse> call, Throwable throwable) {
                Toast.makeText((Context)Bgmi_Activity_One.this.getApplicationContext(), (CharSequence)("Error: " + throwable.getMessage()), (int)0).show();
            }
        });
    }

    public void checkJoinedUsers() {
        Call<CheckJoinedResponse> call = this.myApi.checkIfUserJoined(this.userId, this.matchId);
        call.enqueue((Callback)new Callback<CheckJoinedResponse>(){

            public void onResponse(Call<CheckJoinedResponse> call, Response<CheckJoinedResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    CheckJoinedResponse responseBody = (CheckJoinedResponse)response.body();
                    if (responseBody.isSuccess()) {
                        Bgmi_Activity_One.this.binding.joinText.setText((CharSequence)"Joined");
                        Bgmi_Activity_One.this.binding.subssribeBtn.setCardBackgroundColor(Bgmi_Activity_One.this.getColor(2131099773));
                        Bgmi_Activity_One.this.binding.subssribeBtn.setClickable(false);
                        Bgmi_Activity_One.this.binding.cardView19.setVisibility(8);
                        Bgmi_Activity_One.this.binding.btnImages.setVisibility(8);
                        Bgmi_Activity_One.this.joinedUsers = true;
                        Bgmi_Activity_One.this.binding.roomId.setText((CharSequence)Bgmi_Activity_One.this.roomId);
                        Bgmi_Activity_One.this.binding.roomPass.setText((CharSequence)Bgmi_Activity_One.this.roomPass);
                        Toast.makeText((Context)Bgmi_Activity_One.this, (CharSequence)responseBody.getMessage(), (int)0).show();
                    } else {
                        Bgmi_Activity_One.this.binding.joinText.setText((CharSequence)"Join Now");
                        Bgmi_Activity_One.this.joinedUsers = false;
                        Bgmi_Activity_One.this.binding.roomId.setText((CharSequence)"Not Joined");
                        Bgmi_Activity_One.this.binding.roomPass.setText((CharSequence)"Not Joined");
                        Toast.makeText((Context)Bgmi_Activity_One.this, (CharSequence)responseBody.getMessage(), (int)0).show();
                    }
                }
            }

            public void onFailure(Call<CheckJoinedResponse> call, Throwable throwable) {
                Toast.makeText((Context)Bgmi_Activity_One.this, (CharSequence)("Error: " + throwable.getMessage()), (int)0).show();
            }
        });
    }

    private void loadData() {
        if (this.userId <= 0L) {
            Toast.makeText((Context)this, (CharSequence)"Invalid user ID", (int)0).show();
            return;
        }
        Call<ApiResponse> call = this.myApi.fetchProfileData(this.userId);
        call.enqueue((Callback)new Callback<ApiResponse>(){

            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    User model = ((ApiResponse)response.body()).getUser();
                    Bgmi_Activity_One.this.winBalance = model.getWinBalance();
                    Bgmi_Activity_One.this.depoBalance = model.getDepoBalance();
                    Bgmi_Activity_One.this.bonusBalance = model.getBonusBalance();
                    Bgmi_Activity_One.this.matchPlayed = model.getMatchPlayed();
                    Bgmi_Activity_One.this.totalCoin = model.getDepoBalance() + model.getWinBalance();
                    Bgmi_Activity_One.this.email = model.getEmail();
                    Bgmi_Activity_One.this.name = model.getName();
                } else {
                    Toast.makeText((Context)Bgmi_Activity_One.this, (CharSequence)"Failed to fetch user data", (int)0).show();
                }
            }

            public void onFailure(Call<ApiResponse> call, Throwable throwable) {
            }
        });
    }
}

