/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Adapter;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.recyclerview.widget.RecyclerView;
import app.firezone.synk.network.databinding.VideoLayoutBinding;
import app.firezone.synk.network.model.VideoModel;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.YouTubePlayer;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.listeners.AbstractYouTubePlayerListener;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.listeners.FullscreenListener;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.listeners.YouTubePlayerListener;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.views.YouTubePlayerView;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;

public class VideoAdapter
extends RecyclerView.Adapter<holder> {
    Context mContext;
    ArrayList<VideoModel> list;
    LifecycleOwner lifecycleOwner;
    Dialog dialog;

    public VideoAdapter(Context mContext, ArrayList<VideoModel> list, LifecycleOwner lifecycleOwner) {
        this.mContext = mContext;
        this.list = list;
        this.lifecycleOwner = lifecycleOwner;
    }

    @NonNull
    public holder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(2131558650, parent, false);
        return new holder(view);
    }

    public void onBindViewHolder(@NonNull holder holder2, int position) {
        final VideoModel model = this.list.get(position);
        holder2.binding.videoText.setText((CharSequence)model.getDiscripation());
        Animation animation = AnimationUtils.loadAnimation((Context)this.mContext, (int)2130772022);
        holder2.binding.videoText.startAnimation(animation);
        holder2.binding.videoText.setSelected(true);
        String videoUrl = model.getVideourl();
        final String videoId = this.extractYouTubeVideoId(videoUrl);
        Log.d((String)"VideoAdapter", (String)("Video URL: " + videoUrl));
        Log.d((String)"VideoAdapter", (String)("Extracted Video ID: " + videoId));
        if (videoId == null) {
            Log.e((String)"VideoAdapter", (String)("Error: videoId is null for video URL: " + videoUrl));
            return;
        }
        YouTubePlayerView youTubePlayerView = holder2.binding.youtubePlayerView;
        this.lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)youTubePlayerView);
        youTubePlayerView.addYouTubePlayerListener((YouTubePlayerListener)new AbstractYouTubePlayerListener(){

            public void onReady(@NonNull YouTubePlayer youTubePlayer) {
                youTubePlayer.cueVideo(videoId, 0.0f);
            }
        });
        youTubePlayerView.addFullscreenListener(new FullscreenListener(){

            public void onEnterFullscreen(@NonNull View fullscreenView, @NonNull Function0<Unit> exitFullscreen) {
            }

            public void onExitFullscreen() {
            }
        });
        holder2.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                VideoAdapter.this.dialog = new Dialog(VideoAdapter.this.mContext);
                VideoAdapter.this.dialog.requestWindowFeature(1);
                VideoAdapter.this.dialog.setContentView(2131558508);
                ImageView cancelBtn = (ImageView)VideoAdapter.this.dialog.findViewById(2131361970);
                TextView videoTxt = (TextView)VideoAdapter.this.dialog.findViewById(2131363064);
                videoTxt.setText((CharSequence)model.getDiscripation());
                YouTubePlayerView youTubePlayerView2 = (YouTubePlayerView)VideoAdapter.this.dialog.findViewById(2131363137);
                VideoAdapter.this.lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)youTubePlayerView2);
                youTubePlayerView2.addYouTubePlayerListener((YouTubePlayerListener)new AbstractYouTubePlayerListener(){

                    public void onReady(@NonNull YouTubePlayer youTubePlayer2) {
                        youTubePlayer2.cueVideo(videoId, 0.0f);
                    }
                });
                youTubePlayerView2.addFullscreenListener(new FullscreenListener(){

                    public void onEnterFullscreen(@NonNull View view, @NonNull Function0<Unit> function0) {
                    }

                    public void onExitFullscreen() {
                    }
                });
                cancelBtn.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        VideoAdapter.this.dialog.dismiss();
                    }
                });
                VideoAdapter.this.dialog.show();
                VideoAdapter.this.dialog.getWindow().setLayout(-1, -2);
                VideoAdapter.this.dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
                VideoAdapter.this.dialog.getWindow().getAttributes().windowAnimations = 2132017438;
                VideoAdapter.this.dialog.getWindow().setGravity(80);
            }
        });
    }

    public int getItemCount() {
        return this.list.size();
    }

    private String extractYouTubeVideoId(String videoUrl) {
        if (videoUrl == null || videoUrl.trim().isEmpty()) {
            return null;
        }
        String regex = "(?:https?://)?(?:www\\.)?(?:youtube\\.com|youtu\\.be)/(?:watch\\?v=|shorts/|embed/|v/|live/|)([a-zA-Z0-9_-]{11})";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(videoUrl);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    class holder
    extends RecyclerView.ViewHolder {
        VideoLayoutBinding binding;

        public holder(View itemView) {
            super(itemView);
            this.binding = VideoLayoutBinding.bind(itemView);
        }
    }
}

