/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Adapter;

import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import app.firezone.synk.network.Activities.TransactionDetailActivity;
import app.firezone.synk.network.databinding.ItemHistoryBinding;
import app.firezone.synk.network.model.TransactionModel;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class TrHistoryAdapter
extends RecyclerView.Adapter<videHolder> {
    Context context;
    ArrayList<TransactionModel> list;

    public TrHistoryAdapter(Context context, ArrayList<TransactionModel> list) {
        this.context = context;
        this.list = list;
    }

    @NonNull
    public videHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.context).inflate(2131558559, parent, false);
        return new videHolder(view);
    }

    public void onBindViewHolder(@NonNull videHolder holder2, int position) {
        final TransactionModel model = this.list.get(position);
        holder2.binding.amountTxt.setText((CharSequence)(" \u20b9" + model.getAmount()));
        holder2.binding.method.setText((CharSequence)("VIA: " + model.getMethod()));
        holder2.binding.date.setText((CharSequence)this.formatDateTime(model.getDate(), model.getTime()));
        holder2.binding.transactionId.setText((CharSequence)model.getTransactionId());
        holder2.binding.type.setText((CharSequence)model.getType());
        holder2.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent(TrHistoryAdapter.this.context, TransactionDetailActivity.class);
                intent.putExtra("amount", model.getAmount());
                intent.putExtra("type", model.getType());
                intent.putExtra("method", model.getMethod());
                intent.putExtra("date", model.getDate());
                intent.putExtra("time", model.getTime());
                intent.putExtra("transactionId", model.getTransactionId());
                intent.putExtra("status", model.getStatus());
                TrHistoryAdapter.this.context.startActivity(intent);
            }
        });
    }

    private String formatDateTime(String dateStr, String timeStr) {
        try {
            String input = dateStr + " " + timeStr;
            SimpleDateFormat inputFormat = new SimpleDateFormat("dd-MM-yy HH:mm:ss", Locale.getDefault());
            SimpleDateFormat outputFormat = new SimpleDateFormat("dd MMM yy, HH:mm", Locale.getDefault());
            Date date = inputFormat.parse(input);
            return outputFormat.format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return dateStr + ", " + timeStr;
        }
    }

    public int getItemCount() {
        return this.list.size();
    }

    public class videHolder
    extends RecyclerView.ViewHolder {
        ItemHistoryBinding binding;

        public videHolder(View itemView) {
            super(itemView);
            this.binding = ItemHistoryBinding.bind(itemView);
        }
    }
}

