/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Adapter;

import android.content.Context;
import android.content.res.ColorStateList;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import app.firezone.synk.network.model.SlotItem;
import java.util.List;

public class SlotAdapter
extends RecyclerView.Adapter<SlotViewHolder> {
    private final List<SlotItem> slotList;
    private final String teamType;
    private final Context context;
    private int maxSelection;

    public SlotAdapter(Context context, List<SlotItem> slotList, String teamType) {
        this.context = context;
        this.slotList = slotList;
        this.teamType = teamType;
        this.maxSelection = teamType.equalsIgnoreCase("Solo") ? 1 : (teamType.equalsIgnoreCase("Duo") ? 2 : 4);
    }

    @NonNull
    public SlotViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.context).inflate(2131558565, parent, false);
        return new SlotViewHolder(view);
    }

    public void onBindViewHolder(@NonNull SlotViewHolder holder2, int position) {
        SlotItem slot = this.slotList.get(position);
        holder2.tvSlotNumber.setText((CharSequence)("" + slot.getSlotNumber()));
        this.setUpCheckbox(holder2.cbA, slot, 'A');
        this.setUpCheckbox(holder2.cbB, slot, 'B');
        this.setUpCheckbox(holder2.cbC, slot, 'C');
        this.setUpCheckbox(holder2.cbD, slot, 'D');
        holder2.cbA.setVisibility(0);
        if (this.teamType.equalsIgnoreCase("Duo")) {
            holder2.cbB.setVisibility(0);
            holder2.cbC.setVisibility(8);
            holder2.cbD.setVisibility(8);
        } else if (this.teamType.equalsIgnoreCase("Squad")) {
            holder2.cbB.setVisibility(0);
            holder2.cbC.setVisibility(0);
            holder2.cbD.setVisibility(0);
        } else {
            holder2.cbB.setVisibility(8);
            holder2.cbC.setVisibility(8);
            holder2.cbD.setVisibility(8);
        }
    }

    private void setUpCheckbox(CheckBox checkBox, SlotItem slot, char label) {
        int red = ContextCompat.getColor((Context)this.context, (int)17170455);
        int joinedTint = ContextCompat.getColor((Context)this.context, (int)2131099780);
        checkBox.setOnCheckedChangeListener(null);
        boolean isChecked = false;
        boolean isJoined = false;
        switch (label) {
            case 'A': {
                isChecked = slot.isCheckedA;
                isJoined = slot.isJoinedA;
                break;
            }
            case 'B': {
                isChecked = slot.isCheckedB;
                isJoined = slot.isJoinedB;
                break;
            }
            case 'C': {
                isChecked = slot.isCheckedC;
                isJoined = slot.isJoinedC;
                break;
            }
            case 'D': {
                isChecked = slot.isCheckedD;
                isJoined = slot.isJoinedD;
            }
        }
        checkBox.setText((CharSequence)String.valueOf(label));
        if (isJoined) {
            checkBox.setChecked(true);
            checkBox.setEnabled(false);
            checkBox.setButtonTintList(ColorStateList.valueOf((int)joinedTint));
            checkBox.setTextColor(-7829368);
        } else {
            checkBox.setChecked(isChecked);
            checkBox.setEnabled(true);
            checkBox.setButtonTintList(ColorStateList.valueOf((int)red));
            checkBox.setTextColor(-16777216);
            checkBox.setOnCheckedChangeListener((buttonView, isCheckedNow) -> {
                int totalChecked = this.getTotalChecked();
                if (isCheckedNow && totalChecked >= this.maxSelection) {
                    buttonView.setChecked(false);
                    Toast.makeText((Context)this.context, (CharSequence)("You can only select " + this.maxSelection + " slot(s)"), (int)0).show();
                    return;
                }
                switch (label) {
                    case 'A': {
                        slot.isCheckedA = isCheckedNow;
                        break;
                    }
                    case 'B': {
                        slot.isCheckedB = isCheckedNow;
                        break;
                    }
                    case 'C': {
                        slot.isCheckedC = isCheckedNow;
                        break;
                    }
                    case 'D': {
                        slot.isCheckedD = isCheckedNow;
                    }
                }
            });
        }
    }

    private int getTotalChecked() {
        int count = 0;
        for (SlotItem item : this.slotList) {
            if (item.isCheckedA && !item.isJoinedA) {
                ++count;
            }
            if (item.isCheckedB && !item.isJoinedB) {
                ++count;
            }
            if (item.isCheckedC && !item.isJoinedC) {
                ++count;
            }
            if (!item.isCheckedD || item.isJoinedD) continue;
            ++count;
        }
        return count;
    }

    public int getItemCount() {
        return this.slotList.size();
    }

    static class SlotViewHolder
    extends RecyclerView.ViewHolder {
        TextView tvSlotNumber;
        CheckBox cbA;
        CheckBox cbB;
        CheckBox cbC;
        CheckBox cbD;

        public SlotViewHolder(@NonNull View itemView) {
            super(itemView);
            this.tvSlotNumber = (TextView)itemView.findViewById(2131363016);
            this.cbA = (CheckBox)itemView.findViewById(2131362029);
            this.cbB = (CheckBox)itemView.findViewById(2131362030);
            this.cbC = (CheckBox)itemView.findViewById(2131362031);
            this.cbD = (CheckBox)itemView.findViewById(2131362032);
        }
    }
}

