/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Adapter;

import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import app.firezone.synk.network.Activities.ClaasicWinnerActivity;
import app.firezone.synk.network.databinding.ResultMatchBinding;
import app.firezone.synk.network.model.ResultModel;
import com.squareup.picasso.Picasso;
import java.util.ArrayList;

public class LudoResultAdapter
extends RecyclerView.Adapter<holder> {
    Context mContext;
    ArrayList<ResultModel> models = new ArrayList();

    public LudoResultAdapter(ArrayList<ResultModel> models, Context mContext) {
        this.mContext = mContext;
        this.models = models;
    }

    public void updateList(ArrayList<ResultModel> newList) {
        this.models.clear();
        this.models.addAll(newList);
        this.notifyDataSetChanged();
    }

    @NonNull
    public holder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(2131558636, parent, false);
        return new holder(view);
    }

    public void onBindViewHolder(@NonNull holder holder2, int position) {
        ResultModel list = this.models.get(position);
        holder2.binding.dateTxt.setText((CharSequence)list.getDate());
        holder2.binding.timeTxt.setText((CharSequence)list.getTime());
        holder2.binding.prizepool.setText((CharSequence)("\u20b9" + list.getPrizepool()));
        holder2.binding.entryFee.setText((CharSequence)("\u20b9" + list.getEntryfee()));
        holder2.binding.teamtype.setText((CharSequence)list.getTeamtype());
        holder2.binding.matchName.setText((CharSequence)(list.getMatchName() + " - Match " + list.getMatchno()));
        holder2.binding.matchMap.setText((CharSequence)list.getMap());
        Picasso.get().load(list.getImages()).placeholder(2131231037).into(holder2.binding.matchImages);
        holder2.itemView.setOnClickListener(view -> {
            Intent intent = new Intent(this.mContext, ClaasicWinnerActivity.class);
            intent.putExtra("matchid", String.valueOf(list.getId()));
            intent.putExtra("gamename", list.getMatchName());
            intent.putExtra("date", list.getDate());
            intent.putExtra("time", list.getTime());
            intent.putExtra("images", list.getImages());
            intent.putExtra("matchno", list.getMatchno());
            this.mContext.startActivity(intent);
        });
    }

    public int getItemCount() {
        return this.models.size();
    }

    public static class holder
    extends RecyclerView.ViewHolder {
        ResultMatchBinding binding;

        public holder(@NonNull View itemView) {
            super(itemView);
            this.binding = ResultMatchBinding.bind(itemView);
        }
    }
}

