/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Adapter;

import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import app.firezone.synk.network.Bgmi_Activity_One;
import app.firezone.synk.network.databinding.LudoMatchDesignBinding;
import app.firezone.synk.network.model.Match_Model;
import com.squareup.picasso.Picasso;
import java.util.ArrayList;

public class LudoMatchAdapter
extends RecyclerView.Adapter<Holder> {
    Context mContext;
    ArrayList<Match_Model> models;

    public LudoMatchAdapter(Context mContext, ArrayList<Match_Model> models) {
        this.mContext = mContext;
        this.models = models;
    }

    public void updateList(ArrayList<Match_Model> newList) {
        this.models.clear();
        this.models.addAll(newList);
        this.notifyDataSetChanged();
    }

    @NonNull
    public Holder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(2131558571, parent, false);
        return new Holder(view);
    }

    public void onBindViewHolder(@NonNull Holder holder2, int position) {
        Match_Model match = this.models.get(position);
        holder2.binding.dateTxt.setText((CharSequence)match.getDate());
        holder2.binding.timeTxt.setText((CharSequence)match.getTime());
        holder2.binding.prizepool.setText((CharSequence)("\u20b9" + match.getPrizepool() + ".00"));
        holder2.binding.entryFee.setText((CharSequence)("\u20b9" + match.getEntryfee()));
        holder2.binding.teamtype.setText((CharSequence)match.getTeamtype());
        holder2.binding.matchName.setText((CharSequence)(match.getMatchName() + " - Match " + match.getMatchno()));
        holder2.binding.matchMap.setText((CharSequence)match.getMap());
        Picasso.get().load(match.getImages()).placeholder(2131231037).error(2131231037).into(holder2.binding.matchImages);
        if (match.isUserJoined()) {
            holder2.binding.btnText.setText((CharSequence)"Joined");
            holder2.binding.joinBtn.setCardBackgroundColor(ContextCompat.getColor((Context)this.mContext, (int)2131099773));
        } else if ("Ongoing".equalsIgnoreCase(match.getMatchstatus())) {
            holder2.binding.btnText.setText((CharSequence)"Started");
            holder2.binding.joinBtn.setCardBackgroundColor(ContextCompat.getColor((Context)this.mContext, (int)2131099773));
        } else {
            holder2.binding.btnText.setText((CharSequence)"Join now");
        }
        int joinedPlayers = match.getJoinedCount();
        int totalSeat = Integer.parseInt(match.getTotalPlayer());
        holder2.binding.joinedProg.setProgress(joinedPlayers);
        holder2.binding.joinedProg.setMax(totalSeat);
        holder2.binding.totalJoinNum.setText((CharSequence)(joinedPlayers + "/" + match.getTotalPlayer()));
        if (joinedPlayers >= totalSeat) {
            holder2.binding.btnText.setText((CharSequence)"Full");
            holder2.binding.totalJoin.setText((CharSequence)"Match Full");
            holder2.binding.joinBtn.setCardBackgroundColor(ContextCompat.getColor((Context)this.mContext, (int)2131099773));
        } else {
            int leftUsers = totalSeat - joinedPlayers;
            holder2.binding.totalJoin.setText((CharSequence)("Only " + leftUsers + " Slots Left."));
        }
        holder2.itemView.setOnClickListener(view -> {
            Intent intent = new Intent(this.mContext, Bgmi_Activity_One.class);
            intent.putExtra("matchid", match.getId());
            intent.putExtra("gamename", match.getGamename());
            intent.putExtra("totalPlayer", match.getTotalPlayer());
            intent.putExtra("entryFee", match.getEntryfee());
            this.mContext.startActivity(intent);
        });
    }

    public int getItemCount() {
        return this.models.size();
    }

    public static class Holder
    extends RecyclerView.ViewHolder {
        LudoMatchDesignBinding binding;

        public Holder(@NonNull View itemView) {
            super(itemView);
            this.binding = LudoMatchDesignBinding.bind(itemView);
        }
    }
}

