/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Adapter;

import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Activities.LotteryInfoActivity;
import app.firezone.synk.network.databinding.ItemLotteryBinding;
import app.firezone.synk.network.model.CheckJoinedResponse;
import app.firezone.synk.network.model.LotteryJoinedResponse;
import app.firezone.synk.network.model.LotteryModel;
import com.squareup.picasso.Picasso;
import java.util.ArrayList;
import java.util.HashMap;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class LotteryAdapter
extends RecyclerView.Adapter<holder> {
    Context mContext;
    ArrayList<LotteryModel> models = new ArrayList();
    private MyApi myApi;
    long userId;

    public LotteryAdapter(Context mContext, ArrayList<LotteryModel> models) {
        this.mContext = mContext;
        this.models = models;
        this.userId = SharedPrefManager.getInstance(mContext).getUserId();
    }

    @NonNull
    public holder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(2131558561, parent, false);
        return new holder(view);
    }

    public void onBindViewHolder(final @NonNull holder holder2, int position) {
        final LotteryModel list = this.models.get(position);
        this.myApi = (MyApi)APIClient.getApiClient(this.mContext).create(MyApi.class);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("userId", this.userId);
        body.put("lotteryid", list.getId());
        Call<CheckJoinedResponse> call = this.myApi.checkIfUserJoined(body);
        call.enqueue((Callback)new Callback<CheckJoinedResponse>(){

            public void onResponse(Call<CheckJoinedResponse> call, Response<CheckJoinedResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    if (((CheckJoinedResponse)response.body()).isSuccess()) {
                        holder2.binding.btnText.setText((CharSequence)"Played");
                    } else {
                        holder2.binding.btnText.setText((CharSequence)"Play Now");
                    }
                }
            }

            public void onFailure(Call<CheckJoinedResponse> call, Throwable t) {
                Toast.makeText((Context)LotteryAdapter.this.mContext, (CharSequence)("Error checking lottery status: " + t.getMessage()), (int)0).show();
            }
        });
        holder2.binding.lotteryName.setText((CharSequence)list.getLotteryname());
        holder2.binding.dateTxt.setText((CharSequence)list.getDate());
        holder2.binding.timeTxt.setText((CharSequence)list.getTime());
        holder2.binding.ratingTxt.setText((CharSequence)list.getRating());
        holder2.binding.prizepool.setText((CharSequence)("Win upto " + list.getPrize() + ".00 Rupees"));
        Picasso.get().load(list.getImages()).placeholder(2131231037).into(holder2.binding.imageView26);
        holder2.itemView.setOnClickListener(view -> {
            Intent intent = new Intent(this.mContext, LotteryInfoActivity.class);
            intent.putExtra("lotteryId", String.valueOf(list.getId()));
            intent.putExtra("entryFee", list.getEntryfee());
            intent.putExtra("totalSeat", list.getTotalSeat());
            intent.putExtra("Prize", list.getPrize());
            this.mContext.startActivity(intent);
        });
        this.myApi = (MyApi)APIClient.getApiClient(this.mContext).create(MyApi.class);
        Call<LotteryJoinedResponse> joinedCall = this.myApi.fetchLotteryJoined(list.getId());
        joinedCall.enqueue((Callback)new Callback<LotteryJoinedResponse>(){

            public void onResponse(Call<LotteryJoinedResponse> call, Response<LotteryJoinedResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    if (((LotteryJoinedResponse)response.body()).isSuccess() && ((LotteryJoinedResponse)response.body()).getData() != null) {
                        long child = ((LotteryJoinedResponse)response.body()).getData().size();
                        long totalSeat = Long.parseLong(list.getTotalSeat());
                        holder2.binding.joinedTxt.setText((CharSequence)(child + "/" + list.getTotalSeat() + " Participants"));
                        if (child >= totalSeat) {
                            holder2.binding.btnText.setText((CharSequence)"Full");
                        }
                    } else {
                        holder2.binding.joinedTxt.setText((CharSequence)("0/" + list.getTotalSeat() + " Participants"));
                        holder2.binding.btnText.setText((CharSequence)"Play Now");
                    }
                } else {
                    Toast.makeText((Context)LotteryAdapter.this.mContext, (CharSequence)"Failed to fetch data or invalid response", (int)0).show();
                }
            }

            public void onFailure(Call<LotteryJoinedResponse> call, Throwable t) {
                Toast.makeText((Context)LotteryAdapter.this.mContext, (CharSequence)("Error fetching joined users: " + t.getMessage()), (int)0).show();
            }
        });
    }

    public int getItemCount() {
        return this.models.size();
    }

    public class holder
    extends RecyclerView.ViewHolder {
        ItemLotteryBinding binding;

        public holder(View itemView) {
            super(itemView);
            this.binding = ItemLotteryBinding.bind(itemView);
        }
    }
}

