/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import app.firezone.synk.network.databinding.ItemLeaderboardBinding;
import app.firezone.synk.network.model.User;
import com.squareup.picasso.Picasso;
import java.util.ArrayList;

public class LeaderboardAdapter
extends RecyclerView.Adapter<viewHolder> {
    ArrayList<User> list;
    Context context;

    public LeaderboardAdapter(ArrayList<User> list, Context context) {
        this.list = list;
        this.context = context;
    }

    @NonNull
    public viewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)this.context);
        ItemLeaderboardBinding binding = ItemLeaderboardBinding.inflate(inflater, parent, false);
        return new viewHolder(binding);
    }

    public void onBindViewHolder(@NonNull viewHolder holder2, int position) {
        User model = this.list.get(position);
        holder2.binding.serialNo.setText((CharSequence)String.valueOf(position + 4));
        holder2.binding.userNam.setText((CharSequence)model.getName());
        holder2.binding.userScore.setText((CharSequence)("\u20b9" + this.formatAmount(model.getTotalEarning())));
        if (model.getProfile() != null && !model.getProfile().isEmpty()) {
            Picasso.get().load(model.getProfile()).placeholder(2131231115).into((ImageView)holder2.binding.userPp);
        } else {
            holder2.binding.userPp.setImageResource(2131231115);
        }
    }

    public int getItemCount() {
        return this.list.size();
    }

    private String formatAmount(double amount) {
        if (amount >= 100000.0) {
            return String.format("%.1fL", amount / 100000.0);
        }
        if (amount >= 1000.0) {
            return String.format("%.1fK", amount / 1000.0);
        }
        return String.format("%.0f", amount);
    }

    public class viewHolder
    extends RecyclerView.ViewHolder {
        ItemLeaderboardBinding binding;

        public viewHolder(ItemLeaderboardBinding binding) {
            super((View)binding.getRoot());
            this.binding = binding;
        }
    }
}

