/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import app.firezone.synk.network.Bgmi_Match_Activity;
import app.firezone.synk.network.FreeFireActivity;
import app.firezone.synk.network.databinding.ItemGameDesignBinding;
import app.firezone.synk.network.model.GameModel;
import com.squareup.picasso.Picasso;
import java.util.ArrayList;

public class GameAdapter
extends RecyclerView.Adapter<holder> {
    Context mContext;
    ArrayList<GameModel> mlist = new ArrayList();

    public GameAdapter(Context mContext, ArrayList<GameModel> mlist) {
        this.mContext = mContext;
        this.mlist = mlist;
    }

    @NonNull
    public holder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(2131558557, parent, false);
        return new holder(view);
    }

    public void onBindViewHolder(@NonNull holder holder2, @SuppressLint(value={"RecyclerView"}) int position) {
        final GameModel model = this.mlist.get(position);
        holder2.binding.gamename.setText((CharSequence)model.getGamename());
        holder2.binding.totalPlayed.setText((CharSequence)model.getTotalPlayed());
        Picasso.get().load(model.getImages()).placeholder(2131231037).into(holder2.binding.gameImg);
        holder2.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (model.getType().equals("Esports")) {
                    Intent intent = new Intent(GameAdapter.this.mContext, Bgmi_Match_Activity.class);
                    intent.putExtra("gamename", model.getGamename());
                    GameAdapter.this.mContext.startActivity(intent);
                } else {
                    Intent intent = new Intent(GameAdapter.this.mContext, FreeFireActivity.class);
                    intent.putExtra("gamename", model.getGamename());
                    GameAdapter.this.mContext.startActivity(intent);
                }
            }
        });
    }

    public int getItemCount() {
        return this.mlist.size();
    }

    public class holder
    extends RecyclerView.ViewHolder {
        ItemGameDesignBinding binding;

        public holder(View itemView) {
            super(itemView);
            this.binding = ItemGameDesignBinding.bind(itemView);
        }
    }
}

