/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Activities.BgmiActivity;
import app.firezone.synk.network.databinding.ResultMatchBinding;
import app.firezone.synk.network.model.CheckJoinedResponse;
import app.firezone.synk.network.model.ResultModel;
import com.squareup.picasso.Picasso;
import java.util.ArrayList;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class BgmiResultAdapter
extends RecyclerView.Adapter<holder> {
    Context mContext;
    ArrayList<ResultModel> mlist = new ArrayList();

    public BgmiResultAdapter(ArrayList<ResultModel> mlist, Context mContext) {
        this.mContext = mContext;
        this.mlist = mlist;
    }

    @NonNull
    public holder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(2131558636, parent, false);
        return new holder(view);
    }

    public void onBindViewHolder(@NonNull holder holder2, @SuppressLint(value={"RecyclerView"}) int position) {
        final ResultModel list = this.mlist.get(position);
        holder2.binding.dateTxt.setText((CharSequence)list.getDate());
        holder2.binding.timeTxt.setText((CharSequence)list.getTime());
        holder2.binding.prizepool.setText((CharSequence)("\u20b9" + list.getPrizepool() + ".00"));
        holder2.binding.perkill.setText((CharSequence)("\u20b9" + list.getPerkill() + ".00"));
        holder2.binding.entryFee.setText((CharSequence)("\u20b9" + list.getEntryfee()));
        holder2.binding.teamtype.setText((CharSequence)list.getTeamtype());
        holder2.binding.matchName.setText((CharSequence)(list.getGamename() + " ( SKILL GAME ) - Match " + list.getMatchno()));
        holder2.binding.matchMap.setText((CharSequence)list.getMap());
        this.checkUserJoinedStatus(holder2, list);
        Picasso.get().load(list.getImages()).placeholder(2131231037).into(holder2.binding.matchImages);
        holder2.binding.matchWatchBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent browserIntent = new Intent("android.intent.action.VIEW");
                browserIntent.setData(Uri.parse((String)list.getVideourl()));
                BgmiResultAdapter.this.mContext.startActivity(browserIntent);
            }
        });
        holder2.binding.matchResultBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent intent = new Intent(BgmiResultAdapter.this.mContext, BgmiActivity.class);
                intent.putExtra("matchid", String.valueOf(list.getId()));
                intent.putExtra("gamename", list.getGamename());
                intent.putExtra("date", list.getDate());
                intent.putExtra("time", list.getTime());
                intent.putExtra("images", list.getImages());
                intent.putExtra("matchno", list.getMatchno());
                BgmiResultAdapter.this.mContext.startActivity(intent);
            }
        });
    }

    private void checkUserJoinedStatus(final holder holder2, ResultModel list) {
        long userId = SharedPrefManager.getInstance(this.mContext).getUserId();
        MyApi myApi = (MyApi)APIClient.getApiClient(this.mContext).create(MyApi.class);
        Call<CheckJoinedResponse> call = myApi.checkIfUserJoined(userId, list.getId());
        call.enqueue((Callback)new Callback<CheckJoinedResponse>(){

            public void onResponse(Call<CheckJoinedResponse> call, Response<CheckJoinedResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    CheckJoinedResponse responseBody = (CheckJoinedResponse)response.body();
                    if (responseBody.isSuccess()) {
                        holder2.binding.btnText.setText((CharSequence)"View Result");
                    } else {
                        holder2.binding.btnText.setText((CharSequence)"Not Joined");
                        holder2.binding.matchResultBtn.setCardBackgroundColor(ContextCompat.getColor((Context)BgmiResultAdapter.this.mContext, (int)2131099773));
                    }
                }
            }

            public void onFailure(Call<CheckJoinedResponse> call, Throwable throwable) {
                Toast.makeText((Context)BgmiResultAdapter.this.mContext, (CharSequence)("Error: " + throwable.getMessage()), (int)0).show();
            }
        });
    }

    public int getItemCount() {
        return this.mlist.size();
    }

    public class holder
    extends RecyclerView.ViewHolder {
        ResultMatchBinding binding;

        public holder(View itemView) {
            super(itemView);
            this.binding = ResultMatchBinding.bind(itemView);
        }
    }
}

