/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Activities;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Activities.Add_Money_Activity;
import app.firezone.synk.network.Activities.DepositPaymentSavedActivity;
import app.firezone.synk.network.Activities.RedeemActivity;
import app.firezone.synk.network.Activities.TransactionHistoryActivity;
import app.firezone.synk.network.Activities.WithdrawPaymentSavedActivity;
import app.firezone.synk.network.databinding.ActivityWalletBinding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.User;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.database.FirebaseDatabase;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class WalletActivity
extends AppCompatActivity {
    ActivityWalletBinding binding;
    FirebaseDatabase database;
    private MyApi myApi;
    FirebaseUser auth;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityWalletBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.binding.backArrow.setOnClickListener(v -> this.finish());
        this.binding.addMoneyBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                WalletActivity.this.startActivity(new Intent((Context)WalletActivity.this, Add_Money_Activity.class));
            }
        });
        this.binding.withdrawMoneyBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                WalletActivity.this.startActivity(new Intent((Context)WalletActivity.this, RedeemActivity.class));
            }
        });
        this.binding.transactionHistoryCard.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                WalletActivity.this.startActivity(new Intent((Context)WalletActivity.this, TransactionHistoryActivity.class));
            }
        });
        this.binding.withdrawSavedCard.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                WalletActivity.this.startActivity(new Intent((Context)WalletActivity.this, WithdrawPaymentSavedActivity.class));
            }
        });
        this.binding.depositSavedCard.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                WalletActivity.this.startActivity(new Intent((Context)WalletActivity.this, DepositPaymentSavedActivity.class));
            }
        });
        long userId = SharedPrefManager.getInstance((Context)this).getUserId();
        this.myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        Call<ApiResponse> calls = this.myApi.fetchProfileData(userId);
        calls.enqueue((Callback)new Callback<ApiResponse>(){

            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    User model = ((ApiResponse)response.body()).getUser();
                    double totalWinBal = model.getWinBalance();
                    double totalDepoBal = model.getDepoBalance();
                    double totalBonusBal = model.getBonusBalance();
                    String totalBal = String.valueOf(totalDepoBal + totalWinBal + totalBonusBal);
                    WalletActivity.this.binding.balanceTxt.setText((CharSequence)("\u20b9" + totalBal));
                    WalletActivity.this.binding.depoBalanceTxt.setText((CharSequence)String.valueOf("\u20b9" + totalDepoBal));
                    WalletActivity.this.binding.winBalanceTxt.setText((CharSequence)String.valueOf("\u20b9" + totalWinBal));
                    WalletActivity.this.binding.bonusBalanceTxt.setText((CharSequence)String.valueOf("\u20b9" + totalBonusBal));
                } else {
                    Toast.makeText((Context)WalletActivity.this, (CharSequence)"Failed to fetch user data", (int)0).show();
                }
            }

            public void onFailure(Call<ApiResponse> call, Throwable throwable) {
            }
        });
    }
}

