/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Activities;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Adapter.TrHistoryAdapter;
import app.firezone.synk.network.databinding.ActivityTransactionHistoryBinding;
import app.firezone.synk.network.model.TransactionModel;
import app.firezone.synk.network.model.TransactionResponse;
import java.util.ArrayList;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class TransactionHistoryActivity
extends AppCompatActivity {
    ActivityTransactionHistoryBinding binding;
    ArrayList<TransactionModel> list;
    TrHistoryAdapter adapter;
    long userId;
    Dialog dialog;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityTransactionHistoryBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.binding.backArrow.setOnClickListener(v -> this.finish());
        this.dialog = new Dialog((Context)this);
        this.dialog.setContentView(2131558570);
        if (this.dialog.getWindow() != null) {
            this.dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.dialog.setCancelable(true);
        }
        this.dialog.show();
        LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this);
        this.binding.historyRecy.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        layoutManager.setReverseLayout(true);
        layoutManager.setStackFromEnd(true);
        this.binding.historyRecy.setHasFixedSize(true);
        this.userId = SharedPrefManager.getInstance((Context)this).getUserId();
        if (this.userId <= 0L) {
            Toast.makeText((Context)this, (CharSequence)"Invalid user ID", (int)0).show();
            return;
        }
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        Call<TransactionResponse> call = myApi.fetchUserTransaction(this.userId);
        call.enqueue((Callback)new Callback<TransactionResponse>(){

            public void onResponse(Call<TransactionResponse> call, Response<TransactionResponse> response) {
                TransactionHistoryActivity.this.dialog.dismiss();
                if (response.isSuccessful() && response.body() != null) {
                    if (((TransactionResponse)response.body()).isSuccess()) {
                        ArrayList<TransactionModel> list = ((TransactionResponse)response.body()).getTransactions();
                        if (!list.isEmpty()) {
                            TransactionHistoryActivity.this.adapter = new TrHistoryAdapter((Context)TransactionHistoryActivity.this, list);
                            TransactionHistoryActivity.this.binding.historyRecy.setAdapter((RecyclerView.Adapter)TransactionHistoryActivity.this.adapter);
                        } else {
                            Toast.makeText((Context)TransactionHistoryActivity.this, (CharSequence)"No Recent Transactions.", (int)0).show();
                        }
                    } else {
                        Toast.makeText((Context)TransactionHistoryActivity.this, (CharSequence)((TransactionResponse)response.body()).getMessage(), (int)0).show();
                    }
                } else {
                    Toast.makeText((Context)TransactionHistoryActivity.this, (CharSequence)"Failed to fetch transactions", (int)0).show();
                }
            }

            public void onFailure(Call<TransactionResponse> call, Throwable t) {
                TransactionHistoryActivity.this.dialog.dismiss();
                Toast.makeText((Context)TransactionHistoryActivity.this, (CharSequence)("Error: " + t.getMessage()), (int)0).show();
            }
        });
    }
}

