/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Activities;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.util.Log;
import android.view.View;
import androidx.appcompat.app.AppCompatActivity;
import app.firezone.synk.network.Activities.HelpActivity;
import app.firezone.synk.network.Network.IpAddressHelper;
import app.firezone.synk.network.databinding.ActivityTransactionDetailBinding;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class TransactionDetailActivity
extends AppCompatActivity {
    ActivityTransactionDetailBinding binding;
    String amount;
    String type;
    String method;
    String status;
    String date;
    String time;
    String transactionId;

    protected void onCreate(Bundle savedInstanceState) {
        block6: {
            super.onCreate(savedInstanceState);
            this.binding = ActivityTransactionDetailBinding.inflate(this.getLayoutInflater());
            this.setContentView((View)this.binding.getRoot());
            this.binding.backArrow.setOnClickListener(v -> this.finish());
            this.amount = this.getIntent().getStringExtra("amount");
            this.type = this.getIntent().getStringExtra("type");
            this.method = this.getIntent().getStringExtra("method");
            this.status = this.getIntent().getStringExtra("status");
            this.date = this.getIntent().getStringExtra("date");
            this.time = this.getIntent().getStringExtra("time");
            this.transactionId = this.getIntent().getStringExtra("transactionId");
            this.binding.amountTxt.setText((CharSequence)("\u20b9" + this.amount));
            this.binding.type.setText((CharSequence)this.type);
            this.binding.method.setText((CharSequence)this.method);
            this.binding.transactionId.setText((CharSequence)this.transactionId);
            this.binding.dateTime.setText((CharSequence)(this.date + ", " + this.time));
            IpAddressHelper ipProvider = new IpAddressHelper((Context)this);
            String ipAddress = ipProvider.getIpAddress();
            this.binding.ipAddress.setText((CharSequence)ipAddress);
            String deviceModel = Build.MANUFACTURER + " " + Build.MODEL;
            this.binding.deviceName.setText((CharSequence)deviceModel);
            String appname = this.getString(2131951651);
            this.binding.discription.setText((CharSequence)("Thank you being Transaction On " + appname));
            this.binding.contactSupport.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    TransactionDetailActivity.this.startActivity(new Intent((Context)TransactionDetailActivity.this, HelpActivity.class));
                }
            });
            if (this.type.equalsIgnoreCase("Withdraw")) {
                try {
                    long thirtyMinutesMillis;
                    String dateTimeString = this.date + " " + this.time;
                    Log.d((String)"DEBUG_TIME", (String)("DateTimeString: " + dateTimeString));
                    SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yy HH:mm:ss", Locale.getDefault());
                    Date transactionDate = sdf.parse(dateTimeString);
                    if (transactionDate == null) {
                        this.binding.payStatus.setText((CharSequence)"Pending");
                        return;
                    }
                    long transactionMillis = transactionDate.getTime();
                    long currentMillis = System.currentTimeMillis();
                    long diff = currentMillis - transactionMillis;
                    if (diff >= (thirtyMinutesMillis = 1800000L)) {
                        this.binding.payStatus.setText((CharSequence)"Success");
                        this.binding.payStatusCard.setBackgroundResource(2131231204);
                        break block6;
                    }
                    long timeLeft = thirtyMinutesMillis - diff;
                    new CountDownTimer(timeLeft, 1000L){

                        public void onTick(long millisUntilFinished) {
                            long hours = TimeUnit.MILLISECONDS.toHours(millisUntilFinished);
                            long minutes = TimeUnit.MILLISECONDS.toMinutes(millisUntilFinished) % 60L;
                            long seconds = TimeUnit.MILLISECONDS.toSeconds(millisUntilFinished) % 60L;
                            TransactionDetailActivity.this.binding.payStatus.setText((CharSequence)String.format("%02d:%02d:%02d", hours, minutes, seconds));
                        }

                        public void onFinish() {
                            TransactionDetailActivity.this.binding.payStatus.setText((CharSequence)"Success");
                            TransactionDetailActivity.this.binding.payStatusCard.setBackgroundResource(2131231204);
                        }
                    }.start();
                }
                catch (ParseException e) {
                    Log.e((String)"DEBUG_TIME", (String)("ParseException: " + e.getMessage()));
                    this.binding.payStatus.setText((CharSequence)"Pending");
                }
            } else {
                this.binding.payStatus.setText((CharSequence)"Success");
                this.binding.payStatusCard.setBackgroundResource(2131231204);
            }
        }
    }
}

