/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Activities;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import androidx.appcompat.app.AppCompatActivity;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Activities.LoginActivity;
import app.firezone.synk.network.Activities.NoInternetActivity;
import app.firezone.synk.network.MainActivity;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

public class SplashActivity
extends AppCompatActivity {
    private final Handler handler = new Handler(Looper.getMainLooper());

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131558470);
        this.checkConnectionAndProceed();
    }

    private void checkConnectionAndProceed() {
        new Thread(() -> {
            boolean connected = this.isInternetAvailable() && this.hasRealInternetAccess();
            this.handler.post(() -> {
                if (!connected) {
                    this.startActivity(new Intent((Context)this, NoInternetActivity.class));
                    this.finish();
                } else {
                    this.showSlowInternetDialogIfNeeded();
                }
            });
        }).start();
    }

    private void showSlowInternetDialogIfNeeded() {
        new Thread(() -> {
            boolean isSlow = this.isInternetSlow();
            this.handler.post(() -> {
                if (isSlow) {
                    this.showSlowDialog();
                } else {
                    this.goToNextScreenWithDelay();
                }
            });
        }).start();
    }

    private void showSlowDialog() {
        new AlertDialog.Builder((Context)this).setTitle((CharSequence)"Slow Internet").setMessage((CharSequence)"Your internet connection seems slow. Please wait or switch to a better network.").setCancelable(false).setPositiveButton((CharSequence)"Retry", (dialog, which) -> this.checkConnectionAndProceed()).setNegativeButton((CharSequence)"Exit", (dialog, which) -> this.finish()).show();
    }

    private void goToNextScreenWithDelay() {
        this.handler.postDelayed(() -> {
            long userId = SharedPrefManager.getInstance((Context)this).getUserId();
            Intent intent = userId == -1L ? new Intent((Context)this, LoginActivity.class) : new Intent((Context)this, MainActivity.class);
            this.startActivity(intent);
            this.finish();
        }, 1000L);
    }

    private boolean isInternetAvailable() {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.isInternetAvailableModern();
        }
        return this.isInternetAvailableLegacy();
    }

    @TargetApi(value=23)
    private boolean isInternetAvailableModern() {
        ConnectivityManager cm = (ConnectivityManager)this.getSystemService("connectivity");
        if (cm == null) {
            return false;
        }
        Network network = cm.getActiveNetwork();
        if (network == null) {
            return false;
        }
        NetworkCapabilities capabilities = cm.getNetworkCapabilities(network);
        return capabilities != null && capabilities.hasCapability(12) && capabilities.hasCapability(16);
    }

    private boolean isInternetAvailableLegacy() {
        ConnectivityManager cm = (ConnectivityManager)this.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm != null ? cm.getActiveNetworkInfo() : null;
        return activeNetwork != null && activeNetwork.isConnected();
    }

    private boolean hasRealInternetAccess() {
        try {
            HttpURLConnection urlc = (HttpURLConnection)new URL("https://clients3.google.com/generate_204").openConnection();
            urlc.setRequestProperty("User-Agent", "Android");
            urlc.setRequestProperty("Connection", "close");
            urlc.setConnectTimeout(1500);
            urlc.connect();
            return urlc.getResponseCode() == 204;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean isInternetSlow() {
        try {
            long start = System.currentTimeMillis();
            HttpURLConnection connection = (HttpURLConnection)new URL("https://clients3.google.com/generate_204").openConnection();
            connection.setConnectTimeout(2000);
            connection.connect();
            long end = System.currentTimeMillis();
            return end - start > 2000L;
        }
        catch (IOException e) {
            return true;
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
    }
}

