/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Activities;

import android.app.Activity;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Activities.LoginActivity;
import app.firezone.synk.network.MainActivity;
import app.firezone.synk.network.databinding.ActivitySignupBinding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.CheckEmailResponse;
import app.firezone.synk.network.model.LoginResponse;
import app.firezone.synk.network.model.User;
import com.google.android.gms.auth.api.signin.GoogleSignIn;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInClient;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.tasks.Task;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GoogleAuthProvider;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class SignupActivity
extends AppCompatActivity {
    ActivitySignupBinding binding;
    GoogleSignInClient mGoogleSignInClient;
    int RC_SIGN_IN = 11;
    FirebaseAuth mAuth;
    FirebaseUser user;
    private MyApi myApi;
    EditText phoneNo;
    EditText referCodes;
    ProgressDialog dialog;
    Dialog dialog2;
    long referBonus;
    EditText nameEt;
    EditText emailET;
    EditText phoneNo_Et;
    EditText passwordEt;
    EditText referralcode;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivitySignupBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.nameEt = (EditText)this.findViewById(2131362513);
        this.emailET = (EditText)this.findViewById(2131362194);
        this.referralcode = (EditText)this.findViewById(2131362680);
        this.passwordEt = (EditText)this.findViewById(2131362588);
        this.phoneNo_Et = (EditText)this.findViewById(2131362605);
        this.mAuth = FirebaseAuth.getInstance();
        this.dialog = new ProgressDialog((Context)this);
        this.dialog.setTitle((CharSequence)"User Account Creating ");
        this.dialog.setMessage((CharSequence)"Please Wait...");
        this.dialog.setCancelable(false);
        GoogleSignInOptions gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN).requestIdToken(this.getString(2131951677)).requestEmail().build();
        this.mGoogleSignInClient = GoogleSignIn.getClient((Activity)this, (GoogleSignInOptions)gso);
        this.binding.googleBtn.setOnClickListener(view -> this.initiateGoogleLogin());
        this.binding.alreadyAccount.setOnClickListener(v -> {
            this.startActivity(new Intent(this.getApplicationContext(), LoginActivity.class));
            this.finish();
        });
        this.binding.linkTxt.setMovementMethod(LinkMovementMethod.getInstance());
        this.binding.btnSignUp.setOnClickListener(v -> {
            String name = this.nameEt.getText().toString();
            String email = this.emailET.getText().toString().trim();
            String password = this.passwordEt.getText().toString();
            String phoneno = this.phoneNo_Et.getText().toString().trim();
            String username = this.referralcode.getText().toString();
            if (TextUtils.isEmpty((CharSequence)name)) {
                this.nameEt.setError((CharSequence)"Name is Required");
                return;
            }
            if (TextUtils.isEmpty((CharSequence)email)) {
                this.emailET.setError((CharSequence)"Email is Required");
                return;
            }
            if (TextUtils.isEmpty((CharSequence)phoneno)) {
                this.phoneNo_Et.setError((CharSequence)"Phone no. is Required");
                return;
            }
            if (TextUtils.isEmpty((CharSequence)password)) {
                this.passwordEt.setError((CharSequence)"Password is Required");
                return;
            }
            if (password.length() < 6) {
                this.passwordEt.setError((CharSequence)"Password must be 6 characters or more");
                return;
            }
            this.dialog.show();
            this.checkEmailExists(email);
        });
    }

    private void initiateGoogleLogin() {
        Intent signInIntent = this.mGoogleSignInClient.getSignInIntent();
        this.startActivityForResult(signInIntent, this.RC_SIGN_IN);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == this.RC_SIGN_IN) {
            Task task = GoogleSignIn.getSignedInAccountFromIntent((Intent)data);
            this.handleSignInResult((Task<GoogleSignInAccount>)task);
        }
    }

    private void handleSignInResult(Task<GoogleSignInAccount> completedTask) {
        try {
            GoogleSignInAccount account = (GoogleSignInAccount)completedTask.getResult(ApiException.class);
            if (account != null) {
                this.checkUserExistsInDatabase(account.getEmail(), account.getIdToken());
            }
        }
        catch (ApiException e) {
            Toast.makeText((Context)this, (CharSequence)"Google sign-in failed.", (int)0).show();
        }
    }

    private void checkUserExistsInDatabase(String email, final String idToken) {
        this.myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        Call<CheckEmailResponse> call = this.myApi.checkEmailExists(email);
        call.enqueue((Callback)new Callback<CheckEmailResponse>(){

            public void onResponse(Call<CheckEmailResponse> call, Response<CheckEmailResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    if (((CheckEmailResponse)response.body()).isSuccess()) {
                        Toast.makeText((Context)SignupActivity.this, (CharSequence)"Account already exists", (int)0).show();
                    } else {
                        SignupActivity.this.authWithGoogle(idToken);
                    }
                }
            }

            public void onFailure(Call<CheckEmailResponse> call, Throwable t) {
                Toast.makeText((Context)SignupActivity.this, (CharSequence)("Failed: " + t.getMessage()), (int)0).show();
            }
        });
    }

    void authWithGoogle(String idToken) {
        AuthCredential credential = GoogleAuthProvider.getCredential((String)idToken, null);
        this.mAuth.signInWithCredential(credential).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                this.user = this.mAuth.getCurrentUser();
                this.showPhoneAndReferralDialog();
            } else {
                Toast.makeText((Context)this, (CharSequence)"Google Auth Failed", (int)0).show();
            }
        });
    }

    private void checkEmailExists(String email) {
        this.myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        Call<CheckEmailResponse> call = this.myApi.checkEmailExists(email);
        call.enqueue((Callback)new Callback<CheckEmailResponse>(){

            public void onResponse(Call<CheckEmailResponse> call, Response<CheckEmailResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    if (((CheckEmailResponse)response.body()).isSuccess()) {
                        SignupActivity.this.dialog.dismiss();
                        Toast.makeText((Context)SignupActivity.this, (CharSequence)"Account already exists", (int)0).show();
                    } else {
                        SignupActivity.this.createUserByEmailPass();
                    }
                }
            }

            public void onFailure(Call<CheckEmailResponse> call, Throwable t) {
                Toast.makeText((Context)SignupActivity.this, (CharSequence)("Error: " + t.getMessage()), (int)0).show();
            }
        });
    }

    private void createUserByEmailPass() {
        String name;
        String profile = this.getString(2131951650);
        String username = name = this.nameEt.getText().toString().trim();
        final String email = this.emailET.getText().toString().trim();
        final String password = this.passwordEt.getText().toString().trim();
        final String referred = this.referralcode.getText().toString().trim();
        String phoneno = this.phoneNo_Et.getText().toString().trim();
        long depoBalance = 0L;
        long bonusBalance = 5L;
        long winBalance = 0L;
        long totalKills = 0L;
        long totalEarning = 0L;
        long matchPlayed = 0L;
        String referCode = email.substring(0, email.lastIndexOf("@")).replace(".", "");
        String joinedDate = new SimpleDateFormat("dd-MM-yyyy", Locale.getDefault()).format(new Date());
        String status = "Active";
        String loginVia = "0";
        this.myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        Call<User> call = this.myApi.registerUser(username, name, email, password, phoneno, profile, depoBalance, winBalance, bonusBalance, referred, joinedDate, loginVia, status, totalKills, matchPlayed, referCode, totalEarning);
        call.enqueue((Callback)new Callback<User>(){

            public void onResponse(Call<User> call, Response<User> response) {
                SignupActivity.this.dialog.dismiss();
                if (response.isSuccessful() && response.body() != null) {
                    Toast.makeText((Context)SignupActivity.this, (CharSequence)"Account Created", (int)0).show();
                    SignupActivity.this.loginAfterSignup(email, password);
                    if (!referred.isEmpty()) {
                        SignupActivity.this.handleReferral(referred);
                    }
                } else {
                    try {
                        String errorBody = response.errorBody().string();
                        Log.e((String)"SignupError", (String)errorBody);
                        Toast.makeText((Context)SignupActivity.this, (CharSequence)("Signup Failed:\n" + errorBody), (int)1).show();
                    }
                    catch (Exception e) {
                        Toast.makeText((Context)SignupActivity.this, (CharSequence)("Signup Failed: " + response.message()), (int)0).show();
                        Log.e((String)"Signup Exception", (String)response.message());
                    }
                }
            }

            public void onFailure(Call<User> call, Throwable t) {
                SignupActivity.this.dialog.dismiss();
                Toast.makeText((Context)SignupActivity.this, (CharSequence)("Error: " + t.getMessage()), (int)0).show();
            }
        });
    }

    private void showPhoneAndReferralDialog() {
        this.dialog2 = new Dialog((Context)this);
        this.dialog2.setContentView(2131558592);
        this.dialog2.setCancelable(false);
        this.phoneNo = (EditText)this.dialog2.findViewById(2131362605);
        this.referCodes = (EditText)this.dialog2.findViewById(2131362675);
        Button verifyBtn = (Button)this.dialog2.findViewById(2131363055);
        verifyBtn.setOnClickListener(view -> {
            String phone = this.phoneNo.getText().toString();
            String referby = this.referCodes.getText().toString();
            if (TextUtils.isEmpty((CharSequence)phone)) {
                this.phoneNo.setError((CharSequence)"Enter Phone number");
                return;
            }
            this.dialog2.dismiss();
            this.createUserByGoogle(phone, referby);
        });
        this.dialog2.show();
        this.dialog2.getWindow().setLayout(-1, -2);
        this.dialog2.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.dialog2.getWindow().setGravity(80);
    }

    private void createUserByGoogle(String phone, final String referby) {
        String name;
        String profile = this.user.getPhotoUrl().toString();
        String username = name = this.user.getDisplayName();
        final String email = this.user.getEmail();
        final String password = this.user.getUid();
        String joinedDate = new SimpleDateFormat("dd-MM-yyyy", Locale.getDefault()).format(new Date());
        long depoBalance = 0L;
        long bonusBalance = 5L;
        long winBalance = 0L;
        long totalKills = 0L;
        long totalEarning = 0L;
        long matchPlayed = 0L;
        String referCode = email.substring(0, email.lastIndexOf("@")).replace(".", "");
        String status = "Active";
        String loginVia = "1";
        this.myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        Call<User> call = this.myApi.registerUser(username, name, email, password, phone, profile, depoBalance, winBalance, bonusBalance, referby, joinedDate, loginVia, status, totalKills, matchPlayed, referCode, totalEarning);
        call.enqueue((Callback)new Callback<User>(){

            public void onResponse(Call<User> call, Response<User> response) {
                SignupActivity.this.dialog.dismiss();
                if (response.isSuccessful() && response.body() != null) {
                    Toast.makeText((Context)SignupActivity.this, (CharSequence)"Google Account Created", (int)0).show();
                    SignupActivity.this.loginAfterSignup(email, password);
                    if (!referby.isEmpty()) {
                        SignupActivity.this.handleReferral(referby);
                    }
                } else {
                    Toast.makeText((Context)SignupActivity.this, (CharSequence)"Google Signup Failed", (int)0).show();
                }
            }

            public void onFailure(Call<User> call, Throwable t) {
                SignupActivity.this.dialog.dismiss();
                Toast.makeText((Context)SignupActivity.this, (CharSequence)("Error: " + t.getMessage()), (int)0).show();
            }
        });
    }

    private void loginAfterSignup(String email, String password) {
        this.myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        Call<LoginResponse> call = this.myApi.loginUser(email, password);
        call.enqueue((Callback)new Callback<LoginResponse>(){

            public void onResponse(Call<LoginResponse> call, Response<LoginResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    LoginResponse res = (LoginResponse)response.body();
                    SharedPrefManager pref = SharedPrefManager.getInstance((Context)SignupActivity.this);
                    pref.saveUserId(res.getUserId());
                    pref.saveAccessToken(res.getAccess_token());
                    SignupActivity.this.startActivity(new Intent((Context)SignupActivity.this, MainActivity.class));
                    SignupActivity.this.finish();
                } else {
                    Toast.makeText((Context)SignupActivity.this, (CharSequence)("Login failed: " + response.message()), (int)0).show();
                }
            }

            public void onFailure(Call<LoginResponse> call, Throwable t) {
                Toast.makeText((Context)SignupActivity.this, (CharSequence)("Login error: " + t.getMessage()), (int)0).show();
            }
        });
    }

    private void handleReferral(String referCode) {
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        Call<ApiResponse> call = myApi.checkReferral(referCode);
        call.enqueue((Callback)new Callback<ApiResponse>(){

            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    Toast.makeText((Context)SignupActivity.this, (CharSequence)((ApiResponse)response.body()).getMessage(), (int)0).show();
                }
            }

            public void onFailure(Call<ApiResponse> call, Throwable t) {
                Toast.makeText((Context)SignupActivity.this, (CharSequence)("Referral check failed: " + t.getMessage()), (int)0).show();
            }
        });
    }
}

