/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Activities;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Adapter.LeaderboardAdapter;
import app.firezone.synk.network.databinding.ActivitySubjectBinding;
import app.firezone.synk.network.model.User;
import com.squareup.picasso.Picasso;
import java.util.ArrayList;
import java.util.List;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class ScoreActivity
extends AppCompatActivity {
    ActivitySubjectBinding binding;
    ArrayList<User> list;
    LeaderboardAdapter adapter;
    private MyApi myApi;
    Dialog dialog;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivitySubjectBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.binding.backArrow.setOnClickListener(v -> this.finish());
        long userId = SharedPrefManager.getInstance((Context)this).getUserId();
        this.myApi = (MyApi)APIClient.getApiClient((Context)this).create(MyApi.class);
        this.list = new ArrayList();
        this.dialog = new Dialog((Context)this);
        this.dialog.setContentView(2131558570);
        if (this.dialog.getWindow() != null) {
            this.dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.dialog.setCancelable(true);
        }
        this.dialog.show();
        LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this);
        this.binding.recyclerViewLeaderboard.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.adapter = new LeaderboardAdapter(this.list, (Context)this);
        this.binding.recyclerViewLeaderboard.setAdapter((RecyclerView.Adapter)this.adapter);
        Call<List<User>> calls = this.myApi.getUsersOrderedByEarning();
        calls.enqueue((Callback)new Callback<List<User>>(){

            public void onResponse(Call<List<User>> call, Response<List<User>> response) {
                if (response.isSuccessful() && response.body() != null) {
                    List userList = (List)response.body();
                    if (!userList.isEmpty()) {
                        ScoreActivity.this.setTopThreeUsers(userList);
                        int endIndex = Math.min(userList.size(), 100);
                        List remainingUsers = userList.size() > 3 ? userList.subList(3, endIndex) : new ArrayList();
                        ScoreActivity.this.list.clear();
                        ScoreActivity.this.list.addAll(remainingUsers);
                        ScoreActivity.this.adapter.notifyDataSetChanged();
                        ScoreActivity.this.dialog.dismiss();
                    } else {
                        ScoreActivity.this.dialog.dismiss();
                        Toast.makeText((Context)ScoreActivity.this, (CharSequence)"No users found", (int)0).show();
                    }
                } else {
                    ScoreActivity.this.dialog.dismiss();
                    Toast.makeText((Context)ScoreActivity.this, (CharSequence)"Failed to fetch users", (int)0).show();
                }
            }

            public void onFailure(Call<List<User>> call, Throwable t) {
                ScoreActivity.this.dialog.dismiss();
                Toast.makeText((Context)ScoreActivity.this, (CharSequence)("Error: " + t.getMessage()), (int)0).show();
            }
        });
    }

    private void setTopThreeUsers(List<User> users) {
        if (users.size() >= 1) {
            User user1 = users.get(0);
            this.binding.top1Name.setText((CharSequence)user1.getName());
            this.binding.top1Amount.setText((CharSequence)("\u20b9" + this.formatAmount(user1.getTotalEarning())));
            Picasso.get().load(user1.getProfile()).placeholder(2131231115).into((ImageView)this.binding.top1Image);
        }
        if (users.size() >= 2) {
            User user2 = users.get(1);
            this.binding.top2Name.setText((CharSequence)user2.getName());
            this.binding.top2Amount.setText((CharSequence)("\u20b9" + this.formatAmount(user2.getTotalEarning())));
            Picasso.get().load(user2.getProfile()).placeholder(2131231115).into((ImageView)this.binding.top2Image);
        }
        if (users.size() >= 3) {
            User user3 = users.get(2);
            this.binding.top3Name.setText((CharSequence)user3.getName());
            this.binding.top3Amount.setText((CharSequence)("\u20b9" + this.formatAmount(user3.getTotalEarning())));
            Picasso.get().load(user3.getProfile()).placeholder(2131231115).into((ImageView)this.binding.top3Image);
        }
    }

    private String formatAmount(double amount) {
        if (amount >= 100000.0) {
            return String.format("%.2fL", amount / 100000.0);
        }
        if (amount >= 1000.0) {
            return String.format("%.2fK", amount / 1000.0);
        }
        return String.format("%.2f", amount);
    }
}

