/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Activities;

import android.app.Dialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.databinding.ActivityReferBinding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.AppModel;
import app.firezone.synk.network.model.User;
import java.net.UnknownHostException;
import java.util.ArrayList;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class ReferActivity
extends AppCompatActivity {
    ActivityReferBinding binding;
    String referCode;
    String appurl;
    private ClipboardManager myClipboard;
    private ClipData myClip;
    Dialog dialog;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityReferBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.loadData();
        this.myClipboard = (ClipboardManager)this.getSystemService("clipboard");
        this.dialog = new Dialog((Context)this);
        this.dialog.setContentView(2131558570);
        if (this.dialog.getWindow() != null) {
            this.dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.dialog.setCancelable(true);
        }
        this.dialog.show();
        long userId = SharedPrefManager.getInstance((Context)this).getUserId();
        MyApi myApi = (MyApi)APIClient.getApiClient((Context)this).create(MyApi.class);
        Call<ApiResponse> call = myApi.fetchProfileData(userId);
        call.enqueue((Callback)new Callback<ApiResponse>(){

            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    User model = ((ApiResponse)response.body()).getUser();
                    ReferActivity.this.referCode = model.getReferCode();
                    ReferActivity.this.binding.refercodeTxt.setText((CharSequence)model.getReferCode());
                } else {
                    Toast.makeText((Context)ReferActivity.this, (CharSequence)"Failed to load user data", (int)0).show();
                }
            }

            public void onFailure(Call<ApiResponse> call, Throwable throwable) {
                if (throwable instanceof UnknownHostException) {
                    Toast.makeText((Context)ReferActivity.this, (CharSequence)"Something went wrong", (int)0).show();
                } else {
                    Toast.makeText((Context)ReferActivity.this, (CharSequence)"Something went wrong", (int)0).show();
                    Log.e((String)"API_ERROR", (String)"Failure", (Throwable)throwable);
                }
            }
        });
        this.binding.copyBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String text = ReferActivity.this.binding.refercodeTxt.getText().toString();
                ReferActivity.this.myClip = ClipData.newPlainText((CharSequence)"text", (CharSequence)text);
                ReferActivity.this.myClipboard.setPrimaryClip(ReferActivity.this.myClip);
                Toast.makeText((Context)ReferActivity.this, (CharSequence)"Refer Code Copied", (int)0).show();
            }
        });
        final String appname = this.getString(2131951651);
        this.binding.referBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    Intent shareIntent = new Intent("android.intent.action.SEND");
                    shareIntent.setType("text/plain");
                    shareIntent.putExtra("android.intent.extra.SUBJECT", "Check out this gaming app!");
                    String shareMessage = "Hi, friend!\n" + appname + " is my favorite gaming app \u2013 play and win real cash every day!\nDownload now and get \u20b910 instantly, plus 20% cashback on your first deposit.\nMy referral code: " + ReferActivity.this.referCode + "\nDownload and play now: " + ReferActivity.this.appurl;
                    shareIntent.putExtra("android.intent.extra.TEXT", shareMessage);
                    ReferActivity.this.startActivity(Intent.createChooser((Intent)shareIntent, (CharSequence)"Choose an app to share"));
                }
                catch (Exception e) {
                    Toast.makeText((Context)ReferActivity.this, (CharSequence)"Error", (int)0).show();
                }
            }
        });
        this.binding.referWhatsapp.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    String shareMessage = "Hi, friend!\n" + appname + " is my favorite gaming app \u2013 play and win real cash every day!\nDownload now and get \u20b910 instantly, plus 20% cashback on your first deposit.\nMy referral code: " + ReferActivity.this.referCode + "\nDownload and play now: " + ReferActivity.this.appurl;
                    Intent whatsappIntent = new Intent("android.intent.action.SEND");
                    whatsappIntent.setType("text/plain");
                    whatsappIntent.setPackage("com.whatsapp");
                    whatsappIntent.putExtra("android.intent.extra.TEXT", shareMessage);
                    if (whatsappIntent.resolveActivity(ReferActivity.this.getPackageManager()) != null) {
                        ReferActivity.this.startActivity(whatsappIntent);
                    } else {
                        Toast.makeText((Context)ReferActivity.this, (CharSequence)"WhatsApp is not installed.", (int)0).show();
                    }
                }
                catch (Exception e) {
                    Toast.makeText((Context)ReferActivity.this, (CharSequence)"Error sharing via WhatsApp", (int)0).show();
                }
            }
        });
    }

    private void loadData() {
        MyApi myApi = (MyApi)APIClient.getApiClient((Context)this).create(MyApi.class);
        Call<ArrayList<AppModel>> call = myApi.fetchAppSetting();
        call.enqueue((Callback)new Callback<ArrayList<AppModel>>(){

            public void onResponse(Call<ArrayList<AppModel>> call, Response<ArrayList<AppModel>> response) {
                ReferActivity.this.dialog.dismiss();
                if (response.isSuccessful() && response.body() != null && !((ArrayList)response.body()).isEmpty()) {
                    AppModel model = (AppModel)((ArrayList)response.body()).get(0);
                    ReferActivity.this.appurl = model.getWebsiteUrl();
                } else {
                    Toast.makeText((Context)ReferActivity.this, (CharSequence)"No data found", (int)0).show();
                }
            }

            public void onFailure(Call<ArrayList<AppModel>> call, Throwable throwable) {
                ReferActivity.this.dialog.dismiss();
                Toast.makeText((Context)ReferActivity.this, (CharSequence)"Something went wrong", (int)0).show();
            }
        });
    }
}

