/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Activities;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Activities.ChangePasswordActivity;
import app.firezone.synk.network.databinding.ActivityProfileBinding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.User;
import app.firezone.synk.network.model.UserResponse;
import com.squareup.picasso.Picasso;
import java.util.HashMap;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class ProfileActivity
extends AppCompatActivity {
    ActivityProfileBinding binding;
    Uri imageUri;
    long userId;
    String password;
    ProgressDialog dialog;
    private MyApi myApi;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityProfileBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.binding.backArrow.setOnClickListener(v -> this.finish());
        this.userId = SharedPrefManager.getInstance((Context)this).getUserId();
        this.myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        this.dialog = new ProgressDialog((Context)this);
        this.dialog.setTitle((CharSequence)"Profile Uploading");
        this.dialog.setMessage((CharSequence)"We're uploading your profile");
        this.binding.backArrow.setOnClickListener(v -> this.finish());
        this.loadData();
        this.binding.fetchImage.setOnClickListener(view -> {
            Intent intent = new Intent();
            intent.setAction("android.intent.action.GET_CONTENT");
            intent.setType("image/*");
            this.startActivityForResult(intent, 5);
        });
        this.binding.passUpdate.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent((Context)ProfileActivity.this, ChangePasswordActivity.class);
                intent.putExtra("userId", ProfileActivity.this.userId);
                intent.putExtra("password", ProfileActivity.this.password);
                ProfileActivity.this.startActivity(intent);
            }
        });
        this.binding.updateBtn.setOnClickListener(view -> {
            String name = this.binding.name.getText().toString();
            String phone = this.binding.phone.getText().toString();
            String username = this.binding.username.getText().toString();
            if (name.isEmpty() || phone.isEmpty() || username.isEmpty()) {
                Toast.makeText((Context)this, (CharSequence)"Something Went Wrong..", (int)0).show();
            } else {
                this.updateData(name, phone, username);
            }
        });
    }

    private void loadData() {
        Call<ApiResponse> call = this.myApi.fetchProfileData(this.userId);
        call.enqueue((Callback)new Callback<ApiResponse>(){

            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    User model = ((ApiResponse)response.body()).getUser();
                    ProfileActivity.this.binding.balance.setText((CharSequence)String.valueOf(model.getDepoBalance() + model.getBonusBalance() + model.getWinBalance()));
                    ProfileActivity.this.binding.debopiste.setText((CharSequence)String.valueOf(model.getMatchPlayed()));
                    ProfileActivity.this.binding.name.setText((CharSequence)model.getName());
                    ProfileActivity.this.binding.userNameTxt.setText((CharSequence)model.getName());
                    ProfileActivity.this.binding.email.setText((CharSequence)model.getEmail());
                    ProfileActivity.this.binding.phone.setText((CharSequence)model.getPhoneno());
                    ProfileActivity.this.binding.username.setText((CharSequence)model.getUsername());
                    ProfileActivity.this.binding.pass.setText((CharSequence)"Your Pass: ********* ");
                    ProfileActivity.this.password = model.getPassword();
                    Picasso.get().load(model.getProfile()).placeholder(2131231037).into((ImageView)ProfileActivity.this.binding.userProfile);
                }
            }

            public void onFailure(Call<ApiResponse> call, Throwable throwable) {
            }
        });
    }

    private void updateData(String name, String phone, String username) {
        long userId = SharedPrefManager.getInstance((Context)this).getUserId();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", name);
        map.put("username", username);
        map.put("phoneno", phone);
        Call<UserResponse> call = this.myApi.updateUser(userId, map);
        call.enqueue((Callback)new Callback<UserResponse>(){

            public void onResponse(Call<UserResponse> call, Response<UserResponse> response) {
                if (response.isSuccessful()) {
                    Toast.makeText((Context)ProfileActivity.this, (CharSequence)"Profile Updated Successfully", (int)0).show();
                } else {
                    Toast.makeText((Context)ProfileActivity.this, (CharSequence)"Update Failed", (int)0).show();
                }
            }

            public void onFailure(Call<UserResponse> call, Throwable t) {
                Toast.makeText((Context)ProfileActivity.this, (CharSequence)("Error: " + t.getMessage()), (int)0).show();
            }
        });
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 5 && data != null) {
            this.imageUri = data.getData();
            this.binding.userProfile.setImageURI(this.imageUri);
            this.dialog.show();
            Toast.makeText((Context)this, (CharSequence)"Image selected for upload.", (int)0).show();
            this.dialog.dismiss();
        }
    }
}

