/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Activities;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.Activities.ForgetPassChangeActivity;
import app.firezone.synk.network.Activities.LoginActivity;
import app.firezone.synk.network.databinding.ActivityPassForgetBinding;
import app.firezone.synk.network.model.CheckEmailResponse;
import app.firezone.synk.network.model.ForgetPasswordRequest;
import app.firezone.synk.network.model.ForgetPasswordResponse;
import app.firezone.synk.network.model.OtpVerifyRequest;
import app.firezone.synk.network.model.OtpVerifyResponse;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class PassForgetActivity
extends AppCompatActivity {
    ActivityPassForgetBinding binding;
    private MyApi myApi;
    Dialog dialog;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityPassForgetBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.binding.backArrow.setOnClickListener(v -> this.finish());
        this.dialog = new Dialog((Context)this);
        this.dialog.setContentView(2131558570);
        if (this.dialog.getWindow() != null) {
            this.dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.dialog.setCancelable(false);
        }
        this.binding.btnResetPass.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PassForgetActivity.this.binding.cardView4.getVisibility() == 0) {
                    String otp = PassForgetActivity.this.binding.otpEditBox.getText().toString().trim();
                    String email = PassForgetActivity.this.binding.resetEmail.getText().toString().trim();
                    if (!TextUtils.isEmpty((CharSequence)otp)) {
                        PassForgetActivity.this.verifyOtp(email, otp);
                        PassForgetActivity.this.dialog.show();
                    } else {
                        PassForgetActivity.this.binding.otpEditBox.setError((CharSequence)"Enter Otp");
                    }
                } else {
                    String email = PassForgetActivity.this.binding.resetEmail.getText().toString().trim();
                    if (!TextUtils.isEmpty((CharSequence)email)) {
                        PassForgetActivity.this.checkEmailExistandLoginVia(email);
                        PassForgetActivity.this.dialog.show();
                    } else {
                        PassForgetActivity.this.binding.resetEmail.setError((CharSequence)"Enter Valid Email");
                    }
                }
            }
        });
        this.binding.rememberPass.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PassForgetActivity.this.startActivity(new Intent((Context)PassForgetActivity.this, LoginActivity.class));
            }
        });
    }

    private void checkEmailExistandLoginVia(final String email) {
        this.myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        Call<CheckEmailResponse> call = this.myApi.checkEmailExists(email);
        call.enqueue((Callback)new Callback<CheckEmailResponse>(){

            public void onResponse(Call<CheckEmailResponse> call, Response<CheckEmailResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    if (((CheckEmailResponse)response.body()).isSuccess()) {
                        int loginVia = ((CheckEmailResponse)response.body()).getLoginVia();
                        if (loginVia == 0) {
                            PassForgetActivity.this.forgetPassword(email);
                        } else if (loginVia == 1) {
                            PassForgetActivity.this.dialog.dismiss();
                            Toast.makeText((Context)PassForgetActivity.this, (CharSequence)"This account was created using Google Sign-In.", (int)0).show();
                        }
                    } else {
                        Toast.makeText((Context)PassForgetActivity.this, (CharSequence)((CheckEmailResponse)response.body()).getMessage(), (int)0).show();
                    }
                }
            }

            public void onFailure(Call<CheckEmailResponse> call, Throwable throwable) {
                Toast.makeText((Context)PassForgetActivity.this, (CharSequence)("Error: " + throwable.getMessage()), (int)0).show();
            }
        });
    }

    private void forgetPassword(String email) {
        this.myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        ForgetPasswordRequest request = new ForgetPasswordRequest(email);
        this.myApi.forgetPassword(request).enqueue((Callback)new Callback<ForgetPasswordResponse>(){

            public void onResponse(Call<ForgetPasswordResponse> call, Response<ForgetPasswordResponse> response) {
                PassForgetActivity.this.dialog.dismiss();
                if (response.isSuccessful() && response.body() != null) {
                    ForgetPasswordResponse res = (ForgetPasswordResponse)response.body();
                    if (res.isSuccess()) {
                        PassForgetActivity.this.binding.cardView4.setVisibility(0);
                        PassForgetActivity.this.binding.btnResetPass.setText((CharSequence)"Verify OTP");
                        Toast.makeText((Context)PassForgetActivity.this, (CharSequence)"OTP sent to your email. \n( Please also Spam folder )", (int)0).show();
                    } else {
                        Toast.makeText((Context)PassForgetActivity.this, (CharSequence)res.getMessage(), (int)0).show();
                    }
                } else {
                    try {
                        String errorBody = response.errorBody() != null ? response.errorBody().string() : "Unknown error";
                        Log.e((String)"API_ERROR", (String)errorBody);
                        Toast.makeText((Context)PassForgetActivity.this, (CharSequence)("Error: " + errorBody), (int)0).show();
                    }
                    catch (Exception e) {
                        Toast.makeText((Context)PassForgetActivity.this, (CharSequence)"Failed to read error response", (int)0).show();
                        Log.e((String)"API_ERROR", (String)("Exception: " + e.getMessage()));
                    }
                }
            }

            public void onFailure(Call<ForgetPasswordResponse> call, Throwable t) {
                PassForgetActivity.this.dialog.dismiss();
                Toast.makeText((Context)PassForgetActivity.this, (CharSequence)("Failed: " + t.getMessage()), (int)0).show();
                Log.e((String)"API_FAILURE", (String)t.getMessage(), (Throwable)t);
            }
        });
    }

    private void verifyOtp(String email, String otp) {
        MyApi myApi = (MyApi)APIClient.getApiClient((Context)this).create(MyApi.class);
        OtpVerifyRequest request = new OtpVerifyRequest(email, otp);
        myApi.verifyOtp(request).enqueue((Callback)new Callback<OtpVerifyResponse>(){

            public void onResponse(Call<OtpVerifyResponse> call, Response<OtpVerifyResponse> response) {
                PassForgetActivity.this.dialog.dismiss();
                if (response.isSuccessful() && response.body() != null) {
                    OtpVerifyResponse res = (OtpVerifyResponse)response.body();
                    if (res.isSuccess()) {
                        long userId = res.getUserId();
                        Toast.makeText((Context)PassForgetActivity.this, (CharSequence)"OTP Verified Successfully", (int)0).show();
                        Intent intent = new Intent((Context)PassForgetActivity.this, ForgetPassChangeActivity.class);
                        intent.putExtra("userId", userId);
                        PassForgetActivity.this.startActivity(intent);
                        PassForgetActivity.this.finish();
                    } else {
                        PassForgetActivity.this.dialog.dismiss();
                        Toast.makeText((Context)PassForgetActivity.this, (CharSequence)res.getMessage(), (int)0).show();
                    }
                } else {
                    PassForgetActivity.this.dialog.dismiss();
                    Toast.makeText((Context)PassForgetActivity.this, (CharSequence)"Verification failed. Try again.", (int)0).show();
                }
            }

            public void onFailure(Call<OtpVerifyResponse> call, Throwable t) {
                PassForgetActivity.this.dialog.dismiss();
                Toast.makeText((Context)PassForgetActivity.this, (CharSequence)("Network error: " + t.getMessage()), (int)0).show();
            }
        });
    }
}

