/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Activities;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.Adapter.NotificationAdapter;
import app.firezone.synk.network.databinding.ActivityNotificationBinding;
import app.firezone.synk.network.model.NotificationModel;
import com.google.firebase.database.FirebaseDatabase;
import java.util.ArrayList;
import java.util.Collection;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class NotificationActivity
extends AppCompatActivity {
    ActivityNotificationBinding binding;
    ArrayList<NotificationModel> mlist = new ArrayList();
    NotificationAdapter adapter;
    FirebaseDatabase database;
    Dialog dialog;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityNotificationBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.binding.backArrow.setOnClickListener(v -> this.finish());
        this.database = FirebaseDatabase.getInstance();
        LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this);
        this.binding.notifyRecyer.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        layoutManager.setReverseLayout(true);
        layoutManager.setStackFromEnd(true);
        this.dialog = new Dialog((Context)this);
        this.dialog.setContentView(2131558570);
        if (this.dialog.getWindow() != null) {
            this.dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.dialog.setCancelable(true);
        }
        this.dialog.show();
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        Call<ArrayList<NotificationModel>> call = myApi.fetchNotification();
        call.enqueue((Callback)new Callback<ArrayList<NotificationModel>>(){

            public void onResponse(Call<ArrayList<NotificationModel>> call, Response<ArrayList<NotificationModel>> response) {
                if (response.isSuccessful() && response.body() != null) {
                    NotificationActivity.this.dialog.dismiss();
                    NotificationActivity.this.mlist.clear();
                    NotificationActivity.this.mlist.addAll((Collection)response.body());
                    NotificationActivity.this.adapter = new NotificationAdapter((Context)NotificationActivity.this, NotificationActivity.this.mlist);
                    NotificationActivity.this.binding.notifyRecyer.setAdapter((RecyclerView.Adapter)NotificationActivity.this.adapter);
                    NotificationActivity.this.adapter.notifyDataSetChanged();
                } else {
                    Toast.makeText((Context)NotificationActivity.this, (CharSequence)"Failed to fetch notifications", (int)0).show();
                }
            }

            public void onFailure(Call<ArrayList<NotificationModel>> call, Throwable throwable) {
                NotificationActivity.this.dialog.dismiss();
                Toast.makeText((Context)NotificationActivity.this, (CharSequence)("Error: " + throwable.getMessage()), (int)0).show();
            }
        });
    }
}

