/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Activities;

import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Adapter.LotteryUsersAdapter;
import app.firezone.synk.network.Adapter.RulesAdapter;
import app.firezone.synk.network.databinding.ActivityLotteryInfoBinding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.CheckJoinedResponse;
import app.firezone.synk.network.model.JoinedMatchResponse;
import app.firezone.synk.network.model.LotteryJoinedModel;
import app.firezone.synk.network.model.LotteryJoinedResponse;
import app.firezone.synk.network.model.MatchRulesResponse;
import app.firezone.synk.network.model.RulesModel;
import app.firezone.synk.network.model.TransactionModel;
import app.firezone.synk.network.model.User;
import app.firezone.synk.network.model.UserResponse;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class LotteryInfoActivity
extends AppCompatActivity {
    ActivityLotteryInfoBinding binding;
    LotteryUsersAdapter mAdapter;
    ArrayList<LotteryJoinedModel> mlist;
    ArrayList<RulesModel> rulesModels;
    RulesAdapter adapter;
    ProgressDialog progressDialog;
    Dialog dialog;
    String lotteryId;
    String Prize;
    String entryFees;
    String totalPlayers;
    String email;
    String name;
    String phone;
    long winBalance;
    long depoBalance;
    long bonusBalance;
    long totalCoin;
    long entryFee;
    long matchPlayed;
    long totalPlayer;
    long player;
    FirebaseDatabase database;
    private MyApi myApi;
    long userId;
    FirebaseUser auth;
    DatabaseReference dr;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityLotteryInfoBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        this.binding.backArrow.setOnClickListener(v -> this.finish());
        this.userId = SharedPrefManager.getInstance((Context)this).getUserId();
        this.progressDialog = new ProgressDialog((Context)this);
        this.progressDialog.setTitle((CharSequence)"Registering Lottery");
        this.progressDialog.setMessage((CharSequence)"Please Wait.....");
        this.progressDialog.setCancelable(false);
        this.auth = FirebaseAuth.getInstance().getCurrentUser();
        this.myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        this.database = FirebaseDatabase.getInstance();
        this.lotteryId = this.getIntent().getStringExtra("lotteryId");
        this.entryFees = this.getIntent().getStringExtra("entryFee");
        this.totalPlayers = this.getIntent().getStringExtra("totalSeat");
        this.Prize = this.getIntent().getStringExtra("Prize");
        if (this.entryFees == null) {
            this.entryFees = "0";
        }
        if (this.totalPlayers == null) {
            this.totalPlayers = "0";
        }
        if (this.Prize == null) {
            this.Prize = "0";
        }
        this.entryFee = Long.parseLong(this.entryFees);
        this.totalPlayer = Long.parseLong(this.totalPlayers);
        this.binding.perkill.setText((CharSequence)("\u20b9" + this.entryFees));
        this.binding.prizepool.setText((CharSequence)("\u20b9" + this.Prize));
        Call<ApiResponse> call = this.myApi.fetchProfileData(this.userId);
        call.enqueue((Callback)new Callback<ApiResponse>(){

            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    User model = ((ApiResponse)response.body()).getUser();
                    LotteryInfoActivity.this.winBalance = model.getWinBalance();
                    LotteryInfoActivity.this.depoBalance = model.getDepoBalance();
                    LotteryInfoActivity.this.bonusBalance = model.getBonusBalance();
                    LotteryInfoActivity.this.totalCoin = model.getDepoBalance() + model.getWinBalance();
                    LotteryInfoActivity.this.email = model.getEmail();
                    LotteryInfoActivity.this.name = model.getName();
                    LotteryInfoActivity.this.phone = model.getPhoneno();
                } else {
                    Toast.makeText((Context)LotteryInfoActivity.this, (CharSequence)"Failed to fetch user data", (int)0).show();
                }
            }

            public void onFailure(Call<ApiResponse> call, Throwable throwable) {
            }
        });
        this.binding.joinedRecy.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.mlist = new ArrayList();
        Call<LotteryJoinedResponse> joinedCall = this.myApi.fetchLotteryJoined(Long.parseLong(this.lotteryId));
        joinedCall.enqueue((Callback)new Callback<LotteryJoinedResponse>(){

            public void onResponse(Call<LotteryJoinedResponse> call, Response<LotteryJoinedResponse> response) {
                if (response.isSuccessful() && response.body() != null && ((LotteryJoinedResponse)response.body()).isSuccess()) {
                    LotteryInfoActivity.this.mlist.clear();
                    ArrayList<LotteryJoinedModel> joinedUsers = ((LotteryJoinedResponse)response.body()).getData();
                    if (joinedUsers != null && !joinedUsers.isEmpty()) {
                        for (LotteryJoinedModel user : joinedUsers) {
                            LotteryInfoActivity.this.mlist.add(user);
                        }
                        LotteryInfoActivity.this.mAdapter = new LotteryUsersAdapter(LotteryInfoActivity.this.mlist, (Context)LotteryInfoActivity.this);
                        LotteryInfoActivity.this.binding.joinedRecy.setAdapter((RecyclerView.Adapter)LotteryInfoActivity.this.mAdapter);
                    } else {
                        Toast.makeText((Context)LotteryInfoActivity.this, (CharSequence)"No joined users found", (int)0).show();
                    }
                } else {
                    Toast.makeText((Context)LotteryInfoActivity.this, (CharSequence)"Failed to fetch data", (int)0).show();
                }
            }

            public void onFailure(Call<LotteryJoinedResponse> call, Throwable t) {
                Toast.makeText((Context)LotteryInfoActivity.this, (CharSequence)("Error fetching joined users: " + t.getMessage()), (int)0).show();
            }
        });
        this.binding.rulesRecy.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.rulesModels = new ArrayList();
        Call<MatchRulesResponse> ruless = this.myApi.fetchMatchRules("Lottery");
        ruless.enqueue((Callback)new Callback<MatchRulesResponse>(){

            public void onResponse(Call<MatchRulesResponse> call, Response<MatchRulesResponse> response) {
                if (response.isSuccessful() && response.body() != null && ((MatchRulesResponse)response.body()).isSuccess()) {
                    LotteryInfoActivity.this.rulesModels.clear();
                    LotteryInfoActivity.this.rulesModels.addAll(((MatchRulesResponse)response.body()).getMatchRules());
                    LotteryInfoActivity.this.adapter = new RulesAdapter(LotteryInfoActivity.this.rulesModels, (Context)LotteryInfoActivity.this);
                    LotteryInfoActivity.this.binding.rulesRecy.setAdapter((RecyclerView.Adapter)LotteryInfoActivity.this.adapter);
                } else {
                    Toast.makeText((Context)LotteryInfoActivity.this, (CharSequence)("No Rules Found: " + (response.body() != null ? ((MatchRulesResponse)response.body()).getMessage() : "Unknown Error")), (int)0).show();
                }
            }

            public void onFailure(Call<MatchRulesResponse> call, Throwable t) {
                Toast.makeText((Context)LotteryInfoActivity.this, (CharSequence)("Failed to load rules: " + t.getMessage()), (int)0).show();
            }
        });
        this.binding.subssribeBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LotteryInfoActivity.this.deductCoin();
            }
        });
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("userId", this.userId);
        body.put("lotteryid", this.lotteryId);
        Call<CheckJoinedResponse> calls = this.myApi.checkIfUserJoined(body);
        calls.enqueue((Callback)new Callback<CheckJoinedResponse>(){

            public void onResponse(Call<CheckJoinedResponse> call, Response<CheckJoinedResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    if (((CheckJoinedResponse)response.body()).isSuccess()) {
                        LotteryInfoActivity.this.binding.joinText.setText((CharSequence)"Registered");
                        LotteryInfoActivity.this.binding.subssribeBtn.setClickable(false);
                        LotteryInfoActivity.this.binding.subssribeBtn.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View view) {
                                Toast.makeText((Context)LotteryInfoActivity.this, (CharSequence)"Already Registered", (int)0).show();
                            }
                        });
                    } else {
                        LotteryInfoActivity.this.binding.joinText.setText((CharSequence)"Register Now");
                    }
                }
            }

            public void onFailure(Call<CheckJoinedResponse> call, Throwable t) {
                Toast.makeText((Context)LotteryInfoActivity.this, (CharSequence)("Error checking lottery status: " + t.getMessage()), (int)0).show();
            }
        });
    }

    private void deductCoin() {
        if (this.entryFee == 0L) {
            this.saveLotteryJoinData();
        } else if (this.entryFee <= this.depoBalance) {
            long depoBal = this.depoBalance - this.entryFee;
            HashMap<String, Object> coinMap = new HashMap<String, Object>();
            coinMap.put("depoBalance", depoBal);
            Call<UserResponse> updateCall = this.myApi.updateUser(this.userId, coinMap);
            updateCall.enqueue((Callback)new Callback<UserResponse>(){

                public void onResponse(Call<UserResponse> call, Response<UserResponse> response) {
                    if (response.isSuccessful() && response.body() != null) {
                        LotteryInfoActivity.this.saveLotteryJoinData();
                        LotteryInfoActivity.this.saveUsersTransactionDetails();
                        Toast.makeText((Context)LotteryInfoActivity.this, (CharSequence)"Coin Debited...", (int)0).show();
                    } else {
                        Log.e((String)"DeductCoinError", (String)("Failed to deduct coins. Response: " + response.message()));
                        Toast.makeText((Context)LotteryInfoActivity.this, (CharSequence)"Failed to deduct coins. Please try again.", (int)0).show();
                    }
                }

                public void onFailure(Call<UserResponse> call, Throwable t) {
                    Log.e((String)"DeductCoinError", (String)("API call failed: " + t.getMessage()));
                    Toast.makeText((Context)LotteryInfoActivity.this, (CharSequence)("Error: " + t.getMessage()), (int)0).show();
                }
            });
        } else if (this.entryFee <= this.totalCoin) {
            long requiredCoin = this.entryFee - this.depoBalance;
            long winCoin = this.winBalance - requiredCoin;
            long totaldepo = this.depoBalance - this.depoBalance;
            HashMap<String, Object> coinMap = new HashMap<String, Object>();
            coinMap.put("depoBalance", totaldepo);
            coinMap.put("winBalance", winCoin);
            Call<UserResponse> updateCall = this.myApi.updateUser(this.userId, coinMap);
            updateCall.enqueue((Callback)new Callback<UserResponse>(){

                public void onResponse(Call<UserResponse> call, Response<UserResponse> response) {
                    if (response.isSuccessful() && response.body() != null) {
                        LotteryInfoActivity.this.saveLotteryJoinData();
                        LotteryInfoActivity.this.saveUsersTransactionDetails();
                        Toast.makeText((Context)LotteryInfoActivity.this, (CharSequence)"Coin Debited...", (int)0).show();
                    } else {
                        Log.e((String)"DeductCoinError", (String)("Failed to deduct coins. Response: " + response.message()));
                        Toast.makeText((Context)LotteryInfoActivity.this, (CharSequence)"Failed to deduct coins. Please try again.", (int)0).show();
                    }
                }

                public void onFailure(Call<UserResponse> call, Throwable t) {
                    Log.e((String)"DeductCoinError", (String)("API call failed: " + t.getMessage()));
                    Toast.makeText((Context)LotteryInfoActivity.this, (CharSequence)("Error: " + t.getMessage()), (int)0).show();
                }
            });
        } else {
            this.showNoBalanceDailog();
            this.progressDialog.dismiss();
            Toast.makeText((Context)this, (CharSequence)"Not Enough Money", (int)0).show();
        }
    }

    private void saveLotteryJoinData() {
        if (this.phone == null || this.email == null || this.name == null || this.lotteryId == null || this.entryFees == null || this.Prize == null) {
            Toast.makeText((Context)this, (CharSequence)"Missing data. Please check your details.", (int)0).show();
            return;
        }
        Calendar calForDate = Calendar.getInstance();
        SimpleDateFormat currentDate = new SimpleDateFormat("dd-MM-yy", Locale.getDefault());
        String date = currentDate.format(calForDate.getTime());
        String currentTime = new SimpleDateFormat("HH:mm:ss", Locale.getDefault()).format(new Date());
        String totalPay = String.valueOf(this.entryFee);
        this.progressDialog.show();
        this.myApi.storeLotteryUser(Long.parseLong(this.lotteryId), this.email, this.name, this.phone, String.valueOf(this.userId), date, currentTime, totalPay, "0", "Expert").enqueue((Callback)new Callback<JoinedMatchResponse>(){

            public void onResponse(Call<JoinedMatchResponse> call, Response<JoinedMatchResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    LotteryInfoActivity.this.progressDialog.dismiss();
                    LotteryInfoActivity.this.binding.joinText.setText((CharSequence)"Registered");
                    LotteryInfoActivity.this.binding.subssribeBtn.setBackgroundColor(2131230896);
                    LotteryInfoActivity.this.binding.subssribeBtn.setClickable(false);
                    Toast.makeText((Context)LotteryInfoActivity.this, (CharSequence)"Joined Successfully...", (int)0).show();
                } else {
                    try {
                        String errorMessage = response.errorBody().string();
                        Toast.makeText((Context)LotteryInfoActivity.this, (CharSequence)("Failed to join: " + errorMessage), (int)1).show();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }

            public void onFailure(Call<JoinedMatchResponse> call, Throwable t) {
                Toast.makeText((Context)LotteryInfoActivity.this, (CharSequence)("Error: " + t.getMessage()), (int)0).show();
            }
        });
    }

    private void saveUsersTransactionDetails() {
        long userIdLong = SharedPrefManager.getInstance((Context)this).getUserId();
        String userId = String.valueOf(userIdLong);
        String date = new SimpleDateFormat("dd-MM-yy", Locale.getDefault()).format(Calendar.getInstance().getTime());
        String time = new SimpleDateFormat("HH:mm:ss", Locale.getDefault()).format(Calendar.getInstance().getTime());
        String transactionId = "TRAN" + System.currentTimeMillis();
        String inputCoin = String.valueOf(this.entryFee);
        Call<TransactionModel> call = this.myApi.storeUserTransaction(userId, "Withdraw", this.email, inputCoin, date, time, transactionId, "Wallet", "Pending");
        call.enqueue((Callback)new Callback<TransactionModel>(){

            public void onResponse(Call<TransactionModel> call, Response<TransactionModel> response) {
                if (response.isSuccessful() && response.body() != null) {
                    Toast.makeText((Context)LotteryInfoActivity.this, (CharSequence)"Transaction Recorded Successfully", (int)0).show();
                } else {
                    Toast.makeText((Context)LotteryInfoActivity.this, (CharSequence)("Failed to Record Transaction: " + response.message()), (int)0).show();
                }
            }

            public void onFailure(Call<TransactionModel> call, Throwable throwable) {
                Toast.makeText((Context)LotteryInfoActivity.this, (CharSequence)("Error: " + throwable.getMessage()), (int)0).show();
            }
        });
    }

    private void showNoBalanceDailog() {
        ConstraintLayout constraintLayout = (ConstraintLayout)this.findViewById(2131362687);
        View view = LayoutInflater.from((Context)this).inflate(2131558653, (ViewGroup)constraintLayout);
        Button doneBtn = (Button)view.findViewById(2131361954);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setView(view);
        final AlertDialog alertDialog = builder.create();
        doneBtn.findViewById(2131361954).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                alertDialog.dismiss();
            }
        });
        if (alertDialog.getWindow() != null) {
            alertDialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable());
        }
        alertDialog.show();
    }
}

