/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Activities;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Activities.PassForgetActivity;
import app.firezone.synk.network.Activities.SignupActivity;
import app.firezone.synk.network.MainActivity;
import app.firezone.synk.network.databinding.ActivityLoginBinding;
import app.firezone.synk.network.model.AppModel;
import app.firezone.synk.network.model.CheckEmailResponse;
import app.firezone.synk.network.model.LoginResponse;
import com.google.android.gms.auth.api.signin.GoogleSignIn;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInClient;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.tasks.Task;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GoogleAuthProvider;
import java.util.ArrayList;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class LoginActivity
extends AppCompatActivity {
    ActivityLoginBinding binding;
    FirebaseAuth auth;
    FirebaseUser currentUser;
    GoogleSignInClient mGoogleSignInClient;
    ProgressDialog pd;
    MyApi myApi;
    int RC_SIGN_IN = 11;
    String client_id;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityLoginBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.auth = FirebaseAuth.getInstance();
        this.currentUser = this.auth.getCurrentUser();
        this.myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        this.pd = new ProgressDialog((Context)this);
        this.pd.setTitle((CharSequence)"Please Wait");
        this.pd.setMessage((CharSequence)"Logging you in...");
        this.myApi.fetchAppSetting().enqueue((Callback)new Callback<ArrayList<AppModel>>(){

            public void onResponse(Call<ArrayList<AppModel>> call, Response<ArrayList<AppModel>> response) {
                if (response.isSuccessful() && response.body() != null && !((ArrayList)response.body()).isEmpty()) {
                    LoginActivity.this.client_id = ((AppModel)((ArrayList)response.body()).get(0)).getGooglekey();
                }
            }

            public void onFailure(Call<ArrayList<AppModel>> call, Throwable t) {
                Toast.makeText((Context)LoginActivity.this, (CharSequence)"Failed to fetch app settings", (int)0).show();
            }
        });
        if (SharedPrefManager.getInstance((Context)this).getUserId() != -1L) {
            this.navigateToMainActivity();
            return;
        }
        GoogleSignInOptions gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN).requestIdToken(this.getString(2131951677)).requestEmail().build();
        this.mGoogleSignInClient = GoogleSignIn.getClient((Activity)this, (GoogleSignInOptions)gso);
        this.binding.btnSignIn.setOnClickListener(v -> {
            String email = this.binding.userEmail.getText().toString().trim();
            String password = this.binding.password.getText().toString();
            if (TextUtils.isEmpty((CharSequence)email)) {
                this.binding.userEmail.setError((CharSequence)"Email is required");
                return;
            }
            if (TextUtils.isEmpty((CharSequence)password)) {
                this.binding.password.setError((CharSequence)"Password is required");
                return;
            }
            this.pd.show();
            this.checkEmailExistandLoginVia(email, password);
        });
        this.binding.googleBtn.setOnClickListener(v -> this.initiateGoogleLogin());
        this.binding.noAccount.setOnClickListener(v -> this.startActivity(new Intent((Context)this, SignupActivity.class)));
        this.binding.forgetPassword.setOnClickListener(v -> this.startActivity(new Intent((Context)this, PassForgetActivity.class)));
    }

    private void checkEmailExistandLoginVia(final String email, final String password) {
        this.myApi.checkEmailExists(email).enqueue((Callback)new Callback<CheckEmailResponse>(){

            public void onResponse(Call<CheckEmailResponse> call, Response<CheckEmailResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    if (((CheckEmailResponse)response.body()).isSuccess()) {
                        if (((CheckEmailResponse)response.body()).getLoginVia() == 0) {
                            LoginActivity.this.login(email, password);
                        } else {
                            LoginActivity.this.pd.dismiss();
                            Toast.makeText((Context)LoginActivity.this, (CharSequence)"Use Google Sign-In for this account", (int)0).show();
                        }
                    } else {
                        LoginActivity.this.pd.dismiss();
                        Toast.makeText((Context)LoginActivity.this, (CharSequence)((CheckEmailResponse)response.body()).getMessage(), (int)0).show();
                    }
                } else {
                    LoginActivity.this.pd.dismiss();
                    Toast.makeText((Context)LoginActivity.this, (CharSequence)"Authenticated....", (int)0).show();
                }
            }

            public void onFailure(Call<CheckEmailResponse> call, Throwable t) {
                LoginActivity.this.pd.dismiss();
                Toast.makeText((Context)LoginActivity.this, (CharSequence)("Error: " + t.getMessage()), (int)0).show();
            }
        });
    }

    private void login(String email, String password) {
        this.myApi.loginUser(email, password).enqueue((Callback)new Callback<LoginResponse>(){

            public void onResponse(Call<LoginResponse> call, Response<LoginResponse> response) {
                LoginActivity.this.pd.dismiss();
                if (response.isSuccessful() && response.body() != null) {
                    LoginResponse res = (LoginResponse)response.body();
                    SharedPrefManager.getInstance((Context)LoginActivity.this).saveUserId(res.getUserId());
                    SharedPrefManager.getInstance((Context)LoginActivity.this).saveAccessToken(res.getAccess_token());
                    Toast.makeText((Context)LoginActivity.this, (CharSequence)"Login Successful", (int)0).show();
                    LoginActivity.this.navigateToMainActivity();
                } else {
                    Toast.makeText((Context)LoginActivity.this, (CharSequence)"Invalid credentials", (int)0).show();
                }
            }

            public void onFailure(Call<LoginResponse> call, Throwable t) {
                LoginActivity.this.pd.dismiss();
                Toast.makeText((Context)LoginActivity.this, (CharSequence)("Login failed: " + t.getMessage()), (int)0).show();
            }
        });
    }

    private void initiateGoogleLogin() {
        this.startActivityForResult(this.mGoogleSignInClient.getSignInIntent(), this.RC_SIGN_IN);
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == this.RC_SIGN_IN) {
            Task task = GoogleSignIn.getSignedInAccountFromIntent((Intent)data);
            try {
                GoogleSignInAccount account = (GoogleSignInAccount)task.getResult(ApiException.class);
                if (account != null) {
                    this.checkGoogleExistLoginVia(account.getEmail(), account.getIdToken());
                }
            }
            catch (ApiException e) {
                Toast.makeText((Context)this, (CharSequence)"Google sign-in failed", (int)0).show();
            }
        }
    }

    private void checkGoogleExistLoginVia(final String email, final String idToken) {
        this.myApi.checkEmailExists(email).enqueue((Callback)new Callback<CheckEmailResponse>(){

            public void onResponse(Call<CheckEmailResponse> call, Response<CheckEmailResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    if (((CheckEmailResponse)response.body()).isSuccess()) {
                        if (((CheckEmailResponse)response.body()).getLoginVia() == 1) {
                            LoginActivity.this.authWithGoogle(idToken, email);
                        } else {
                            Toast.makeText((Context)LoginActivity.this, (CharSequence)"Use email & password for this account", (int)0).show();
                            LoginActivity.this.pd.dismiss();
                        }
                    } else {
                        Toast.makeText((Context)LoginActivity.this, (CharSequence)((CheckEmailResponse)response.body()).getMessage(), (int)0).show();
                        LoginActivity.this.pd.dismiss();
                    }
                }
            }

            public void onFailure(Call<CheckEmailResponse> call, Throwable t) {
                LoginActivity.this.pd.dismiss();
                Toast.makeText((Context)LoginActivity.this, (CharSequence)("Error: " + t.getMessage()), (int)0).show();
            }
        });
    }

    private void authWithGoogle(String idToken, String email) {
        AuthCredential credential = GoogleAuthProvider.getCredential((String)idToken, null);
        this.auth.signInWithCredential(credential).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                String password = this.auth.getUid();
                this.login(email, password);
            } else {
                Toast.makeText((Context)this, (CharSequence)"Google Auth failed", (int)0).show();
            }
        });
    }

    private void navigateToMainActivity() {
        Intent intent = new Intent((Context)this, MainActivity.class);
        intent.setFlags(0x14000000);
        this.startActivity(intent);
        this.finish();
    }
}

