/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Activities;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.databinding.ActivityHelpBinding;
import app.firezone.synk.network.model.AppModel;
import java.util.ArrayList;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class HelpActivity
extends AppCompatActivity {
    ActivityHelpBinding binding;
    String whatsapp;
    String instagram;
    String facebook;
    String telegram;
    String youtube;
    String discord;
    String email;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityHelpBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.binding.backArrow.setOnClickListener(v -> this.finish());
        this.binding.facebook.setEnabled(false);
        this.binding.facebook.setAlpha(0.5f);
        this.loadData();
        this.binding.discord.setOnClickListener(view -> {
            Intent browserIntent = new Intent("android.intent.action.VIEW");
            browserIntent.setData(Uri.parse((String)("https://wa.me/91" + this.whatsapp)));
            this.startActivity(browserIntent);
        });
        this.binding.cardView37.setOnClickListener(view -> {
            Intent browserIntent = new Intent("android.intent.action.VIEW");
            browserIntent.setData(Uri.parse((String)this.instagram));
            this.startActivity(browserIntent);
        });
        this.binding.cardView36.setOnClickListener(view -> {
            Intent browserIntent = new Intent("android.intent.action.VIEW");
            browserIntent.setData(Uri.parse((String)("https://wa.me/91" + this.whatsapp)));
            this.startActivity(browserIntent);
        });
        this.binding.cardView38.setOnClickListener(view -> {
            Intent browserIntent = new Intent("android.intent.action.VIEW");
            browserIntent.setData(Uri.parse((String)this.youtube));
            this.startActivity(browserIntent);
        });
        this.binding.telegram.setOnClickListener(view -> {
            Intent browserIntent = new Intent("android.intent.action.VIEW");
            browserIntent.setData(Uri.parse((String)this.telegram));
            this.startActivity(browserIntent);
        });
    }

    private void loadData() {
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        Call<ArrayList<AppModel>> call = myApi.fetchAppSetting();
        call.enqueue((Callback)new Callback<ArrayList<AppModel>>(){

            public void onResponse(Call<ArrayList<AppModel>> call, Response<ArrayList<AppModel>> response) {
                if (response.isSuccessful() && response.body() != null && !((ArrayList)response.body()).isEmpty()) {
                    AppModel model = (AppModel)((ArrayList)response.body()).get(0);
                    HelpActivity.this.whatsapp = model.getWhatsapp();
                    HelpActivity.this.facebook = model.getFacebook();
                    HelpActivity.this.telegram = model.getTelegram();
                    HelpActivity.this.youtube = model.getYoutube();
                    HelpActivity.this.instagram = model.getInstagram();
                    HelpActivity.this.email = model.getEmail();
                    HelpActivity.this.discord = model.getDiscord();
                    HelpActivity.this.binding.facebook.setEnabled(true);
                    HelpActivity.this.binding.facebook.setAlpha(1.0f);
                    HelpActivity.this.binding.facebook.setOnClickListener(view -> {
                        Intent intent = new Intent("android.intent.action.SENDTO");
                        intent.setData(Uri.parse((String)"mailto:"));
                        intent.putExtra("android.intent.extra.EMAIL", new String[]{HelpActivity.this.email});
                        intent.putExtra("android.intent.extra.SUBJECT", HelpActivity.this.getString(2131951718));
                        intent.putExtra("android.intent.extra.TEXT", HelpActivity.this.getString(2131951717));
                        try {
                            HelpActivity.this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"Send mail"));
                        }
                        catch (ActivityNotFoundException ex) {
                            Toast.makeText((Context)HelpActivity.this, (CharSequence)"No Mail App found", (int)0).show();
                        }
                        catch (Exception ex) {
                            Toast.makeText((Context)HelpActivity.this, (CharSequence)"Unexpected Error", (int)0).show();
                        }
                    });
                } else {
                    Toast.makeText((Context)HelpActivity.this, (CharSequence)"No data found", (int)0).show();
                }
            }

            public void onFailure(Call<ArrayList<AppModel>> call, Throwable throwable) {
                Toast.makeText((Context)HelpActivity.this, (CharSequence)("Error: " + throwable.getMessage()), (int)0).show();
            }
        });
    }
}

