/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Activities;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.Activities.LoginActivity;
import app.firezone.synk.network.databinding.ActivityForgetPassChangeBinding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.ChangePasswordRequest;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class ForgetPassChangeActivity
extends AppCompatActivity {
    ActivityForgetPassChangeBinding binding;
    private MyApi myApi;
    String password;
    long userId;
    ProgressDialog progressDialog;
    private static final String TAG = "ForgetPassChangeActivity";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityForgetPassChangeBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.binding.backArrow.setOnClickListener(v -> this.finish());
        this.progressDialog = new ProgressDialog((Context)this);
        this.progressDialog.setTitle((CharSequence)"Updating Password");
        this.progressDialog.setMessage((CharSequence)"Please wait.....");
        this.password = this.getIntent().getStringExtra("password");
        this.userId = this.getIntent().getLongExtra("userId", 0L);
        this.setupPassField((EditText)this.binding.pass1);
        this.setupPassField((EditText)this.binding.pass2);
        this.binding.btnChangePass.setOnClickListener(v -> {
            String pass1 = this.binding.pass1.getText().toString().trim();
            String pass2 = this.binding.pass2.getText().toString().trim();
            if (pass1.isEmpty() || pass2.isEmpty()) {
                Toast.makeText((Context)this, (CharSequence)"All fields are required", (int)0).show();
                return;
            }
            if (!pass1.equals(pass2)) {
                this.binding.pass1.setError((CharSequence)"Passwords do not match");
                this.binding.pass2.setError((CharSequence)"Passwords do not match");
                Toast.makeText((Context)this, (CharSequence)"Password and Confirm Password do not match.", (int)0).show();
                return;
            }
            this.changesPassword(pass1);
        });
    }

    private void setupPassField(final EditText editText) {
        editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                String input = s.toString().replace(" ", "");
                if (!input.equals(s.toString())) {
                    editText.setText((CharSequence)input);
                    editText.setSelection(input.length());
                }
            }

            public void afterTextChanged(Editable s) {
            }
        });
        editText.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                return event.getAction() == 0 && keyCode == 66;
            }
        });
    }

    private void changesPassword(String newPass) {
        this.myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        ChangePasswordRequest request = new ChangePasswordRequest(this.userId, newPass);
        Call<ApiResponse> call = this.myApi.changeForgetPassword(request);
        this.progressDialog.show();
        call.enqueue((Callback)new Callback<ApiResponse>(){

            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                ForgetPassChangeActivity.this.progressDialog.dismiss();
                if (response.isSuccessful() && response.body() != null) {
                    if (((ApiResponse)response.body()).getStatus() == 200 || ((ApiResponse)response.body()).isSuccess()) {
                        Toast.makeText((Context)ForgetPassChangeActivity.this, (CharSequence)"Password updated successfully!", (int)0).show();
                        ForgetPassChangeActivity.this.startActivity(new Intent((Context)ForgetPassChangeActivity.this, LoginActivity.class));
                        ForgetPassChangeActivity.this.finish();
                    } else {
                        Toast.makeText((Context)ForgetPassChangeActivity.this, (CharSequence)((ApiResponse)response.body()).getMessage(), (int)0).show();
                    }
                } else {
                    Toast.makeText((Context)ForgetPassChangeActivity.this, (CharSequence)"Something went wrong", (int)0).show();
                }
            }

            public void onFailure(Call<ApiResponse> call, Throwable t) {
                ForgetPassChangeActivity.this.progressDialog.dismiss();
                Toast.makeText((Context)ForgetPassChangeActivity.this, (CharSequence)("Request failed: " + t.getMessage()), (int)0).show();
            }
        });
    }
}

