/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Activities;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.Adapter.BgmiWinnerAdapter;
import app.firezone.synk.network.Adapter.TopWinnerAdapter;
import app.firezone.synk.network.databinding.ActivityClaasicWinnerBinding;
import app.firezone.synk.network.model.Winner_Model;
import com.google.firebase.database.FirebaseDatabase;
import com.squareup.picasso.Picasso;
import java.util.ArrayList;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class ClaasicWinnerActivity
extends AppCompatActivity {
    ActivityClaasicWinnerBinding binding;
    BgmiWinnerAdapter winnerAdapter;
    TopWinnerAdapter myAdapter;
    ArrayList<Winner_Model> topWinnerModels = new ArrayList();
    FirebaseDatabase database;
    String gameName;
    String matchId;
    Dialog dialog;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityClaasicWinnerBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.binding.backArrow.setOnClickListener(v -> this.finish());
        this.database = FirebaseDatabase.getInstance();
        this.topWinnerModels = new ArrayList();
        this.matchId = this.getIntent().getStringExtra("matchid");
        this.gameName = this.getIntent().getStringExtra("gamename");
        String date = this.getIntent().getStringExtra("date");
        String time = this.getIntent().getStringExtra("time");
        String matchno = this.getIntent().getStringExtra("matchno");
        String images = this.getIntent().getStringExtra("images");
        Picasso.get().load(images).placeholder(2131231037).into(this.binding.imageView5);
        this.binding.dateTxt.setText((CharSequence)date);
        this.binding.timeTxt.setText((CharSequence)time);
        this.binding.gameName.setText((CharSequence)(this.gameName + " " + matchno));
        this.dialog = new Dialog((Context)this);
        this.dialog.setContentView(2131558570);
        if (this.dialog.getWindow() != null) {
            this.dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.dialog.setCancelable(true);
        }
        this.dialog.show();
        LinearLayoutManager layoutManager2 = new LinearLayoutManager((Context)this);
        this.binding.topWinersRecy.setLayoutManager((RecyclerView.LayoutManager)layoutManager2);
        this.myAdapter = new TopWinnerAdapter(this.topWinnerModels, (Context)this);
        this.binding.topWinersRecy.setAdapter((RecyclerView.Adapter)this.myAdapter);
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        myApi.fetchResultMatchUserData(Long.parseLong(this.matchId)).enqueue((Callback)new Callback<ArrayList<Winner_Model>>(){

            public void onResponse(Call<ArrayList<Winner_Model>> call, Response<ArrayList<Winner_Model>> response) {
                ClaasicWinnerActivity.this.dialog.dismiss();
                if (response.isSuccessful() && response.body() != null) {
                    ClaasicWinnerActivity.this.topWinnerModels.clear();
                    for (Winner_Model winner : (ArrayList)response.body()) {
                        if (!"Winner".equalsIgnoreCase(winner.getPlayerStatus())) continue;
                        ClaasicWinnerActivity.this.topWinnerModels.add(winner);
                    }
                    if (ClaasicWinnerActivity.this.topWinnerModels.isEmpty()) {
                        Toast.makeText((Context)ClaasicWinnerActivity.this, (CharSequence)"No winners found", (int)0).show();
                    }
                    ClaasicWinnerActivity.this.myAdapter.notifyDataSetChanged();
                } else {
                    Toast.makeText((Context)ClaasicWinnerActivity.this, (CharSequence)"No winners found", (int)0).show();
                }
            }

            public void onFailure(Call<ArrayList<Winner_Model>> call, Throwable t) {
                ClaasicWinnerActivity.this.dialog.dismiss();
                Toast.makeText((Context)ClaasicWinnerActivity.this, (CharSequence)("Error: " + t.getMessage()), (int)0).show();
            }
        });
    }
}

