/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Activities;

import android.app.ProgressDialog;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.databinding.ActivityChangePasswordBinding;
import app.firezone.synk.network.model.ApiResponse;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class ChangePasswordActivity
extends AppCompatActivity {
    ActivityChangePasswordBinding binding;
    private MyApi myApi;
    String password;
    long userId;
    ProgressDialog progressDialog;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityChangePasswordBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.binding.backArrow.setOnClickListener(v -> this.finish());
        this.progressDialog = new ProgressDialog((Context)this);
        this.progressDialog.setTitle((CharSequence)"Update Started");
        this.progressDialog.setMessage((CharSequence)"Please wait.....");
        this.password = this.getIntent().getStringExtra("password");
        this.userId = this.getIntent().getLongExtra("userId", 0L);
        this.binding.btnChangePass.setOnClickListener(v -> {
            String currentPass = this.binding.previousPass.getText().toString().trim();
            String pass1 = this.binding.pass1.getText().toString().trim();
            String pass2 = this.binding.pass2.getText().toString().trim();
            if (currentPass.isEmpty() || pass1.isEmpty() || pass2.isEmpty()) {
                Toast.makeText((Context)this, (CharSequence)"All fields are required", (int)0).show();
                return;
            }
            if (!pass1.equals(pass2)) {
                this.binding.pass1.setError((CharSequence)"Passwords do not match");
                this.binding.pass2.setError((CharSequence)"Passwords do not match");
                Toast.makeText((Context)this, (CharSequence)"Password and Confirm Password do not match.", (int)0).show();
                return;
            }
            this.changesPassword(pass1, currentPass);
        });
    }

    private void changesPassword(String newPass, String currentPass) {
        this.myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        Call<ApiResponse> call = this.myApi.changePassword(this.userId, currentPass, newPass);
        this.progressDialog.show();
        call.enqueue((Callback)new Callback<ApiResponse>(){

            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                ChangePasswordActivity.this.progressDialog.dismiss();
                if (response.isSuccessful() && response.body() != null) {
                    if (((ApiResponse)response.body()).getStatus() == 200) {
                        Toast.makeText((Context)ChangePasswordActivity.this, (CharSequence)"Password updated successfully!", (int)0).show();
                        ChangePasswordActivity.this.finish();
                    } else {
                        Toast.makeText((Context)ChangePasswordActivity.this, (CharSequence)((ApiResponse)response.body()).getMessage(), (int)0).show();
                    }
                } else {
                    Toast.makeText((Context)ChangePasswordActivity.this, (CharSequence)("Error: " + response.errorBody()), (int)0).show();
                }
            }

            public void onFailure(Call<ApiResponse> call, Throwable t) {
                ChangePasswordActivity.this.progressDialog.dismiss();
                Toast.makeText((Context)ChangePasswordActivity.this, (CharSequence)("Request failed: " + t.getMessage()), (int)0).show();
            }
        });
    }
}

