/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Activities;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Activities.Add_Money_Activity;
import app.firezone.synk.network.databinding.ActivityCashupiBinding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.TransactionModel;
import app.firezone.synk.network.model.User;
import app.firezone.synk.network.model.UserResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;

public class CashupiActivity
extends AppCompatActivity {
    private ActivityCashupiBinding binding;
    private Long currentCoin;
    private Long currentDepo;
    String userToken;
    MyApi myApi;
    long userId;
    private String amount;
    private String phoneno;
    private String transactionId;
    private String email;
    private Dialog dialog;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityCashupiBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        this.loadData();
        this.userId = SharedPrefManager.getInstance((Context)this).getUserId();
        this.amount = this.getIntent().getStringExtra("amount");
        this.phoneno = this.getIntent().getStringExtra("Phoneno");
        this.userToken = this.getIntent().getStringExtra("apiKey");
        this.dialog = new Dialog((Context)this);
        this.dialog.setContentView(2131558570);
        this.dialog.show();
        if (this.dialog.getWindow() != null) {
            this.dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.dialog.setCancelable(false);
        }
        this.transactionId = "TRAN" + System.currentTimeMillis();
        String orderId = "Order" + System.currentTimeMillis();
        this.createOrder(this.amount, orderId, this.phoneno);
    }

    private void createOrder(String amount, String orderId, String phoneno) {
        new OrderApiTask().execute(new String[]{phoneno, this.userToken, amount, orderId, "https://cashupi.com/success", "Production", this.getString(2131951651)});
    }

    private void checkOrderStatus(String orderId, String amount, String phoneno) {
        String apiUrl = "https://cashupi.com/api/check-order-status";
        String payload = "user_token=" + this.userToken + "&order_id=" + orderId;
        RequestBody formBody = RequestBody.create((MediaType)MediaType.parse((String)"application/x-www-form-urlencoded"), (String)payload);
        Request request = new Request.Builder().url(apiUrl).post(formBody).build();
        new Thread(() -> {
            OkHttpClient client = new OkHttpClient();
            try (Response response = client.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw new IOException("Unexpected HTTP response: " + response.code());
                }
                String responseBody = response.body().string();
                JSONObject jsonResponse = new JSONObject(responseBody);
                this.runOnUiThread(() -> {
                    try {
                        String status = jsonResponse.optString("status");
                        String message = jsonResponse.optString("message");
                        if ("true".equals(status)) {
                            JSONObject result = jsonResponse.getJSONObject("result");
                            String txnStatus = result.optString("txnStatus");
                            String resultInfo = result.optString("resultInfo");
                            String receivedOrderId = result.optString("orderId");
                            String receivedAmount = result.optString("amount");
                            if ("SUCCESS".equals(txnStatus)) {
                                this.updateWalletBalance(phoneno, Double.parseDouble(amount));
                            } else {
                                Toast.makeText((Context)this, (CharSequence)("Transaction failed: " + resultInfo), (int)1).show();
                            }
                        } else {
                            Toast.makeText((Context)this, (CharSequence)("Order is not completed: " + message), (int)1).show();
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        Toast.makeText((Context)this, (CharSequence)("Error parsing response: " + e.getMessage()), (int)1).show();
                    }
                });
            }
            catch (IOException | JSONException e) {
                e.printStackTrace();
                this.runOnUiThread(() -> this.lambda$checkOrderStatus$1((Exception)e));
            }
        }).start();
    }

    private void updateWalletBalance(String phoneno, double amount) {
        double finalCoins = (double)this.currentDepo.longValue() + amount;
        HashMap<String, Object> updateData = new HashMap<String, Object>();
        updateData.put("depoBalance", finalCoins);
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        Call<UserResponse> call = myApi.updateUser(this.userId, updateData);
        call.enqueue((Callback)new Callback<UserResponse>(){

            public void onResponse(Call<UserResponse> call, retrofit2.Response<UserResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    if (((UserResponse)response.body()).isSuccess()) {
                        CashupiActivity.this.saveUsersTransactionDetails();
                        Toast.makeText((Context)CashupiActivity.this, (CharSequence)"Payment Successful", (int)0).show();
                    } else {
                        Toast.makeText((Context)CashupiActivity.this, (CharSequence)((UserResponse)response.body()).getMessage(), (int)0).show();
                    }
                } else {
                    Toast.makeText((Context)CashupiActivity.this, (CharSequence)"Failed to update balance", (int)0).show();
                }
            }

            public void onFailure(Call<UserResponse> call, Throwable throwable) {
                Toast.makeText((Context)CashupiActivity.this, (CharSequence)("Error: " + throwable.getMessage()), (int)0).show();
            }
        });
    }

    private void saveUsersTransactionDetails() {
        long userIdLong = SharedPrefManager.getInstance((Context)this).getUserId();
        String userId = String.valueOf(userIdLong);
        String date = new SimpleDateFormat("dd-MM-yy", Locale.getDefault()).format(Calendar.getInstance().getTime());
        String time = new SimpleDateFormat("HH:mm:ss", Locale.getDefault()).format(Calendar.getInstance().getTime());
        String transactionId = "TRAN" + System.currentTimeMillis();
        String inputCoin = String.valueOf(this.amount);
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        Call<TransactionModel> call = myApi.storeUserTransaction(userId, "Deposit", this.email, inputCoin, date, time, transactionId, "CashUPI", "Pending");
        call.enqueue((Callback)new Callback<TransactionModel>(){

            public void onResponse(Call<TransactionModel> call, retrofit2.Response<TransactionModel> response) {
                if (response.isSuccessful() && response.body() != null) {
                    Intent intent = new Intent((Context)CashupiActivity.this, Add_Money_Activity.class);
                    intent.setFlags(0x4000000);
                    CashupiActivity.this.startActivity(intent);
                    CashupiActivity.this.finish();
                    Toast.makeText((Context)CashupiActivity.this, (CharSequence)"Transaction Recorded Successfully", (int)0).show();
                } else {
                    Toast.makeText((Context)CashupiActivity.this, (CharSequence)("Failed to Record Transaction: " + response.message()), (int)0).show();
                }
            }

            public void onFailure(Call<TransactionModel> call, Throwable throwable) {
                Toast.makeText((Context)CashupiActivity.this, (CharSequence)("Error: " + throwable.getMessage()), (int)0).show();
            }
        });
    }

    private void loadData() {
        long userId = SharedPrefManager.getInstance((Context)this).getUserId();
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        Call<ApiResponse> call = myApi.fetchProfileData(userId);
        call.enqueue((Callback)new Callback<ApiResponse>(){

            public void onResponse(Call<ApiResponse> call, retrofit2.Response<ApiResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    User model = ((ApiResponse)response.body()).getUser();
                    CashupiActivity.this.currentCoin = model.getBalance();
                    CashupiActivity.this.currentDepo = model.getDepoBalance();
                    CashupiActivity.this.phoneno = model.getPhoneno();
                    CashupiActivity.this.email = model.getEmail();
                } else {
                    Toast.makeText((Context)CashupiActivity.this, (CharSequence)"Failed to load user data", (int)0).show();
                }
            }

            public void onFailure(Call<ApiResponse> call, Throwable throwable) {
            }
        });
    }

    private /* synthetic */ void lambda$checkOrderStatus$1(Exception e) {
        Toast.makeText((Context)this, (CharSequence)("Order status check failed: " + e.getMessage()), (int)1).show();
    }

    private class OrderApiTask
    extends AsyncTask<String, Void, String> {
        private OrderApiTask() {
        }

        protected String doInBackground(String ... params) {
            try {
                String line;
                URL url = new URL("https://cashupi.com/api/create-order");
                String postData = "customer_mobile=" + URLEncoder.encode(params[0], "UTF-8") + "&user_token=" + URLEncoder.encode(params[1], "UTF-8") + "&amount=" + URLEncoder.encode(params[2], "UTF-8") + "&order_id=" + URLEncoder.encode(params[3], "UTF-8") + "&redirect_url=" + URLEncoder.encode(params[4], "UTF-8") + "&remark1=" + URLEncoder.encode(params[5], "UTF-8") + "&remark2=" + URLEncoder.encode(params[6], "UTF-8");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                conn.getOutputStream().write(postData.getBytes());
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                return response.toString();
            }
            catch (Exception e) {
                Log.e((String)"OrderApiTask", (String)"Error in API call", (Throwable)e);
                return null;
            }
        }

        protected void onPostExecute(String result) {
            block5: {
                super.onPostExecute((Object)result);
                CashupiActivity.this.dialog.dismiss();
                if (result != null) {
                    try {
                        JSONObject jsonResponse = new JSONObject(result);
                        if (jsonResponse.getBoolean("status")) {
                            JSONObject resultObject = jsonResponse.getJSONObject("result");
                            final String orderId = resultObject.getString("orderId");
                            String paymentUrl = resultObject.getString("payment_url");
                            WebView webView = (WebView)CashupiActivity.this.findViewById(2131363098);
                            WebSettings webSettings = webView.getSettings();
                            webSettings.setJavaScriptEnabled(true);
                            webSettings.setDomStorageEnabled(true);
                            webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
                            webSettings.setSupportMultipleWindows(true);
                            webView.setWebViewClient(new WebViewClient(){

                                public void onPageFinished(WebView view, String url) {
                                    super.onPageFinished(view, url);
                                    Toast.makeText((Context)CashupiActivity.this, (CharSequence)"QR Code Generated", (int)0).show();
                                }

                                public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                                    String url = request.getUrl().toString();
                                    if (url.contains("cashupi.com/success")) {
                                        CashupiActivity.this.checkOrderStatus(orderId, CashupiActivity.this.amount, CashupiActivity.this.phoneno);
                                        return true;
                                    }
                                    if (url.startsWith("intent://") || url.startsWith("upi://") || url.startsWith("paytmmp://") || url.startsWith("app://") || url.startsWith("market://")) {
                                        try {
                                            Intent intent = url.startsWith("intent://") ? Intent.parseUri((String)url, (int)1) : new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                                            if (intent.resolveActivity(CashupiActivity.this.getPackageManager()) != null) {
                                                CashupiActivity.this.startActivity(intent);
                                            } else {
                                                Toast.makeText((Context)CashupiActivity.this, (CharSequence)"App not installed to handle this action", (int)0).show();
                                            }
                                            return true;
                                        }
                                        catch (Exception e) {
                                            Log.e((String)"WebView", (String)("Error handling intent: " + url), (Throwable)e);
                                            Toast.makeText((Context)CashupiActivity.this, (CharSequence)"Failed to open app", (int)0).show();
                                            return true;
                                        }
                                    }
                                    view.loadUrl(url);
                                    return true;
                                }

                                public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                                    super.onReceivedError(view, request, error);
                                    Toast.makeText((Context)CashupiActivity.this, (CharSequence)"Failed to load payment page", (int)0).show();
                                }
                            });
                            webView.loadUrl(paymentUrl);
                            break block5;
                        }
                        String message = jsonResponse.getString("message");
                        Toast.makeText((Context)CashupiActivity.this, (CharSequence)("Failed: " + message), (int)0).show();
                    }
                    catch (JSONException e) {
                        Log.e((String)"OrderApiTask", (String)"JSON Parsing Error", (Throwable)e);
                        Toast.makeText((Context)CashupiActivity.this, (CharSequence)"Invalid response from server", (int)0).show();
                    }
                } else {
                    Toast.makeText((Context)CashupiActivity.this, (CharSequence)"Failed to create order", (int)0).show();
                }
            }
        }
    }
}

