/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Activities;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.Adapter.BgmiWinnerAdapter;
import app.firezone.synk.network.Adapter.TopWinnerAdapter;
import app.firezone.synk.network.databinding.ActivityBgmiWinnersBinding;
import app.firezone.synk.network.model.Winner_Model;
import com.google.firebase.database.FirebaseDatabase;
import com.squareup.picasso.Picasso;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class BgmiActivity
extends AppCompatActivity {
    ActivityBgmiWinnersBinding binding;
    BgmiWinnerAdapter winnerAdapter;
    TopWinnerAdapter myAdapter;
    ArrayList<Winner_Model> topWinnerModels = new ArrayList();
    FirebaseDatabase database;
    String gameName;
    String matchId;
    Dialog dialog;

    @SuppressLint(value={"MissingInflatedId"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityBgmiWinnersBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.binding.backArrow.setOnClickListener(v -> this.finish());
        this.database = FirebaseDatabase.getInstance();
        this.topWinnerModels = new ArrayList();
        this.matchId = this.getIntent().getStringExtra("matchid");
        this.gameName = this.getIntent().getStringExtra("gamename");
        String date = this.getIntent().getStringExtra("date");
        String time = this.getIntent().getStringExtra("time");
        String matchno = this.getIntent().getStringExtra("matchno");
        String images = this.getIntent().getStringExtra("images");
        Picasso.get().load(images).placeholder(2131231037).into(this.binding.imageView5);
        this.binding.dateTxt.setText((CharSequence)date);
        this.binding.timeTxt.setText((CharSequence)time);
        this.binding.gameName.setText((CharSequence)(this.gameName + " " + matchno));
        this.dialog = new Dialog((Context)this);
        this.dialog.setContentView(2131558570);
        if (this.dialog.getWindow() != null) {
            this.dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.dialog.setCancelable(true);
        }
        this.dialog.show();
        LinearLayoutManager layoutManager2 = new LinearLayoutManager((Context)this);
        this.binding.topWinersRecy.setLayoutManager((RecyclerView.LayoutManager)layoutManager2);
        this.myAdapter = new TopWinnerAdapter(this.topWinnerModels, (Context)this);
        this.binding.topWinersRecy.setAdapter((RecyclerView.Adapter)this.myAdapter);
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        myApi.fetchResultMatchUserData(Long.parseLong(this.matchId)).enqueue((Callback)new Callback<ArrayList<Winner_Model>>(){

            public void onResponse(Call<ArrayList<Winner_Model>> call, Response<ArrayList<Winner_Model>> response) {
                BgmiActivity.this.dialog.dismiss();
                if (response.isSuccessful() && response.body() != null) {
                    BgmiActivity.this.topWinnerModels.clear();
                    for (Winner_Model winner : (ArrayList)response.body()) {
                        if (!"Winner".equalsIgnoreCase(winner.getPlayerStatus())) continue;
                        BgmiActivity.this.topWinnerModels.add(winner);
                    }
                    if (BgmiActivity.this.topWinnerModels.isEmpty()) {
                        Toast.makeText((Context)BgmiActivity.this, (CharSequence)"No winners found", (int)0).show();
                    }
                    BgmiActivity.this.myAdapter.notifyDataSetChanged();
                } else {
                    Toast.makeText((Context)BgmiActivity.this, (CharSequence)"No winners found", (int)0).show();
                }
            }

            public void onFailure(Call<ArrayList<Winner_Model>> call, Throwable t) {
                BgmiActivity.this.dialog.dismiss();
                Toast.makeText((Context)BgmiActivity.this, (CharSequence)("Error: " + t.getMessage()), (int)0).show();
            }
        });
        LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this);
        this.binding.winersRecy.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.winnerAdapter = new BgmiWinnerAdapter(this.topWinnerModels, (Context)this);
        this.binding.winersRecy.setAdapter((RecyclerView.Adapter)this.winnerAdapter);
        myApi.fetchResultMatchUserData(Long.parseLong(this.matchId)).enqueue((Callback)new Callback<ArrayList<Winner_Model>>(){

            public void onResponse(Call<ArrayList<Winner_Model>> call, Response<ArrayList<Winner_Model>> response) {
                if (response.isSuccessful() && response.body() != null) {
                    BgmiActivity.this.topWinnerModels.clear();
                    BgmiActivity.this.topWinnerModels.addAll((Collection)response.body());
                    Collections.sort(BgmiActivity.this.topWinnerModels, new Comparator<Winner_Model>(){

                        @Override
                        public int compare(Winner_Model w1, Winner_Model w2) {
                            return Integer.compare(Integer.parseInt(w1.getPrize()), Integer.parseInt(w2.getPrize()));
                        }
                    });
                    Collections.reverse(BgmiActivity.this.topWinnerModels);
                    BgmiActivity.this.winnerAdapter.notifyDataSetChanged();
                } else {
                    Toast.makeText((Context)BgmiActivity.this, (CharSequence)"No winners found", (int)0).show();
                }
            }

            public void onFailure(Call<ArrayList<Winner_Model>> call, Throwable t) {
                Toast.makeText((Context)BgmiActivity.this, (CharSequence)("Data Not Load: " + t.getMessage()), (int)0).show();
            }
        });
    }
}

