/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Activities;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.databinding.ActivityAppUpdateBinding;
import app.firezone.synk.network.model.AppModel;
import java.util.ArrayList;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class AppUpdateActivity
extends AppCompatActivity {
    ActivityAppUpdateBinding binding;
    String updateLink;
    Dialog dialog;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityAppUpdateBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.binding.updateBtn.setEnabled(false);
        this.dialog = new Dialog((Context)this);
        this.dialog.setContentView(2131558570);
        if (this.dialog.getWindow() != null) {
            this.dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.dialog.setCancelable(false);
        }
        this.dialog.show();
        this.loadData();
        this.binding.updateBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (AppUpdateActivity.this.updateLink != null && !AppUpdateActivity.this.updateLink.isEmpty()) {
                    Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)AppUpdateActivity.this.updateLink));
                    AppUpdateActivity.this.startActivity(browserIntent);
                } else {
                    Toast.makeText((Context)AppUpdateActivity.this, (CharSequence)"Update link not available yet. Please try again shortly.", (int)0).show();
                }
            }
        });
    }

    private void loadData() {
        MyApi myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        Call<ArrayList<AppModel>> call = myApi.fetchAppSetting();
        call.enqueue((Callback)new Callback<ArrayList<AppModel>>(){

            public void onResponse(Call<ArrayList<AppModel>> call, Response<ArrayList<AppModel>> response) {
                AppUpdateActivity.this.dialog.dismiss();
                if (response.isSuccessful() && response.body() != null && !((ArrayList)response.body()).isEmpty()) {
                    AppModel model = (AppModel)((ArrayList)response.body()).get(0);
                    AppUpdateActivity.this.updateLink = model.getUpdateLink();
                    AppUpdateActivity.this.binding.updateBtn.setEnabled(true);
                } else {
                    Toast.makeText((Context)AppUpdateActivity.this, (CharSequence)"No data found", (int)0).show();
                }
            }

            public void onFailure(Call<ArrayList<AppModel>> call, Throwable throwable) {
                AppUpdateActivity.this.dialog.dismiss();
                Toast.makeText((Context)AppUpdateActivity.this, (CharSequence)("Error: " + throwable.getMessage()), (int)0).show();
            }
        });
    }
}

