/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.Activities;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Activities.CashupiActivity;
import app.firezone.synk.network.Activities.LoginActivity;
import app.firezone.synk.network.databinding.ActivityAddMoneyBinding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.PaymentModel;
import app.firezone.synk.network.model.User;
import java.util.ArrayList;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class Add_Money_Activity
extends AppCompatActivity {
    EditText enterAmount;
    String userMobile = "";
    String apiKey = "";
    String depoCurentCoin = "";
    Dialog dialog;
    MyApi myApi;
    long minDeposit = 0L;
    ActivityAddMoneyBinding binding;
    TextView availBalance;

    @SuppressLint(value={"MissingInflatedId"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityAddMoneyBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        this.binding.backArrow.setOnClickListener(v -> this.finish());
        this.enterAmount = this.binding.enterAmount;
        this.binding.addMoneyBtn.setEnabled(false);
        this.dialog = new Dialog((Context)this);
        this.dialog.setContentView(2131558570);
        if (this.dialog.getWindow() != null) {
            this.dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        }
        this.dialog.setCancelable(false);
        this.dialog.show();
        this.loadUserData();
        this.setMinimumWithdrawal();
        this.binding.hundred.setOnClickListener(view -> this.enterAmount.setText((CharSequence)"100"));
        this.binding.fifty.setOnClickListener(view -> this.enterAmount.setText((CharSequence)"50"));
        this.binding.ten.setOnClickListener(view -> this.enterAmount.setText((CharSequence)"10"));
        this.binding.addMoneyBtn.setOnClickListener(view -> {
            String enter_amount = this.enterAmount.getText().toString().trim();
            if (TextUtils.isEmpty((CharSequence)enter_amount)) {
                this.enterAmount.setError((CharSequence)"Enter any amount");
                Toast.makeText((Context)this, (CharSequence)"Enter Amount", (int)0).show();
                return;
            }
            int enteredAmount = Integer.parseInt(enter_amount);
            if ((long)enteredAmount < this.minDeposit) {
                this.enterAmount.setError((CharSequence)("Add Minimum \u20b9" + this.minDeposit));
                Toast.makeText((Context)this, (CharSequence)("Add Minimum \u20b9" + this.minDeposit), (int)0).show();
                return;
            }
            if (this.apiKey == null || this.apiKey.isEmpty()) {
                Toast.makeText((Context)this, (CharSequence)"Wait... Api Key not loaded yet", (int)0).show();
                return;
            }
            Intent intent = new Intent((Context)this, CashupiActivity.class);
            intent.putExtra("amount", String.valueOf(enteredAmount));
            intent.putExtra("Phoneno", this.userMobile);
            intent.putExtra("apiKey", this.apiKey);
            this.startActivity(intent);
            this.finish();
        });
    }

    private void setMinimumWithdrawal() {
        Call<ArrayList<PaymentModel>> call = this.myApi.fetchPaymentSetting();
        call.enqueue((Callback)new Callback<ArrayList<PaymentModel>>(){

            public void onResponse(Call<ArrayList<PaymentModel>> call, Response<ArrayList<PaymentModel>> response) {
                Add_Money_Activity.this.dialog.dismiss();
                if (response.isSuccessful() && response.body() != null && !((ArrayList)response.body()).isEmpty()) {
                    PaymentModel model = (PaymentModel)((ArrayList)response.body()).get(0);
                    Add_Money_Activity.this.minDeposit = model.getMinDeposit();
                    Add_Money_Activity.this.apiKey = model.getApikey();
                    Add_Money_Activity.this.binding.addMoneyBtn.setEnabled(true);
                    Log.d((String)"AddMoney", (String)("ApiKey Loaded: " + Add_Money_Activity.this.apiKey));
                    Log.d((String)"AddMoney", (String)("MinDeposit Loaded: " + Add_Money_Activity.this.minDeposit));
                } else {
                    Toast.makeText((Context)Add_Money_Activity.this, (CharSequence)"Failed to fetch payment settings", (int)0).show();
                }
            }

            public void onFailure(Call<ArrayList<PaymentModel>> call, Throwable throwable) {
                Add_Money_Activity.this.dialog.dismiss();
                Toast.makeText((Context)Add_Money_Activity.this, (CharSequence)("Error: " + throwable.getMessage()), (int)0).show();
            }
        });
    }

    private void loadUserData() {
        long userId = SharedPrefManager.getInstance((Context)this).getUserId();
        if (userId == -1L) {
            Toast.makeText((Context)this, (CharSequence)"User not found. Please log in again.", (int)0).show();
            this.startActivity(new Intent((Context)this, LoginActivity.class));
            this.finish();
            return;
        }
        this.myApi = (MyApi)APIClient.getApiClient(this.getApplicationContext()).create(MyApi.class);
        Call<ApiResponse> call = this.myApi.fetchProfileData(userId);
        call.enqueue((Callback)new Callback<ApiResponse>(){

            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    ApiResponse apiResponse = (ApiResponse)response.body();
                    if (apiResponse.getStatus() == 200 && apiResponse.getUser() != null) {
                        User model = apiResponse.getUser();
                        Add_Money_Activity.this.userMobile = model.getPhoneno();
                    } else {
                        Toast.makeText((Context)Add_Money_Activity.this, (CharSequence)apiResponse.getMessage(), (int)0).show();
                    }
                } else {
                    Toast.makeText((Context)Add_Money_Activity.this, (CharSequence)"Failed to load user data", (int)0).show();
                }
            }

            public void onFailure(Call<ApiResponse> call, Throwable t) {
                Toast.makeText((Context)Add_Money_Activity.this, (CharSequence)"Something went wrong. Try again later.", (int)0).show();
            }
        });
    }
}

