/*
 * Decompiled with CFR 0.152.
 */
package app.firezone.synk.network.API;

import android.content.Context;
import android.content.SharedPreferences;
import android.security.keystore.KeyGenParameterSpec;
import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKeys;
import java.io.IOException;
import java.security.GeneralSecurityException;

public class SharedPrefManager {
    private static final String SHARED_PREF_NAME = "secure_user_data";
    private static final String KEY_USER_ID = "user_id";
    private static final String KEY_ACCESS_TOKEN = "access_token";
    private static SharedPrefManager instance;
    private final SharedPreferences sharedPreferences;

    private SharedPrefManager(Context context) {
        SharedPreferences tempPrefs = null;
        try {
            String masterKeyAlias = MasterKeys.getOrCreate((KeyGenParameterSpec)MasterKeys.AES256_GCM_SPEC);
            tempPrefs = EncryptedSharedPreferences.create((String)SHARED_PREF_NAME, (String)masterKeyAlias, (Context)context, (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
        }
        catch (IOException | GeneralSecurityException e) {
            e.printStackTrace();
        }
        this.sharedPreferences = tempPrefs;
    }

    public static synchronized SharedPrefManager getInstance(Context context) {
        if (instance == null) {
            instance = new SharedPrefManager(context.getApplicationContext());
        }
        return instance;
    }

    public void saveUserId(long userId) {
        this.sharedPreferences.edit().putLong(KEY_USER_ID, userId).apply();
    }

    public long getUserId() {
        return this.sharedPreferences.getLong(KEY_USER_ID, -1L);
    }

    public void saveAccessToken(String token) {
        this.sharedPreferences.edit().putString(KEY_ACCESS_TOKEN, token).apply();
    }

    public String getAccessToken() {
        return this.sharedPreferences.getString(KEY_ACCESS_TOKEN, null);
    }

    public void clear() {
        this.sharedPreferences.edit().clear().apply();
    }
}

